/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbManager;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbException;

public class LynxUsbUtil {
    private static final String TAG = "LynxUsbUtil";

    public static RobotUsbDevice openUsbDevice(boolean doScan, RobotUsbManager robotUsbManager, SerialNumber serialNumber) throws RobotCoreException {
        if (doScan) {
            robotUsbManager.scanForDevices();
        }
        RobotUsbDevice result = null;
        try {
            result = robotUsbManager.openBySerialNumber(serialNumber);
        }
        catch (RobotCoreException e) {
            LynxUsbUtil.logMessageAndThrow("unable to open lynx USB device " + serialNumber + ": " + e.getMessage());
        }
        try {
            result.setBaudRate(460800);
            result.setDataCharacteristics((byte)8, (byte)0, (byte)0);
            result.setLatencyTimer(1);
        }
        catch (RobotUsbException e) {
            result.close();
            LynxUsbUtil.logMessageAndThrow("Unable to open lynx USB device " + serialNumber + " - " + result.getProductName() + ": " + e.getMessage());
        }
        return result;
    }

    private static void logMessageAndThrow(String message) throws RobotCoreException {
        RobotLog.ee((String)TAG, (String)message);
        throw new RobotCoreException(message);
    }

    public static <T> T makePlaceholderValue(T t) {
        return t;
    }

    public static class Placeholder<T> {
        private String tag;
        private String message;
        private boolean logged;

        public Placeholder(String tag, String format, Object ... args) {
            this.tag = tag;
            this.message = String.format("placeholder: %s", String.format(format, args));
            this.logged = false;
        }

        public synchronized void reset() {
            this.logged = false;
        }

        public synchronized T log(T t) {
            if (!this.logged) {
                RobotLog.ee((String)this.tag, (String)this.message);
                this.logged = true;
            }
            return t;
        }
    }
}

