/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCResponse;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.VoltageSensor;

public class LynxVoltageSensor
extends LynxController
implements VoltageSensor {
    public static final String TAG = "LynxVoltageSensor";

    @Override
    protected String getTag() {
        return TAG;
    }

    public LynxVoltageSensor(Context context, LynxModule module) throws RobotCoreException, InterruptedException {
        super(context, module);
        this.finishConstruction();
    }

    @Override
    public String getDeviceName() {
        return this.context.getString(R.string.lynxVoltageSensorDisplayName);
    }

    public double getVoltage() {
        LynxGetADCCommand command = new LynxGetADCCommand(this.getModule(), LynxGetADCCommand.Channel.BATTERY_MONITOR, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            int mv = response.getValue();
            return (double)mv * 0.001;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }
}

