/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands;

import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.robotcore.util.TypeConversion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.firstinspires.ftc.robotcore.internal.hardware.TimeWindow;

public abstract class LynxMessage {
    protected LynxModuleIntf module;
    protected byte messageNumber;
    protected byte referenceNumber;
    protected LynxDatagram serialization;
    protected boolean hasBeenTransmitted;
    protected long nanotimeLastTransmit;
    protected TimeWindow payloadTimeWindow;

    public LynxMessage(LynxModuleIntf module) {
        this.module = module;
        this.messageNumber = 0;
        this.referenceNumber = 0;
        this.serialization = null;
        this.hasBeenTransmitted = false;
        this.nanotimeLastTransmit = 0L;
        this.setPayloadTimeWindow(null);
    }

    public static Object invokeStaticNullaryMethod(Class clazz, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
        int requiredModifiers = 9;
        int prohibitedModifiers = 1024;
        if ((method.getModifiers() & requiredModifiers) == requiredModifiers && (method.getModifiers() & prohibitedModifiers) == 0) {
            return method.invoke(null, new Object[0]);
        }
        throw new IllegalAccessException("incorrect modifiers");
    }

    public int getDestModuleAddress() {
        return this.getModule().getModuleAddress();
    }

    public void noteHasBeenTransmitted() {
        this.hasBeenTransmitted = true;
    }

    public boolean hasBeenTransmitted() {
        return this.hasBeenTransmitted;
    }

    public long getNanotimeLastTransmit() {
        return this.nanotimeLastTransmit;
    }

    public void setNanotimeLastTransmit(long value) {
        this.nanotimeLastTransmit = value;
    }

    public void acquireNetworkLock() throws InterruptedException {
        this.module.acquireNetworkTransmissionLock(this);
    }

    public void releaseNetworkLock() throws InterruptedException {
        this.module.releaseNetworkTransmissionLock(this);
    }

    public void onPretendTransmit() throws InterruptedException {
    }

    public void resetModulePingTimer() {
        this.module.resetPingTimer(this);
    }

    public LynxModuleIntf getModule() {
        return this.module;
    }

    public void setModule(LynxModule module) {
        this.module = module;
    }

    public int getModuleAddress() {
        return this.module.getModuleAddress();
    }

    public int getMessageNumber() {
        return TypeConversion.unsignedByteToInt((byte)this.messageNumber);
    }

    public void setMessageNumber(int value) {
        this.messageNumber = (byte)value;
    }

    public int getReferenceNumber() {
        return TypeConversion.unsignedByteToInt((byte)this.referenceNumber);
    }

    public void setReferenceNumber(int value) {
        this.referenceNumber = (byte)value;
    }

    public TimeWindow getPayloadTimeWindow() {
        return this.payloadTimeWindow;
    }

    public void setPayloadTimeWindow(TimeWindow payloadTimeWindow) {
        this.payloadTimeWindow = payloadTimeWindow;
    }

    public LynxDatagram getSerialization() {
        return this.serialization;
    }

    public void forgetSerialization() {
        this.setSerialization(null);
    }

    public void setSerialization(LynxDatagram datagram) {
        this.serialization = datagram;
    }

    public void loadFromSerialization() {
        this.setPayloadTimeWindow(this.serialization.getPayloadTimeWindow());
        this.fromPayloadByteArray(this.serialization.getPayloadData());
        this.setMessageNumber(this.serialization.getMessageNumber());
        this.setReferenceNumber(this.serialization.getReferenceNumber());
    }

    public abstract int getCommandNumber();

    public abstract byte[] toPayloadByteArray();

    public abstract void fromPayloadByteArray(byte[] var1);

    public boolean isAckable() {
        return false;
    }

    public boolean isAck() {
        return false;
    }

    public boolean isNack() {
        return false;
    }

    public boolean isResponseExpected() {
        return false;
    }

    public boolean isResponse() {
        return false;
    }

    public abstract boolean isDangerous();
}

