/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceResponse;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;

public class LynxGetAllDIOInputsResponse
extends LynxDekaInterfaceResponse {
    private static final int cbPayload = 1;
    private byte bits = 0;

    public LynxGetAllDIOInputsResponse(LynxModuleIntf module) {
        super(module);
    }

    public boolean getPin(int pin) {
        LynxConstants.validateDigitalIOZ((int)pin);
        int bit = 1 << pin;
        return (this.bits & bit) != 0;
    }

    public int getAllPins() {
        return TypeConversion.unsignedByteToInt((byte)this.bits);
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(1).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.bits);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.bits = buffer.get();
    }
}

