/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceResponse;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxGetMotorChannelModeResponse
extends LynxDekaInterfaceResponse {
    private static final int cbPayload = 2;
    private byte mode;
    private byte floatAtZero;

    public LynxGetMotorChannelModeResponse(LynxModuleIntf module) {
        super(module);
    }

    public DcMotor.RunMode getMode() {
        return LynxConstants.lynxMotorModeToRunMode((byte)this.mode);
    }

    public DcMotor.ZeroPowerBehavior getZeroPowerBehavior() {
        return this.floatAtZero == 0 ? DcMotor.ZeroPowerBehavior.BRAKE : DcMotor.ZeroPowerBehavior.FLOAT;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.mode);
        buffer.put(this.floatAtZero);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.mode = buffer.get();
        this.floatAtZero = buffer.get();
    }
}

