/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceResponse;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;

public class LynxGetMotorTargetPositionResponse
extends LynxDekaInterfaceResponse {
    private static final int cbPayload = 6;
    private int target;
    private short tolerance;

    public LynxGetMotorTargetPositionResponse(LynxModuleIntf module) {
        super(module);
    }

    public int getTarget() {
        return this.target;
    }

    public int getTolerance() {
        return TypeConversion.unsignedShortToInt((short)this.tolerance);
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(6).order(LynxDatagram.LYNX_ENDIAN);
        buffer.putInt(this.target);
        buffer.putShort(this.tolerance);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.target = buffer.getInt();
        this.tolerance = buffer.getShort();
    }
}

