/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cConfigureQueryResponse;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxI2cConfigureQueryCommand
extends LynxDekaInterfaceCommand<LynxI2cConfigureQueryResponse> {
    public static final int cbPayload = 1;
    private byte i2cBus;

    public LynxI2cConfigureQueryCommand(LynxModuleIntf module, int busZ) {
        super(module, LynxI2cConfigureQueryResponse.createDefaultResponse(module));
        LynxConstants.validateI2cBusZ((int)busZ);
        this.i2cBus = (byte)busZ;
    }

    public static Class<? extends LynxInterfaceResponse> getResponseClass() {
        return LynxI2cConfigureQueryResponse.class;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(1).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.i2cBus);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.i2cBus = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

