/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxI2cReadMultipleBytesCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 3;
    public static final int cbPayloadFirst = 1;
    public static final int cbPayloadLast = 100;
    private byte i2cBus;
    private byte i2cAddr7Bit;
    private byte cbToRead;

    public LynxI2cReadMultipleBytesCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxI2cReadMultipleBytesCommand(LynxModuleIntf module, int busZ, I2cAddr i2cAddr, int cbToRead) {
        this(module);
        LynxConstants.validateI2cBusZ((int)busZ);
        if (cbToRead < 1 || cbToRead > 100) {
            throw new IllegalArgumentException(String.format("illegal payload length: %d", cbToRead));
        }
        this.i2cBus = (byte)busZ;
        this.i2cAddr7Bit = (byte)i2cAddr.get7Bit();
        this.cbToRead = (byte)cbToRead;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.i2cBus);
        buffer.put(this.i2cAddr7Bit);
        buffer.put(this.cbToRead);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.i2cBus = buffer.get();
        this.i2cAddr7Bit = buffer.get();
        this.cbToRead = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

