/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxI2cReadSingleByteCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 2;
    private byte i2cBus;
    private byte i2cAddr7Bit;

    public LynxI2cReadSingleByteCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxI2cReadSingleByteCommand(LynxModuleIntf module, int busZ, I2cAddr i2cAddr) {
        this(module);
        LynxConstants.validateI2cBusZ((int)busZ);
        this.i2cBus = (byte)busZ;
        this.i2cAddr7Bit = (byte)i2cAddr.get7Bit();
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.i2cBus);
        buffer.put(this.i2cAddr7Bit);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.i2cBus = buffer.get();
        this.i2cAddr7Bit = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

