/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class LynxI2cWriteMultipleBytesCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbFixed = 3;
    public static final int cbPayloadFirst = 1;
    public static final int cbPayloadLast = 100;
    private byte i2cBus;
    private byte i2cAddr7Bit;
    private byte[] payload;

    public LynxI2cWriteMultipleBytesCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxI2cWriteMultipleBytesCommand(LynxModuleIntf module, int busZ, I2cAddr i2cAddr, byte[] payload) {
        this(module);
        LynxConstants.validateI2cBusZ((int)busZ);
        if (payload.length < 1 || payload.length > 100) {
            throw new IllegalArgumentException(String.format("illegal payload length: %d", payload.length));
        }
        this.i2cBus = (byte)busZ;
        this.i2cAddr7Bit = (byte)i2cAddr.get7Bit();
        this.payload = Arrays.copyOf(payload, payload.length);
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3 + this.payload.length).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.i2cBus);
        buffer.put(this.i2cAddr7Bit);
        buffer.put((byte)this.payload.length);
        buffer.put(this.payload);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.i2cBus = buffer.get();
        this.i2cAddr7Bit = buffer.get();
        int cbPayload = TypeConversion.unsignedByteToInt((byte)buffer.get());
        this.payload = new byte[cbPayload];
        buffer.get(this.payload);
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

