/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import androidx.annotation.Nullable;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class LynxReadVersionStringResponse
extends LynxDekaInterfaceResponse {
    private byte cbText = 0;
    private byte[] rgbText = null;

    public LynxReadVersionStringResponse(LynxModuleIntf module) {
        super(module);
    }

    @Nullable
    public String getNullableVersionString() {
        if (this.rgbText == null) {
            return null;
        }
        return new String(this.rgbText, Charset.forName("UTF-8"));
    }

    @Override
    public byte[] toPayloadByteArray() {
        int cbPayload = 1 + (this.rgbText == null ? 0 : this.rgbText.length);
        ByteBuffer buffer = ByteBuffer.allocate(cbPayload).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.cbText);
        if (this.rgbText != null) {
            buffer.put(this.rgbText);
        }
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.cbText = buffer.get();
        this.rgbText = new byte[this.cbText];
        buffer.get(this.rgbText);
    }
}

