/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.DigitalChannel;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetDIODirectionCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public final int cbPayload = 2;
    private int pin;
    private int direction;

    public LynxSetDIODirectionCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetDIODirectionCommand(LynxModuleIntf module, int pin, DigitalChannel.Mode mode) {
        this(module);
        LynxConstants.validateDigitalIOZ((int)pin);
        this.pin = pin;
        this.direction = mode == DigitalChannel.Mode.INPUT ? 0 : 1;
    }

    public int getPin() {
        return this.pin;
    }

    public DigitalChannel.Mode getMode() {
        return this.direction == 0 ? DigitalChannel.Mode.INPUT : DigitalChannel.Mode.OUTPUT;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put((byte)this.pin);
        buffer.put((byte)this.direction);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.pin = buffer.get();
        this.direction = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

