/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetMotorPIDControlLoopCoefficientsCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    private static final int cbPayload = 14;
    private byte motor;
    private byte mode;
    private int p;
    private int i;
    private int d;

    public LynxSetMotorPIDControlLoopCoefficientsCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorPIDControlLoopCoefficientsCommand(LynxModuleIntf module, int motorZ, DcMotor.RunMode mode, int p, int i, int d) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        this.motor = (byte)motorZ;
        switch (mode) {
            case RUN_USING_ENCODER: {
                this.mode = 1;
                break;
            }
            case RUN_TO_POSITION: {
                this.mode = (byte)2;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("illegal mode: %s", mode.toString()));
            }
        }
        this.p = p;
        this.i = i;
        this.d = d;
    }

    public static int internalCoefficientFromExternal(double coefficient) {
        return (int)(Math.abs(coefficient) * 65536.0 + 0.5) * (int)Math.signum(coefficient);
    }

    public static double externalCoefficientFromInternal(int coefficient) {
        return (double)coefficient / 65536.0;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(14).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.put(this.mode);
        buffer.putInt(this.p);
        buffer.putInt(this.i);
        buffer.putInt(this.d);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.mode = buffer.get();
        this.p = buffer.getInt();
        this.i = buffer.getInt();
        this.d = buffer.getInt();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

