/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.MotorControlAlgorithm;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetMotorPIDFControlLoopCoefficientsCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    private static final int cbPayload = 19;
    private byte motor;
    private byte mode;
    private int p;
    private int i;
    private int d;
    private int f;
    private byte motorControlAlgorithm;

    public LynxSetMotorPIDFControlLoopCoefficientsCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorPIDFControlLoopCoefficientsCommand(LynxModuleIntf module, int motorZ, DcMotor.RunMode mode, int p, int i, int d, int f, InternalMotorControlAlgorithm motorControlAlgorithm) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        this.motor = (byte)motorZ;
        switch (mode) {
            case RUN_USING_ENCODER: {
                this.mode = 1;
                break;
            }
            case RUN_TO_POSITION: {
                this.mode = (byte)2;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("illegal mode: %s", mode.toString()));
            }
        }
        this.p = p;
        this.i = i;
        this.d = d;
        this.f = f;
        this.motorControlAlgorithm = motorControlAlgorithm.getValue();
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(19).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.put(this.mode);
        buffer.putInt(this.p);
        buffer.putInt(this.i);
        buffer.putInt(this.d);
        buffer.putInt(this.f);
        buffer.put(this.motorControlAlgorithm);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.mode = buffer.get();
        this.p = buffer.getInt();
        this.i = buffer.getInt();
        this.d = buffer.getInt();
        this.f = buffer.getInt();
        this.motorControlAlgorithm = this.motorControlAlgorithm;
    }

    @Override
    public boolean isDangerous() {
        return false;
    }

    public static enum InternalMotorControlAlgorithm {
        First(0),
        LegacyPID(0),
        PIDF(1),
        Max(2),
        NotSet(255);

        private byte value;

        public byte getValue() {
            return this.value;
        }

        private InternalMotorControlAlgorithm(int value) {
            this.value = (byte)value;
        }

        public static InternalMotorControlAlgorithm fromExternal(MotorControlAlgorithm algorithm) {
            switch (algorithm) {
                default: {
                    return NotSet;
                }
                case LegacyPID: {
                    return LegacyPID;
                }
                case PIDF: 
            }
            return PIDF;
        }

        public static InternalMotorControlAlgorithm fromByte(byte bVal) {
            if (bVal == LegacyPID.getValue()) {
                return LegacyPID;
            }
            if (bVal == PIDF.getValue()) {
                return PIDF;
            }
            return NotSet;
        }

        public MotorControlAlgorithm toExternal() {
            switch (this) {
                default: {
                    return MotorControlAlgorithm.Unknown;
                }
                case LegacyPID: {
                    return MotorControlAlgorithm.LegacyPID;
                }
                case PIDF: 
            }
            return MotorControlAlgorithm.PIDF;
        }
    }
}

