/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetMotorTargetPositionCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 7;
    public static final int apiToleranceFirst = 0;
    public static final int apiToleranceLast = 65535;
    private byte motor;
    private int target;
    private short tolerance;

    public LynxSetMotorTargetPositionCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorTargetPositionCommand(LynxModuleIntf module, int motorZ, int target, int tolerance) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        if (tolerance < 0 || tolerance > 65535) {
            throw new IllegalArgumentException(String.format("illegal tolerance: %d", tolerance));
        }
        this.motor = (byte)motorZ;
        this.target = target;
        this.tolerance = (short)tolerance;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(7).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.putInt(this.target);
        buffer.putShort(this.tolerance);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.target = buffer.getInt();
        this.tolerance = buffer.getShort();
    }

    @Override
    public boolean isDangerous() {
        return true;
    }
}

