/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetMotorTargetVelocityCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 3;
    public static final int apiVelocityFirst = -32767;
    public static final int apiVelocityLast = Short.MAX_VALUE;
    private byte motor;
    private short velocity;

    public LynxSetMotorTargetVelocityCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorTargetVelocityCommand(LynxModuleIntf module, int motorZ, int velocity) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        if (velocity < -32767 || velocity > Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("illegal velocity: %d", velocity));
        }
        this.motor = (byte)motorZ;
        this.velocity = (short)velocity;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.putShort(this.velocity);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.velocity = buffer.getShort();
    }

    @Override
    public boolean isDangerous() {
        return this.velocity != 0;
    }
}

