/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetPWMConfigurationCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 3;
    public static final int apiFramePeriodFirst = 0;
    public static final int apiFramePeriodLast = 65535;
    private byte channel;
    private short framePeriod;

    public LynxSetPWMConfigurationCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetPWMConfigurationCommand(LynxModuleIntf module, int channelZ, int framePeriod) {
        this(module);
        LynxConstants.validatePwmChannelZ((int)channelZ);
        if (framePeriod < 0 || framePeriod > 65535) {
            throw new IllegalArgumentException(String.format("illegal frame period: %d", framePeriod));
        }
        this.channel = (byte)channelZ;
        this.framePeriod = (short)framePeriod;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.channel);
        buffer.putShort(this.framePeriod);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.channel = buffer.get();
        this.framePeriod = buffer.getShort();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

