/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetPWMEnableCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 2;
    private byte channel;
    private byte enable;

    public LynxSetPWMEnableCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetPWMEnableCommand(LynxModuleIntf module, int channelZ, boolean enable) {
        this(module);
        LynxConstants.validatePwmChannelZ((int)channelZ);
        this.channel = (byte)channelZ;
        this.enable = enable ? (byte)1 : 0;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.channel);
        buffer.put(this.enable);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.channel = buffer.get();
        this.enable = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return this.enable != 0;
    }
}

