/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetPWMPulseWidthCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 3;
    public static final int apiPulseWidthFirst = 0;
    public static final int apiPulseWidthLast = 65535;
    private byte channel;
    private short pulseWidth;

    public LynxSetPWMPulseWidthCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetPWMPulseWidthCommand(LynxModuleIntf module, int channelZ, int usPulseWidth) {
        this(module);
        LynxConstants.validatePwmChannelZ((int)channelZ);
        if (usPulseWidth < 0 || usPulseWidth > 65535) {
            throw new IllegalArgumentException(String.format("illegal pulse width: %d", usPulseWidth));
        }
        this.channel = (byte)channelZ;
        this.pulseWidth = (short)usPulseWidth;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.channel);
        buffer.putShort(this.pulseWidth);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.channel = buffer.get();
        this.pulseWidth = buffer.getShort();
    }

    @Override
    public boolean isDangerous() {
        return true;
    }
}

