/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.standard;

import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleStatusCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxStandardResponse;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.TypeConversion;

public class LynxGetModuleStatusResponse
extends LynxStandardResponse {
    public static final int bitKeepAliveTimeout = 1;
    public static final int bitDeviceReset = 2;
    public static final int bitFailSafe = 4;
    public static final int bitControllerOverTemp = 8;
    public static final int bitBatteryLow = 16;
    public static final int bitHIBFault = 32;
    byte status;
    byte motorAlerts;

    public LynxGetModuleStatusResponse(LynxModule module) {
        super(module);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendBit(builder, 1, "KeepAliveTimeout");
        this.appendBit(builder, 2, "Reset");
        this.appendBit(builder, 4, "FailSafe");
        this.appendBit(builder, 8, "Temp");
        this.appendBit(builder, 16, "Battery");
        this.appendBit(builder, 32, "HIB Fault");
        String message = builder.toString();
        if (message.length() > 0) {
            message = ": " + message;
        }
        return String.format("LynxGetModuleStatusResponse(status=0x%02x alerts=0x%02x%s)", this.status, this.motorAlerts, message);
    }

    protected void appendBit(StringBuilder builder, int bit, String message) {
        if (this.testBitsOn(bit)) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(message);
        }
    }

    public boolean isKeepAliveTimeout() {
        return this.testBitsOn(1);
    }

    public boolean isDeviceReset() {
        return this.testBitsOn(2);
    }

    public boolean isFailSafe() {
        return this.testBitsOn(4);
    }

    public boolean isControllerOverTemp() {
        return this.testBitsOn(8);
    }

    public boolean isBatteryLow() {
        return this.testBitsOn(16);
    }

    public boolean isHIBFault() {
        return this.testBitsOn(32);
    }

    public int getStatus() {
        return TypeConversion.unsignedByteToInt((byte)this.status);
    }

    public boolean testBitsOn(int bits) {
        return (this.getStatus() & bits) == bits;
    }

    public boolean testAnyBits(int bits) {
        return (this.getStatus() & bits) != 0;
    }

    public int getMotorAlerts() {
        return TypeConversion.unsignedByteToInt((byte)this.motorAlerts);
    }

    public boolean hasMotorLostCounts(int motorZ) {
        LynxConstants.validateMotorZ((int)motorZ);
        int bit = 1 << motorZ;
        return (this.getMotorAlerts() & bit) == bit;
    }

    public boolean isMotorBridgeOverTemp(int motorZ) {
        LynxConstants.validateMotorZ((int)motorZ);
        int bit = 1 << motorZ + 4;
        return (this.getMotorAlerts() & bit) == bit;
    }

    public static int getStandardCommandNumber() {
        return LynxGetModuleStatusCommand.getStandardCommandNumber() | 0x8000;
    }

    @Override
    public int getCommandNumber() {
        return LynxGetModuleStatusResponse.getStandardCommandNumber();
    }

    @Override
    public byte[] toPayloadByteArray() {
        return new byte[]{this.status, this.motorAlerts};
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        this.status = rgb[0];
        this.motorAlerts = rgb[1];
    }
}

