/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.standard;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.robotcore.util.TypeConversion;
import org.firstinspires.ftc.robotcore.internal.system.Assert;

public class LynxNack
extends LynxMessage {
    private int nackReasonCode;

    public LynxNack(LynxModuleIntf module) {
        super(module);
    }

    public LynxNack(LynxModuleIntf module, int nackReasonCode) {
        this(module);
        this.nackReasonCode = nackReasonCode;
    }

    public LynxNack(LynxModuleIntf module, ReasonCode reasonCode) {
        this(module, reasonCode.getValue());
    }

    public ReasonCode getNackReasonCode() {
        if (this.nackReasonCode == StandardReasonCode.I2C_OPERATION_IN_PROGRESS.getValue()) {
            return StandardReasonCode.I2C_OPERATION_IN_PROGRESS;
        }
        if (this.nackReasonCode == StandardReasonCode.I2C_MASTER_BUSY.getValue()) {
            return StandardReasonCode.I2C_MASTER_BUSY;
        }
        for (StandardReasonCode reasonCode : StandardReasonCode.values()) {
            if (this.nackReasonCode != reasonCode.getValue()) continue;
            return reasonCode;
        }
        return new UnrecognizedReasonCode(this.nackReasonCode);
    }

    public StandardReasonCode getNackReasonCodeAsEnum() {
        ReasonCode reasonCode = this.getNackReasonCode();
        if (reasonCode instanceof StandardReasonCode) {
            return (StandardReasonCode)reasonCode;
        }
        return StandardReasonCode.UNRECOGNIZED_REASON_CODE;
    }

    public static int getStandardCommandNumber() {
        return 32514;
    }

    @Override
    public int getCommandNumber() {
        return LynxNack.getStandardCommandNumber();
    }

    @Override
    public byte[] toPayloadByteArray() {
        Assert.assertTrue(((byte)this.nackReasonCode == this.nackReasonCode ? 1 : 0) != 0);
        return new byte[]{(byte)this.nackReasonCode};
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        this.nackReasonCode = TypeConversion.unsignedByteToInt((byte)rgb[0]);
    }

    @Override
    public boolean isNack() {
        return true;
    }

    @Override
    public boolean isDangerous() {
        return false;
    }

    private static class UnrecognizedReasonCode
    implements ReasonCode {
        private final int value;

        UnrecognizedReasonCode(int value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "Unrecognized NACK code " + this.value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public boolean isUnsupportedReason() {
            return true;
        }
    }

    public static enum StandardReasonCode implements ReasonCode
    {
        PARAM0(0),
        PARAM1(1),
        PARAM2(2),
        PARAM3(3),
        PARAM4(4),
        PARAM5(5),
        PARAM6(6),
        PARAM7(7),
        PARAM8(8),
        PARAM9(9),
        GPIO_OUT0(10),
        GPIO_OUT1(11),
        GPIO_OUT2(12),
        GPIO_OUT3(13),
        GPIO_OUT4(14),
        GPIO_OUT5(15),
        GPIO_OUT6(16),
        GPIO_OUT7(17),
        GPIO_NO_OUTPUT(18),
        GPIO_IN0(20),
        GPIO_IN1(21),
        GPIO_IN2(22),
        GPIO_IN3(23),
        GPIO_IN4(24),
        GPIO_IN5(25),
        GPIO_IN6(26),
        GPIO_IN7(27),
        GPIO_NO_INPUT(28),
        SERVO_NOT_CONFIG_BEFORE_ENABLED(30),
        BATTERY_TOO_LOW_TO_RUN_SERVO(31),
        I2C_MASTER_BUSY(40),
        I2C_OPERATION_IN_PROGRESS(41),
        I2C_NO_RESULTS_PENDING(42),
        I2C_QUERY_MISMATCH(43),
        I2C_TIMEOUT_SDA_STUCK(44),
        I2C_TIMEOUT_SCK_STUCK(45),
        I2C_TIMEOUT_UNKNOWN_CAUSE(46),
        MOTOR_NOT_CONFIG_BEFORE_ENABLED(50),
        COMMAND_INVALID_FOR_MOTOR_MODE(51),
        BATTERY_TOO_LOW_TO_RUN_MOTOR(52),
        COMMAND_IMPL_PENDING(253),
        COMMAND_ROUTING_ERROR(254),
        PACKET_TYPE_ID_UNKNOWN(255),
        ABANDONED_WAITING_FOR_RESPONSE(256),
        ABANDONED_WAITING_FOR_ACK(257),
        UNRECOGNIZED_REASON_CODE(258),
        CANCELLED_FOR_SAFETY(259);

        private int iVal;

        private StandardReasonCode(int i) {
            this.iVal = i;
        }

        @Override
        public int getValue() {
            return this.iVal;
        }

        @Override
        public boolean isUnsupportedReason() {
            switch (this) {
                case COMMAND_IMPL_PENDING: 
                case COMMAND_ROUTING_ERROR: 
                case PACKET_TYPE_ID_UNKNOWN: {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface ReasonCode {
        public String toString();

        public int getValue();

        public boolean isUnsupportedReason();
    }
}

