/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.standard;

import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.commands.LynxResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxQueryInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxStandardCommand;
import java.nio.charset.Charset;

public class LynxQueryInterfaceCommand
extends LynxStandardCommand<LynxQueryInterfaceResponse> {
    private String interfaceName;

    public LynxQueryInterfaceCommand(LynxModule module) {
        super(module, new LynxQueryInterfaceResponse(module));
    }

    public LynxQueryInterfaceCommand(LynxModule module, String interfaceName) {
        this(module);
        this.interfaceName = interfaceName;
    }

    void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        if (this.interfaceName != null && this.interfaceName.length() > 0 && this.interfaceName.charAt(this.interfaceName.length() - 1) == '\u0000') {
            this.interfaceName = this.interfaceName.substring(0, this.interfaceName.length() - 1);
        }
    }

    String getInterfaceName() {
        return this.interfaceName;
    }

    String getNullTerminatedInterfaceName() {
        return this.getInterfaceName() + "\u0000";
    }

    public static int getStandardCommandNumber() {
        return 32519;
    }

    public static Class<? extends LynxResponse> getResponseClass() {
        return LynxQueryInterfaceResponse.class;
    }

    @Override
    public int getCommandNumber() {
        return LynxQueryInterfaceCommand.getStandardCommandNumber();
    }

    @Override
    public byte[] toPayloadByteArray() {
        return this.getNullTerminatedInterfaceName().getBytes(Charset.forName("UTF-8"));
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        this.setInterfaceName(new String(rgb, Charset.forName("UTF-8")));
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

