/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics;

import com.qualcomm.robotcore.R;
import com.qualcomm.robotcore.hardware.AnalogInputController;
import com.qualcomm.robotcore.hardware.AnalogSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.OpticalDistanceSensor;
import com.qualcomm.robotcore.hardware.configuration.annotations.AnalogSensorType;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.util.Range;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

@AnalogSensorType
@DeviceProperties(name="@string/configTypeOpticalDistanceSensor", xmlTag="OpticalDistanceSensor", builtIn=true, description="@string/optical_distance_sensor_description")
public class ModernRoboticsAnalogOpticalDistanceSensor
implements OpticalDistanceSensor,
AnalogSensor {
    private final AnalogInputController analogInputController;
    private final int physicalPort;
    protected static final double apiLevelMin = 0.0;
    protected static final double apiLevelMax = 1.0;

    public ModernRoboticsAnalogOpticalDistanceSensor(AnalogInputController analogInputController, int physicalPort) {
        this.analogInputController = analogInputController;
        this.physicalPort = physicalPort;
    }

    public String toString() {
        return String.format("OpticalDistanceSensor: %1.2f", this.getLightDetected());
    }

    public double getLightDetected() {
        return Range.clip((double)Range.scale((double)this.getRawLightDetected(), (double)0.0, (double)this.getRawLightDetectedMax(), (double)0.0, (double)1.0), (double)0.0, (double)1.0);
    }

    public double getMaxVoltage() {
        double sensorMaxVoltage = 5.0;
        return Math.min(5.0, this.analogInputController.getMaxAnalogInputVoltage());
    }

    public double getRawLightDetected() {
        return Range.clip((double)this.readRawVoltage(), (double)0.0, (double)this.getMaxVoltage());
    }

    public double getRawLightDetectedMax() {
        return this.getMaxVoltage();
    }

    public double readRawVoltage() {
        return this.analogInputController.getAnalogInputVoltage(this.physicalPort);
    }

    public void enableLed(boolean enable) {
    }

    public String status() {
        return String.format("Optical Distance Sensor, connected via device %s, port %d", this.analogInputController.getSerialNumber(), this.physicalPort);
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.ModernRobotics;
    }

    public String getDeviceName() {
        return AppUtil.getDefContext().getString(R.string.configTypeOpticalDistanceSensor);
    }

    public String getConnectionInfo() {
        return this.analogInputController.getConnectionInfo() + "; analog port " + this.physicalPort;
    }

    public int getVersion() {
        return 0;
    }

    public void resetDeviceConfigurationForOpMode() {
    }

    public void close() {
    }
}

