/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics;

import androidx.annotation.ColorInt;
import com.qualcomm.robotcore.hardware.ColorSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.NormalizedColorSensor;
import com.qualcomm.robotcore.hardware.NormalizedRGBA;
import com.qualcomm.robotcore.hardware.SwitchableLight;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.util.Range;
import com.qualcomm.robotcore.util.TypeConversion;

public class ModernRoboticsI2cColorSensor
extends I2cDeviceSynchDevice<I2cDeviceSynch>
implements ColorSensor,
NormalizedColorSensor,
SwitchableLight,
I2cAddrConfig {
    public static final I2cAddr ADDRESS_I2C_DEFAULT = I2cAddr.create8bit((int)60);
    protected final float colorNormalizationFactor = 1.5258789E-5f;
    protected boolean isLightOn = false;
    private float softwareGain = 1.0f;

    public ModernRoboticsI2cColorSensor(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned);
        I2cDeviceSynch.ReadWindow readWindow = new I2cDeviceSynch.ReadWindow((int)Register.READ_WINDOW_FIRST.bVal, Register.READ_WINDOW_LAST.bVal - Register.READ_WINDOW_FIRST.bVal + 1, I2cDeviceSynch.ReadMode.REPEAT);
        ((I2cDeviceSynch)this.deviceClient).setReadWindow(readWindow);
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(ADDRESS_I2C_DEFAULT);
        this.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    protected synchronized boolean doInitialize() {
        this.enableLed(true);
        return true;
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.ModernRobotics;
    }

    public String getDeviceName() {
        RobotUsbDevice.FirmwareVersion firmwareVersion = new RobotUsbDevice.FirmwareVersion((int)this.read8(Register.FIRMWARE_REV));
        return String.format("Modern Robotics I2C Color Sensor %s", firmwareVersion);
    }

    public byte read8(Register reg) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)reg.bVal);
    }

    public void write8(Register reg, byte value) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)reg.bVal, (int)value);
    }

    public int readUnsignedByte(Register register) {
        return TypeConversion.unsignedByteToInt((byte)this.read8(register));
    }

    public int readUnsignedShort(Register register) {
        return TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])((I2cDeviceSynch)this.deviceClient).read((int)register.bVal, 2)));
    }

    public void writeCommand(Command command) {
        ((I2cDeviceSynch)this.deviceClient).waitForWriteCompletions(I2cWaitControl.ATOMIC);
        this.write8(Register.COMMAND, command.bVal);
    }

    public String toString() {
        return String.format("argb: 0x%08x", this.argb());
    }

    public int red() {
        return this.readUnsignedByte(Register.RED);
    }

    public int green() {
        return this.readUnsignedByte(Register.GREEN);
    }

    public int blue() {
        return this.readUnsignedByte(Register.BLUE);
    }

    public int alpha() {
        return this.readUnsignedByte(Register.ALPHA);
    }

    @ColorInt
    public int argb() {
        return this.getNormalizedColors().toColor();
    }

    public NormalizedRGBA getNormalizedColors() {
        NormalizedRGBA result = new NormalizedRGBA();
        result.red = Range.clip((float)(this.softwareGain * (float)this.readUnsignedShort(Register.NORMALIZED_RED_READING) * 1.5258789E-5f), (float)0.0f, (float)1.0f);
        result.green = Range.clip((float)(this.softwareGain * (float)this.readUnsignedShort(Register.NORMALIZED_GREEN_READING) * 1.5258789E-5f), (float)0.0f, (float)1.0f);
        result.blue = Range.clip((float)(this.softwareGain * (float)this.readUnsignedShort(Register.NORMALIZED_BLUE_READING) * 1.5258789E-5f), (float)0.0f, (float)1.0f);
        result.alpha = Range.clip((float)(this.softwareGain * (float)this.readUnsignedShort(Register.NORMALIZED_ALPHA_READING) * 1.5258789E-5f), (float)0.0f, (float)1.0f);
        return result;
    }

    public float getGain() {
        return this.softwareGain;
    }

    public void setGain(float newGain) {
        this.softwareGain = newGain;
    }

    public synchronized void enableLed(boolean enable) {
        this.writeCommand(enable ? Command.ACTIVE_LED : Command.PASSIVE_LED);
        this.isLightOn = enable;
    }

    public void enableLight(boolean enable) {
        this.enableLed(enable);
    }

    public synchronized boolean isLightOn() {
        return this.isLightOn;
    }

    public void setI2cAddress(I2cAddr newAddress) {
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(newAddress);
    }

    public I2cAddr getI2cAddress() {
        return ((I2cDeviceSynch)this.deviceClient).getI2cAddress();
    }

    public void resetDeviceConfigurationForOpMode() {
        super.resetDeviceConfigurationForOpMode();
        this.softwareGain = 1.0f;
    }

    public static enum Command {
        ACTIVE_LED(0),
        PASSIVE_LED(1),
        HZ50(53),
        HZ60(54),
        CALIBRATE_BLACK(66),
        CALIBRATE_WHITE(67);

        public byte bVal;

        private Command(int value) {
            this.bVal = (byte)value;
        }
    }

    public static enum Register {
        FIRMWARE_REV(0),
        MANUFACTURE_CODE(1),
        SENSOR_ID(2),
        COMMAND(3),
        COLOR_NUMBER(4),
        RED(5),
        GREEN(6),
        BLUE(7),
        ALPHA(8),
        COLOR_INDEX(9),
        RED_INDEX(10),
        GREEN_INDEX(11),
        BLUE_INDEX(12),
        RED_READING(14),
        GREEN_READING(16),
        BLUE_READING(18),
        ALPHA_READING(20),
        NORMALIZED_RED_READING(22),
        NORMALIZED_GREEN_READING(24),
        NORMALIZED_BLUE_READING(26),
        NORMALIZED_ALPHA_READING(28),
        READ_WINDOW_FIRST(Register.RED.bVal),
        READ_WINDOW_LAST(Register.NORMALIZED_ALPHA_READING.bVal + 1);

        public byte bVal;

        private Register(int value) {
            this.bVal = (byte)value;
        }
    }
}

