/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics;

import com.qualcomm.robotcore.hardware.CompassSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.TimestampedData;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.MagneticFlux;

@I2cDeviceType
@DeviceProperties(name="@string/mr_compass_name", description="@string/mr_compass_description", xmlTag="ModernRoboticsI2cCompassSensor", builtIn=true)
public class ModernRoboticsI2cCompassSensor
extends I2cDeviceSynchDevice<I2cDeviceSynch>
implements CompassSensor,
I2cAddrConfig {
    public static final I2cAddr ADDRESS_I2C_DEFAULT = I2cAddr.create8bit((int)36);

    public ModernRoboticsI2cCompassSensor(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned);
        this.setOptimalReadWindow();
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(ADDRESS_I2C_DEFAULT);
        this.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    protected void setOptimalReadWindow() {
        I2cDeviceSynch.ReadWindow readWindow = new I2cDeviceSynch.ReadWindow((int)Register.READ_WINDOW_FIRST.bVal, Register.READ_WINDOW_LAST.bVal - Register.READ_WINDOW_FIRST.bVal + 1, I2cDeviceSynch.ReadMode.REPEAT);
        ((I2cDeviceSynch)this.deviceClient).setReadWindow(readWindow);
    }

    protected synchronized boolean doInitialize() {
        this.setMode(CompassSensor.CompassMode.MEASUREMENT_MODE);
        return true;
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.ModernRobotics;
    }

    public String getDeviceName() {
        RobotUsbDevice.FirmwareVersion firmwareVersion = new RobotUsbDevice.FirmwareVersion((int)this.read8(Register.FIRMWARE_REV));
        return String.format(Locale.getDefault(), "Modern Robotics Compass Sensor %s", firmwareVersion);
    }

    public byte read8(Register reg) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)reg.bVal);
    }

    public void write8(Register reg, byte value) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)reg.bVal, (int)value);
    }

    public int readShort(Register reg) {
        return TypeConversion.byteArrayToShort((byte[])((I2cDeviceSynch)this.deviceClient).read((int)reg.bVal, 2), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    public void writeShort(Register reg, short value) {
        ((I2cDeviceSynch)this.deviceClient).write((int)reg.bVal, TypeConversion.shortToByteArray((short)value, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
    }

    public void writeCommand(Command command) {
        ((I2cDeviceSynch)this.deviceClient).waitForWriteCompletions(I2cWaitControl.ATOMIC);
        this.write8(Register.COMMAND, command.bVal);
    }

    public Command readCommand() {
        return Command.fromByte(this.read8(Register.COMMAND));
    }

    public Acceleration getAcceleration() {
        TimestampedData ts = ((I2cDeviceSynch)this.deviceClient).readTimeStamped((int)Register.ACCELX.bVal, 6);
        ByteBuffer buffer = ByteBuffer.wrap(ts.data).order(ByteOrder.LITTLE_ENDIAN);
        short mgX = buffer.getShort();
        short mgY = buffer.getShort();
        short mgZ = buffer.getShort();
        double scale = 0.001;
        return Acceleration.fromGravity((double)((double)mgX * scale), (double)((double)mgY * scale), (double)((double)mgZ * scale), (long)ts.nanoTime);
    }

    public MagneticFlux getMagneticFlux() {
        TimestampedData ts = ((I2cDeviceSynch)this.deviceClient).readTimeStamped((int)Register.MAGX.bVal, 6);
        ByteBuffer buffer = ByteBuffer.wrap(ts.data).order(ByteOrder.LITTLE_ENDIAN);
        short magX = buffer.getShort();
        short magY = buffer.getShort();
        short magZ = buffer.getShort();
        double scale = 1.0E-4;
        return new MagneticFlux((double)magX * scale, (double)magY * scale, (double)magZ * scale, ts.nanoTime);
    }

    public double getDirection() {
        return this.readShort(Register.HEADING);
    }

    public String status() {
        return String.format(Locale.getDefault(), "%s on %s", this.getDeviceName(), this.getConnectionInfo());
    }

    public boolean isCalibrating() {
        return this.readCommand() == Command.CALIBRATE_IRON;
    }

    public boolean calibrationFailed() {
        return this.readCommand() == Command.CALIBRATION_FAILED;
    }

    public void setMode(CompassSensor.CompassMode mode) {
        this.writeCommand(mode == CompassSensor.CompassMode.CALIBRATION_MODE ? Command.CALIBRATE_IRON : Command.NORMAL);
    }

    public void setI2cAddress(I2cAddr newAddress) {
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(newAddress);
    }

    public I2cAddr getI2cAddress() {
        return ((I2cDeviceSynch)this.deviceClient).getI2cAddress();
    }

    public static enum Command {
        NORMAL(0),
        CALIBRATE_IRON(67),
        ACCEL_NULL_X(88),
        ACCEL_NULL_Y(89),
        ACCEL_NULL_Z(90),
        ACCEL_GAIN_ADJUST(71),
        MEASURE_TILT_UP(85),
        MEASURE_TILT_DOWN(68),
        WRITE_EEPROM(87),
        CALIBRATION_FAILED(70),
        UNKNOWN(-1);

        public byte bVal;

        private Command(int bVal) {
            this.bVal = (byte)bVal;
        }

        public static Command fromByte(byte b) {
            for (Command command : Command.values()) {
                if (command.bVal != b) continue;
                return command;
            }
            return UNKNOWN;
        }
    }

    public static enum Register {
        READ_WINDOW_FIRST(0),
        FIRMWARE_REV(0),
        MANUFACTURE_CODE(1),
        SENSOR_ID(2),
        COMMAND(3),
        HEADING(4),
        ACCELX(6),
        ACCELY(8),
        ACCELZ(10),
        MAGX(12),
        MAGY(14),
        MAGZ(16),
        READ_WINDOW_LAST(Register.MAGZ.bVal + 1),
        ACCELX_OFFSET(18),
        ACCELY_OFFSET(20),
        ACCELZ_OFFSET(22),
        MAGX_OFFSET(24),
        MAGY_OFFSET(26),
        MAGZ_OFFSET(28),
        MAG_TILT_COEFF(30),
        ACCEL_SCALE_COEFF(32),
        MAG_SCALE_COEFF_X(34),
        MAG_SCALE_COEFF_Y(36),
        UNKNOWN(-1);

        public byte bVal;

        private Register(int bVal) {
            this.bVal = (byte)bVal;
        }
    }
}

