/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics;

import com.qualcomm.robotcore.R;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.IrSeekerSensor;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteOrder;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class ModernRoboticsI2cIrSeekerSensorV3
extends I2cDeviceSynchDevice<I2cDeviceSynch>
implements IrSeekerSensor,
I2cAddrConfig {
    public static final I2cAddr ADDRESS_I2C_DEFAULT = I2cAddr.create8bit((int)56);
    public static final double MAX_SENSOR_STRENGTH = 255.0;
    protected IrSeekerSensor.Mode mode = IrSeekerSensor.Mode.MODE_1200HZ;
    protected double signalDetectedThreshold;

    public ModernRoboticsI2cIrSeekerSensorV3(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned);
        this.setOptimalReadWindow();
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(ADDRESS_I2C_DEFAULT);
        super.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    protected void setOptimalReadWindow() {
        I2cDeviceSynch.ReadWindow readWindow = new I2cDeviceSynch.ReadWindow((int)Register.READ_WINDOW_FIRST.bVal, Register.READ_WINDOW_LAST.bVal - Register.READ_WINDOW_FIRST.bVal + 1, I2cDeviceSynch.ReadMode.REPEAT);
        ((I2cDeviceSynch)this.deviceClient).setReadWindow(readWindow);
    }

    protected boolean doInitialize() {
        this.setMode(IrSeekerSensor.Mode.MODE_1200HZ);
        this.signalDetectedThreshold = 0.00392156862745098;
        return true;
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.ModernRobotics;
    }

    public String getDeviceName() {
        return String.format("%s %s", AppUtil.getDefContext().getString(R.string.configTypeIrSeekerV3), new RobotUsbDevice.FirmwareVersion((int)this.read8(Register.FIRMWARE_REV)));
    }

    public int getVersion() {
        return 3;
    }

    public byte read8(Register reg) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)reg.bVal);
    }

    public void write8(Register reg, byte value) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)reg.bVal, (int)value);
    }

    protected short readShort(Register reg) {
        return TypeConversion.byteArrayToShort((byte[])((I2cDeviceSynch)this.deviceClient).read((int)reg.bVal, 2), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (this.signalDetected()) {
            return String.format("IR Seeker: %3.0f%% signal at %6.1f degrees", this.getStrength() * 100.0, this.getAngle());
        }
        return "IR Seeker:  --% signal at  ---.- degrees";
    }

    public synchronized void setSignalDetectedThreshold(double threshold) {
        this.signalDetectedThreshold = threshold;
    }

    public double getSignalDetectedThreshold() {
        return this.signalDetectedThreshold;
    }

    public synchronized void setMode(IrSeekerSensor.Mode mode) {
        this.mode = mode;
    }

    public IrSeekerSensor.Mode getMode() {
        return this.mode;
    }

    public boolean signalDetected() {
        return this.getStrength() > this.signalDetectedThreshold;
    }

    public synchronized double getAngle() {
        Register reg = this.getMode() == IrSeekerSensor.Mode.MODE_1200HZ ? Register.DIR_DATA_1200 : Register.DIR_DATA_600;
        return this.read8(reg);
    }

    public synchronized double getStrength() {
        Register reg = this.getMode() == IrSeekerSensor.Mode.MODE_1200HZ ? Register.SIGNAL_STRENTH_1200 : Register.SIGNAL_STRENTH_600;
        return TypeConversion.unsignedByteToDouble((byte)this.read8(reg)) / 255.0;
    }

    public synchronized IrSeekerSensor.IrSeekerIndividualSensor[] getIndividualSensors() {
        IrSeekerSensor.IrSeekerIndividualSensor[] sensors = new IrSeekerSensor.IrSeekerIndividualSensor[2];
        Register reg = this.getMode() == IrSeekerSensor.Mode.MODE_1200HZ ? Register.LEFT_SIDE_DATA_1200 : Register.LEFT_SIDE_DATA_600;
        double strength = (double)this.readShort(reg) / 255.0;
        sensors[0] = new IrSeekerSensor.IrSeekerIndividualSensor(-1.0, strength);
        reg = this.getMode() == IrSeekerSensor.Mode.MODE_1200HZ ? Register.RIGHT_SIDE_DATA_1200 : Register.RIGHT_SIDE_DATA_600;
        strength = (double)this.readShort(reg) / 255.0;
        sensors[1] = new IrSeekerSensor.IrSeekerIndividualSensor(1.0, strength);
        return sensors;
    }

    public synchronized void setI2cAddress(I2cAddr newAddress) {
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(newAddress);
    }

    public I2cAddr getI2cAddress() {
        return ((I2cDeviceSynch)this.deviceClient).getI2cAddress();
    }

    public static enum Register {
        READ_WINDOW_FIRST(0),
        FIRMWARE_REV(0),
        MANUFACTURE_CODE(1),
        SENSOR_ID(2),
        UNUSED(3),
        DIR_DATA_1200(4),
        SIGNAL_STRENTH_1200(5),
        DIR_DATA_600(6),
        SIGNAL_STRENTH_600(7),
        LEFT_SIDE_DATA_1200(8),
        RIGHT_SIDE_DATA_1200(10),
        LEFT_SIDE_DATA_600(12),
        RIGHT_SIDE_DATA_600(14),
        READ_WINDOW_LAST(Register.RIGHT_SIDE_DATA_600.bVal + 1),
        UNKNOWN(-1);

        public byte bVal;

        private Register(int value) {
            this.bVal = (byte)value;
        }
    }
}

