/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics;

import com.qualcomm.robotcore.R;
import com.qualcomm.robotcore.hardware.AnalogInputController;
import com.qualcomm.robotcore.hardware.DigitalChannel;
import com.qualcomm.robotcore.hardware.DigitalChannelController;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.TouchSensor;
import com.qualcomm.robotcore.hardware.configuration.annotations.AnalogSensorType;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

@AnalogSensorType
@DeviceProperties(name="@string/configTypeMRTouchSensor", xmlTag="ModernRoboticsAnalogTouchSensor", builtIn=true, description="@string/mr_touch_sensor_description")
public class ModernRoboticsTouchSensor
implements TouchSensor {
    private DigitalChannelController digitalController = null;
    private AnalogInputController analogInputController = null;
    private int physicalPort = -1;
    private double analogThreshold;

    public ModernRoboticsTouchSensor(DigitalChannelController digitalController, int physicalPort) {
        this.digitalController = digitalController;
        this.physicalPort = physicalPort;
    }

    public ModernRoboticsTouchSensor(AnalogInputController analogController, int physicalPort) {
        this.analogInputController = analogController;
        this.physicalPort = physicalPort;
        this.analogThreshold = analogController.getMaxAnalogInputVoltage() / 2.0;
    }

    public boolean isDigital() {
        return this.digitalController != null;
    }

    public boolean isAnalog() {
        return !this.isDigital();
    }

    public double getAnalogVoltageThreshold() {
        return this.analogThreshold;
    }

    public void setAnalogVoltageThreshold(double threshold) {
        this.analogThreshold = threshold;
    }

    public String toString() {
        return String.format("Touch Sensor: %1.2f", this.getValue());
    }

    public double getValue() {
        return this.isPressed() ? 1.0 : 0.0;
    }

    public boolean isPressed() {
        return this.isDigital() ? this.digitalController.getDigitalChannelState(this.physicalPort) : this.analogInputController.getAnalogInputVoltage(this.physicalPort) > this.getAnalogVoltageThreshold();
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.ModernRobotics;
    }

    public String getDeviceName() {
        return AppUtil.getDefContext().getString(R.string.configTypeMRTouchSensor);
    }

    public String getConnectionInfo() {
        return this.isDigital() ? this.digitalController.getConnectionInfo() + "; digital port " + this.physicalPort : this.analogInputController.getConnectionInfo() + "; analog port " + this.physicalPort;
    }

    public int getVersion() {
        return 1;
    }

    public void resetDeviceConfigurationForOpMode() {
        if (this.isDigital()) {
            this.digitalController.setDigitalChannelMode(this.physicalPort, DigitalChannel.Mode.INPUT);
        }
    }

    public void close() {
    }
}

