/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics.comm;

import android.annotation.SuppressLint;
import com.qualcomm.robotcore.util.TypeConversion;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

@SuppressLint(value={"DefaultLocale"})
public abstract class ModernRoboticsDatagram {
    public static final int CB_HEADER = 5;
    public static final int IB_SYNC_0 = 0;
    public static final int IB_SYNC_1 = 1;
    public static final int IB_FUNCTION = 2;
    public static final int IB_ADDRESS = 3;
    public static final int IB_LENGTH = 4;
    public byte[] data;

    protected ModernRoboticsDatagram(int cbPayloadAlloc) {
        this.data = new byte[5 + cbPayloadAlloc];
    }

    protected void initialize(int sync0, int sync1) {
        this.data[0] = (byte)sync0;
        this.data[1] = (byte)sync1;
        this.data[2] = 0;
        this.data[3] = 0;
        this.data[4] = 0;
    }

    public void clearPayload() {
        Arrays.fill(this.data, 5, this.data.length, (byte)0);
    }

    public int getAllocatedPayload() {
        return this.data.length - 5;
    }

    public boolean isRead() {
        return (this.data[2] & 0x80) != 0;
    }

    public boolean isWrite() {
        return !this.isRead();
    }

    public void setRead(int function) {
        this.data[2] = (byte)(0x80 | function & 0x7F);
    }

    public void setWrite(int function) {
        this.data[2] = (byte)(function & 0x7F);
    }

    public void setRead() {
        this.setRead(this.getFunction());
    }

    public void setWrite() {
        this.setWrite(this.getFunction());
    }

    public int getFunction() {
        return this.data[2] & 0x7F;
    }

    public void setFunction(int function) {
        this.data[2] = (byte)(this.data[2] & 0x80 | function & 0x7F);
    }

    public int getAddress() {
        return TypeConversion.unsignedByteToInt((byte)this.data[3]);
    }

    public void setAddress(int address) {
        if (address < 0 || address > 255) {
            throw new IllegalArgumentException(String.format("address=%d; must be unsigned byte", address));
        }
        this.data[3] = (byte)address;
    }

    public void setPayload(byte[] payload) {
        this.setPayloadLength(payload.length);
        System.arraycopy(payload, 0, this.data, 5, payload.length);
    }

    public int getPayloadLength() {
        return TypeConversion.unsignedByteToInt((byte)this.data[4]);
    }

    public void setPayloadLength(int length) {
        if (length < 0 || length > 255) {
            throw new IllegalArgumentException(String.format("length=%d; must be unsigned byte", length));
        }
        this.data[4] = (byte)length;
    }

    public boolean isFailure() {
        return this.data[2] == -1 && this.data[3] == -1;
    }

    public static class AllocationContext<DATAGRAM_TYPE extends ModernRoboticsDatagram> {
        protected AtomicReference<DATAGRAM_TYPE> cacheHeaderOnly0 = new AtomicReference<Object>(null);
        protected AtomicReference<DATAGRAM_TYPE> cacheHeaderOnly1 = new AtomicReference<Object>(null);
        protected AtomicReference<DATAGRAM_TYPE> cachedFullInstance0 = new AtomicReference<Object>(null);
        protected AtomicReference<DATAGRAM_TYPE> cachedFullInstance1 = new AtomicReference<Object>(null);

        DATAGRAM_TYPE tryAlloc(int cbPayloadAlloc) {
            if (cbPayloadAlloc == 0) {
                ModernRoboticsDatagram cached = this.cacheHeaderOnly0.getAndSet(null);
                if (cached == null) {
                    cached = this.cacheHeaderOnly1.getAndSet(null);
                }
                return (DATAGRAM_TYPE)cached;
            }
            boolean found = false;
            ModernRoboticsDatagram cached = this.cachedFullInstance0.getAndSet(null);
            if (cached != null) {
                found = true;
                if (cached.getAllocatedPayload() == cbPayloadAlloc) {
                    return (DATAGRAM_TYPE)cached;
                }
                this.tryCache0(cached);
            }
            if ((cached = (ModernRoboticsDatagram)this.cachedFullInstance1.getAndSet(null)) != null) {
                found = true;
                if (cached.getAllocatedPayload() == cbPayloadAlloc) {
                    return (DATAGRAM_TYPE)cached;
                }
                this.tryCache1(cached);
            }
            return null;
        }

        void tryCache0(DATAGRAM_TYPE instance) {
            if (((ModernRoboticsDatagram)instance).getAllocatedPayload() == 0) {
                if (!this.cacheHeaderOnly0.compareAndSet(null, instance)) {
                    this.cacheHeaderOnly1.compareAndSet(null, instance);
                }
            } else if (!this.cachedFullInstance0.compareAndSet(null, instance)) {
                this.cachedFullInstance1.compareAndSet(null, instance);
            }
        }

        void tryCache1(DATAGRAM_TYPE instance) {
            if (((ModernRoboticsDatagram)instance).getAllocatedPayload() == 0) {
                if (!this.cacheHeaderOnly1.compareAndSet(null, instance)) {
                    this.cacheHeaderOnly0.compareAndSet(null, instance);
                }
            } else if (!this.cachedFullInstance1.compareAndSet(null, instance)) {
                this.cachedFullInstance0.compareAndSet(null, instance);
            }
        }
    }
}

