/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics.comm;

import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsReaderWriter;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbManager;
import com.qualcomm.robotcore.util.SerialNumber;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbException;

public class ModernRoboticsUsbUtil {
    public static RobotUsbDevice openRobotUsbDevice(boolean doScan, RobotUsbManager robotUsbManager, SerialNumber serialNumber) throws RobotCoreException {
        if (doScan) {
            robotUsbManager.scanForDevices();
        }
        RobotUsbDevice robotUsbDevice = null;
        try {
            robotUsbDevice = robotUsbManager.openBySerialNumber(serialNumber);
        }
        catch (Exception e) {
            throw RobotCoreException.createChained((Exception)e, (String)("Unable to open USB device " + serialNumber + ": " + e.getMessage()), (Object[])new Object[0]);
        }
        try {
            robotUsbDevice.setBaudRate(250000);
            robotUsbDevice.setDataCharacteristics((byte)8, (byte)0, (byte)0);
            robotUsbDevice.setLatencyTimer(1);
        }
        catch (Exception e) {
            robotUsbDevice.close();
            throw RobotCoreException.createChained((Exception)e, (String)("Unable to parameterize USB device " + serialNumber + " - " + robotUsbDevice.getProductName() + ": " + e.getMessage()), (Object[])new Object[0]);
        }
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return robotUsbDevice;
    }

    public static byte[] getUsbDeviceHeader(RobotUsbDevice robotUsbDevice) throws RobotUsbException {
        byte[] deviceHeaderData = new byte[3];
        try {
            ModernRoboticsReaderWriter readerWriter = new ModernRoboticsReaderWriter(robotUsbDevice);
            readerWriter.read(true, 0, deviceHeaderData, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return deviceHeaderData;
    }
}

