/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.rev;

import com.qualcomm.robotcore.hardware.ImuOrientationOnRobot;
import com.qualcomm.robotcore.hardware.QuaternionBasedImuHelper;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;

abstract class RevImuOrientationOnRobot
implements ImuOrientationOnRobot {
    private final Quaternion robotCoordinateSystemFromPerspectiveOfImu;
    private final Quaternion imuRotationOffset;
    private final Quaternion angularVelocityTransform;

    protected RevImuOrientationOnRobot(Quaternion rotation) {
        Quaternion imuRotationWithinHub = QuaternionBasedImuHelper.quaternionFromZAxisRotation((float)-90.0f, (AngleUnit)AngleUnit.DEGREES);
        rotation = rotation.multiply(imuRotationWithinHub, 0L).normalized();
        this.angularVelocityTransform = new Quaternion(rotation.w, rotation.x, rotation.y, rotation.z, 0L);
        this.robotCoordinateSystemFromPerspectiveOfImu = new Quaternion(rotation.w, 0.0f, 0.0f, rotation.z, 0L).normalized();
        rotation = rotation.multiply(this.robotCoordinateSystemFromPerspectiveOfImu.inverse(), 0L).normalized();
        this.imuRotationOffset = rotation.inverse().normalized();
    }

    public Quaternion imuCoordinateSystemOrientationFromPerspectiveOfRobot() {
        return this.robotCoordinateSystemFromPerspectiveOfImu;
    }

    public Quaternion imuRotationOffset() {
        return this.imuRotationOffset;
    }

    public Quaternion angularVelocityTransform() {
        return this.angularVelocityTransform;
    }

    static Orientation zyxOrientation(double z, double y, double x) {
        return new Orientation(AxesReference.INTRINSIC, AxesOrder.ZYX, AngleUnit.DEGREES, (float)z, (float)y, (float)x, 0L);
    }

    static Orientation xyzOrientation(double x, double y, double z) {
        return new Orientation(AxesReference.INTRINSIC, AxesOrder.XYZ, AngleUnit.DEGREES, (float)x, (float)y, (float)z, 0L);
    }
}

