/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.rev;

import com.qualcomm.robotcore.hardware.ControlSystem;
import com.qualcomm.robotcore.hardware.DigitalChannel;
import com.qualcomm.robotcore.hardware.DigitalChannelController;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.TouchSensor;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.DigitalIoDeviceType;

@DigitalIoDeviceType
@DeviceProperties(name="@string/configTypeRevTouchSensor", xmlTag="RevTouchSensor", builtIn=true, compatibleControlSystems={ControlSystem.REV_HUB}, description="@string/rev_touch_sensor_description")
public class RevTouchSensor
implements TouchSensor {
    private final DigitalChannelController digitalChannelController;
    private final int physicalPort;

    public RevTouchSensor(DigitalChannelController digitalChannelController, int physicalPort) {
        this.digitalChannelController = digitalChannelController;
        this.physicalPort = physicalPort;
    }

    public double getValue() {
        return this.isPressed() ? 1.0 : 0.0;
    }

    public boolean isPressed() {
        return !this.digitalChannelController.getDigitalChannelState(this.physicalPort);
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Lynx;
    }

    public String getDeviceName() {
        return "REV Touch Sensor";
    }

    public String getConnectionInfo() {
        return this.digitalChannelController.getConnectionInfo() + "; digital channel " + this.physicalPort;
    }

    public int getVersion() {
        return 1;
    }

    public void resetDeviceConfigurationForOpMode() {
        this.digitalChannelController.setDigitalChannelMode(this.physicalPort, DigitalChannel.Mode.INPUT);
    }

    public void close() {
    }
}

