/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.sparkfun;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;

@I2cDeviceType
@DeviceProperties(name="@string/sparkfun_led_stick_name", description="@string/sparkfun_led_stick_description", xmlTag="QWIIC_LED_STICK")
public class SparkFunLEDStick
extends I2cDeviceSynchDevice<I2cDeviceSynchSimple> {
    private static final boolean LIMIT_TO_ONE_STICK = true;
    private static final int MAX_SEGMENT_LENGTH = 12;
    private static final I2cAddr ADDRESS_I2C_DEFAULT = I2cAddr.create7bit((int)35);

    public void setColor(int position, @ColorInt int color) {
        byte[] data = new byte[]{(byte)position, (byte)Color.red((int)color), (byte)Color.green((int)color), (byte)Color.blue((int)color)};
        this.writeI2C(Commands.WRITE_SINGLE_LED_COLOR, data);
    }

    public void setColor(@ColorInt int color) {
        byte[] data = new byte[]{(byte)Color.red((int)color), (byte)Color.green((int)color), (byte)Color.blue((int)color)};
        this.writeI2C(Commands.WRITE_ALL_LED_COLOR, data);
    }

    private void sendSegment(Commands cmd, int[] array, int offset, int length) {
        byte[] data = new byte[length + 2];
        data[0] = (byte)length;
        data[1] = (byte)offset;
        for (int i = 0; i < length; ++i) {
            data[2 + i] = (byte)array[i];
        }
        this.writeI2C(cmd, data);
    }

    private void setLEDColorSegment(@ColorInt int[] colors, int offset, int length) {
        int[] redArray = new int[length];
        int[] greenArray = new int[length];
        int[] blueArray = new int[length];
        for (int i = 0; i < length; ++i) {
            redArray[i] = Color.red((int)colors[i + offset]);
            greenArray[i] = Color.green((int)colors[i + offset]);
            blueArray[i] = Color.blue((int)colors[i + offset]);
        }
        this.sendSegment(Commands.WRITE_RED_ARRAY, redArray, offset, length);
        this.sendSegment(Commands.WRITE_GREEN_ARRAY, greenArray, offset, length);
        this.sendSegment(Commands.WRITE_BLUE_ARRAY, blueArray, offset, length);
    }

    public void setColors(@ColorInt int[] colors) {
        int length = colors.length;
        if (length > 10) {
            length = 10;
        }
        int numInLastSegment = length % 12;
        int numSegments = length / 12;
        for (int i = 0; i < numSegments; ++i) {
            this.setLEDColorSegment(colors, i * 12, 12);
        }
        if (numInLastSegment > 0) {
            this.setLEDColorSegment(colors, numSegments * 12, numInLastSegment);
        }
    }

    public void setBrightness(int position, int brightness) {
        byte[] data = new byte[]{(byte)position, (byte)brightness};
        this.writeI2C(Commands.WRITE_SINGLE_LED_BRIGHTNESS, data);
    }

    public void setBrightness(int brightness) {
        byte[] data = new byte[]{(byte)brightness};
        this.writeI2C(Commands.WRITE_ALL_LED_BRIGHTNESS, data);
    }

    public void turnAllOff() {
        this.setColor(0);
    }

    private void writeI2C(Commands cmd, byte[] data) {
        this.deviceClient.write(cmd.bVal, data);
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.SparkFun;
    }

    protected synchronized boolean doInitialize() {
        return true;
    }

    public String getDeviceName() {
        return "SparkFun Qwiic LED Strip";
    }

    public SparkFunLEDStick(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(deviceClient, deviceClientIsOwned);
        deviceClient.setI2cAddress(ADDRESS_I2C_DEFAULT);
        super.registerArmingStateCallback(false);
    }

    private static enum Commands {
        CHANGE_LED_LENGTH(112),
        WRITE_SINGLE_LED_COLOR(113),
        WRITE_ALL_LED_COLOR(114),
        WRITE_RED_ARRAY(115),
        WRITE_GREEN_ARRAY(116),
        WRITE_BLUE_ARRAY(117),
        WRITE_SINGLE_LED_BRIGHTNESS(118),
        WRITE_ALL_LED_BRIGHTNESS(119),
        WRITE_ALL_LED_OFF(120);

        final int bVal;

        private Commands(int bVal) {
            this.bVal = bVal;
        }
    }
}

