/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.sparkfun;

import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

@I2cDeviceType
@DeviceProperties(name="SparkFun OTOS", xmlTag="SparkFunOTOS", description="SparkFun Qwiic Optical Tracking Odometry Sensor")
public class SparkFunOTOS
extends I2cDeviceSynchDevice<I2cDeviceSynch> {
    public static final byte DEFAULT_ADDRESS = 23;
    public static final double MIN_SCALAR = 0.872;
    public static final double MAX_SCALAR = 1.127;
    protected static final byte REG_PRODUCT_ID = 0;
    protected static final byte REG_HW_VERSION = 1;
    protected static final byte REG_FW_VERSION = 2;
    protected static final byte REG_SCALAR_LINEAR = 4;
    protected static final byte REG_SCALAR_ANGULAR = 5;
    protected static final byte REG_IMU_CALIB = 6;
    protected static final byte REG_RESET = 7;
    protected static final byte REG_SIGNAL_PROCESS = 14;
    protected static final byte REG_SELF_TEST = 15;
    protected static final byte REG_OFF_XL = 16;
    protected static final byte REG_OFF_XH = 17;
    protected static final byte REG_OFF_YL = 18;
    protected static final byte REG_OFF_YH = 19;
    protected static final byte REG_OFF_HL = 20;
    protected static final byte REG_OFF_HH = 21;
    protected static final byte REG_STATUS = 31;
    protected static final byte REG_POS_XL = 32;
    protected static final byte REG_POS_XH = 33;
    protected static final byte REG_POS_YL = 34;
    protected static final byte REG_POS_YH = 35;
    protected static final byte REG_POS_HL = 36;
    protected static final byte REG_POS_HH = 37;
    protected static final byte REG_VEL_XL = 38;
    protected static final byte REG_VEL_XH = 39;
    protected static final byte REG_VEL_YL = 40;
    protected static final byte REG_VEL_YH = 41;
    protected static final byte REG_VEL_HL = 42;
    protected static final byte REG_VEL_HH = 43;
    protected static final byte REG_ACC_XL = 44;
    protected static final byte REG_ACC_XH = 45;
    protected static final byte REG_ACC_YL = 46;
    protected static final byte REG_ACC_YH = 47;
    protected static final byte REG_ACC_HL = 48;
    protected static final byte REG_ACC_HH = 49;
    protected static final byte REG_POS_STD_XL = 50;
    protected static final byte REG_POS_STD_XH = 51;
    protected static final byte REG_POS_STD_YL = 52;
    protected static final byte REG_POS_STD_YH = 53;
    protected static final byte REG_POS_STD_HL = 54;
    protected static final byte REG_POS_STD_HH = 55;
    protected static final byte REG_VEL_STD_XL = 56;
    protected static final byte REG_VEL_STD_XH = 57;
    protected static final byte REG_VEL_STD_YL = 58;
    protected static final byte REG_VEL_STD_YH = 59;
    protected static final byte REG_VEL_STD_HL = 60;
    protected static final byte REG_VEL_STD_HH = 61;
    protected static final byte REG_ACC_STD_XL = 62;
    protected static final byte REG_ACC_STD_XH = 63;
    protected static final byte REG_ACC_STD_YL = 64;
    protected static final byte REG_ACC_STD_YH = 65;
    protected static final byte REG_ACC_STD_HL = 66;
    protected static final byte REG_ACC_STD_HH = 67;
    protected static final byte PRODUCT_ID = 95;
    protected static final double RADIAN_TO_DEGREE = 57.29577951308232;
    protected static final double DEGREE_TO_RADIAN = Math.PI / 180;
    protected static final double METER_TO_INT16 = 3276.8;
    protected static final double INT16_TO_METER = 3.0517578125E-4;
    protected static final double MPS_TO_INT16 = 6553.6;
    protected static final double INT16_TO_MPS = 1.52587890625E-4;
    protected static final double MPSS_TO_INT16 = 208.83788041787972;
    protected static final double INT16_TO_MPSS = 0.0047884033203125;
    protected static final double RAD_TO_INT16 = 10430.378350470453;
    protected static final double INT16_TO_RAD = 9.587379924285257E-5;
    protected static final double RPS_TO_INT16 = 938.7340515423407;
    protected static final double INT16_TO_RPS = 0.0010652644360316954;
    protected static final double RPSS_TO_INT16 = 10.430378350470454;
    protected static final double INT16_TO_RPSS = 0.09587379924285257;
    protected DistanceUnit _distanceUnit;
    protected AngleUnit _angularUnit;

    public SparkFunOTOS(I2cDeviceSynch deviceClient) {
        super((I2cDeviceSynchSimple)deviceClient, true);
        deviceClient.setI2cAddress(I2cAddr.create7bit((int)23));
        super.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    protected boolean doInitialize() {
        this._distanceUnit = DistanceUnit.INCH;
        this._angularUnit = AngleUnit.DEGREES;
        return this.isConnected();
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.SparkFun;
    }

    public String getDeviceName() {
        return "SparkFun Qwiic Optical Tracking Odometry Sensor";
    }

    public boolean begin() {
        return this.isConnected();
    }

    public boolean isConnected() {
        byte prodId = ((I2cDeviceSynch)this.deviceClient).read8(0);
        return prodId == 95;
    }

    public void getVersionInfo(Version hwVersion, Version fwVersion) {
        byte[] rawData = ((I2cDeviceSynch)this.deviceClient).read(1, 2);
        hwVersion.set(rawData[0]);
        fwVersion.set(rawData[1]);
    }

    public boolean selfTest() {
        SelfTestConfig selfTest = new SelfTestConfig();
        selfTest.set((byte)1);
        ((I2cDeviceSynch)this.deviceClient).write8(15, (int)selfTest.get());
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            selfTest.set(((I2cDeviceSynch)this.deviceClient).read8(15));
            if (!selfTest.inProgress) break;
        }
        return selfTest.pass;
    }

    public boolean calibrateImu() {
        return this.calibrateImu(255, true);
    }

    public boolean calibrateImu(int numSamples, boolean waitUntilDone) {
        if (numSamples < 1 || numSamples > 255) {
            return false;
        }
        ((I2cDeviceSynch)this.deviceClient).write8(6, numSamples);
        try {
            Thread.sleep(3L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        if (!waitUntilDone) {
            return true;
        }
        for (int numAttempts = numSamples; numAttempts > 0; --numAttempts) {
            byte calibrationValue = ((I2cDeviceSynch)this.deviceClient).read8(6);
            if (calibrationValue == 0) {
                return true;
            }
            try {
                Thread.sleep(3L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    public int getImuCalibrationProgress() {
        return ((I2cDeviceSynch)this.deviceClient).read8(6) & 0xFF;
    }

    public DistanceUnit getLinearUnit() {
        return this._distanceUnit;
    }

    public void setLinearUnit(DistanceUnit unit) {
        if (unit == this._distanceUnit) {
            return;
        }
        this._distanceUnit = unit;
    }

    public AngleUnit getAngularUnit() {
        return this._angularUnit;
    }

    public void setAngularUnit(AngleUnit unit) {
        if (unit == this._angularUnit) {
            return;
        }
        this._angularUnit = unit;
    }

    public double getLinearScalar() {
        byte rawScalar = ((I2cDeviceSynch)this.deviceClient).read8(4);
        return (double)rawScalar * 0.001 + 1.0;
    }

    public boolean setLinearScalar(double scalar) {
        if (scalar < 0.872 || scalar > 1.127) {
            return false;
        }
        byte rawScalar = (byte)((scalar - 1.0) * 1000.0 + 0.5);
        ((I2cDeviceSynch)this.deviceClient).write8(4, (int)rawScalar);
        return true;
    }

    public double getAngularScalar() {
        byte rawScalar = ((I2cDeviceSynch)this.deviceClient).read8(5);
        return (double)rawScalar * 0.001 + 1.0;
    }

    public boolean setAngularScalar(double scalar) {
        if (scalar < 0.872 || scalar > 1.127) {
            return false;
        }
        byte rawScalar = (byte)((scalar - 1.0) * 1000.0 + 0.5);
        ((I2cDeviceSynch)this.deviceClient).write8(5, (int)rawScalar);
        return true;
    }

    public void resetTracking() {
        ((I2cDeviceSynch)this.deviceClient).write8(7, 1);
    }

    public SignalProcessConfig getSignalProcessConfig() {
        return new SignalProcessConfig(((I2cDeviceSynch)this.deviceClient).read8(14));
    }

    public void setSignalProcessConfig(SignalProcessConfig config) {
        ((I2cDeviceSynch)this.deviceClient).write8(14, (int)config.get());
    }

    public Status getStatus() {
        return new Status(((I2cDeviceSynch)this.deviceClient).read8(31));
    }

    public Pose2D getOffset() {
        return this.readPoseRegs((byte)16, 3.0517578125E-4, 9.587379924285257E-5);
    }

    public void setOffset(Pose2D pose) {
        this.writePoseRegs((byte)16, pose, 3276.8, 10430.378350470453);
    }

    public Pose2D getPosition() {
        return this.readPoseRegs((byte)32, 3.0517578125E-4, 9.587379924285257E-5);
    }

    public void setPosition(Pose2D pose) {
        this.writePoseRegs((byte)32, pose, 3276.8, 10430.378350470453);
    }

    public Pose2D getVelocity() {
        return this.readPoseRegs((byte)38, 1.52587890625E-4, 0.0010652644360316954);
    }

    public Pose2D getAcceleration() {
        return this.readPoseRegs((byte)44, 0.0047884033203125, 0.09587379924285257);
    }

    public Pose2D getPositionStdDev() {
        return this.readPoseRegs((byte)50, 3.0517578125E-4, 9.587379924285257E-5);
    }

    public Pose2D getVelocityStdDev() {
        return this.readPoseRegs((byte)56, 1.52587890625E-4, 0.0010652644360316954);
    }

    public Pose2D getAccelerationStdDev() {
        return this.readPoseRegs((byte)62, 0.0047884033203125, 0.09587379924285257);
    }

    public void getPosVelAcc(Pose2D pos, Pose2D vel, Pose2D acc) {
        byte[] rawData = ((I2cDeviceSynch)this.deviceClient).read(32, 18);
        pos.set(this.regsToPose(Arrays.copyOfRange(rawData, 0, 6), 3.0517578125E-4, 9.587379924285257E-5));
        vel.set(this.regsToPose(Arrays.copyOfRange(rawData, 6, 12), 1.52587890625E-4, 0.0010652644360316954));
        acc.set(this.regsToPose(Arrays.copyOfRange(rawData, 12, 18), 0.0047884033203125, 0.09587379924285257));
    }

    public void getPosVelAccStdDev(Pose2D pos, Pose2D vel, Pose2D acc) {
        byte[] rawData = ((I2cDeviceSynch)this.deviceClient).read(50, 18);
        pos.set(this.regsToPose(Arrays.copyOfRange(rawData, 0, 6), 3.0517578125E-4, 9.587379924285257E-5));
        vel.set(this.regsToPose(Arrays.copyOfRange(rawData, 6, 12), 1.52587890625E-4, 0.0010652644360316954));
        acc.set(this.regsToPose(Arrays.copyOfRange(rawData, 12, 18), 0.0047884033203125, 0.09587379924285257));
    }

    public void getPosVelAccAndStdDev(Pose2D pos, Pose2D vel, Pose2D acc, Pose2D posStdDev, Pose2D velStdDev, Pose2D accStdDev) {
        byte[] rawData = ((I2cDeviceSynch)this.deviceClient).read(32, 36);
        pos.set(this.regsToPose(Arrays.copyOfRange(rawData, 0, 6), 3.0517578125E-4, 9.587379924285257E-5));
        vel.set(this.regsToPose(Arrays.copyOfRange(rawData, 6, 12), 1.52587890625E-4, 0.0010652644360316954));
        acc.set(this.regsToPose(Arrays.copyOfRange(rawData, 12, 18), 0.0047884033203125, 0.09587379924285257));
        posStdDev.set(this.regsToPose(Arrays.copyOfRange(rawData, 18, 24), 3.0517578125E-4, 9.587379924285257E-5));
        velStdDev.set(this.regsToPose(Arrays.copyOfRange(rawData, 24, 30), 1.52587890625E-4, 0.0010652644360316954));
        accStdDev.set(this.regsToPose(Arrays.copyOfRange(rawData, 30, 36), 0.0047884033203125, 0.09587379924285257));
    }

    protected Pose2D readPoseRegs(byte reg, double rawToXY, double rawToH) {
        byte[] rawData = ((I2cDeviceSynch)this.deviceClient).read((int)reg, 6);
        return this.regsToPose(rawData, rawToXY, rawToH);
    }

    protected void writePoseRegs(byte reg, Pose2D pose, double xyToRaw, double hToRaw) {
        byte[] rawData = new byte[6];
        this.poseToRegs(rawData, pose, xyToRaw, hToRaw);
        ((I2cDeviceSynch)this.deviceClient).write((int)reg, rawData);
    }

    protected Pose2D regsToPose(byte[] rawData, double rawToXY, double rawToH) {
        ByteBuffer data = ByteBuffer.wrap(rawData);
        data.order(ByteOrder.LITTLE_ENDIAN);
        short rawX = data.getShort(0);
        short rawY = data.getShort(2);
        short rawH = data.getShort(4);
        Pose2D pose = new Pose2D();
        pose.x = this._distanceUnit.fromMeters((double)rawX * rawToXY);
        pose.y = this._distanceUnit.fromMeters((double)rawY * rawToXY);
        pose.h = this._angularUnit.fromRadians((double)rawH * rawToH);
        return pose;
    }

    protected void poseToRegs(byte[] rawData, Pose2D pose, double xyToRaw, double hToRaw) {
        short rawX = (short)(this._distanceUnit.toMeters(pose.x) * xyToRaw);
        short rawY = (short)(this._distanceUnit.toMeters(pose.y) * xyToRaw);
        short rawH = (short)(this._angularUnit.toRadians(pose.h) * hToRaw);
        rawData[0] = (byte)(rawX & 0xFF);
        rawData[1] = (byte)(rawX >> 8 & 0xFF);
        rawData[2] = (byte)(rawY & 0xFF);
        rawData[3] = (byte)(rawY >> 8 & 0xFF);
        rawData[4] = (byte)(rawH & 0xFF);
        rawData[5] = (byte)(rawH >> 8 & 0xFF);
    }

    public static class Status {
        public boolean warnTiltAngle;
        public boolean warnOpticalTracking;
        public boolean errorPaa;
        public boolean errorLsm;

        public Status() {
            this.set((byte)0);
        }

        public Status(byte value) {
            this.set(value);
        }

        public void set(byte value) {
            this.warnTiltAngle = (value & 1) != 0;
            this.warnOpticalTracking = (value & 2) != 0;
            this.errorPaa = (value & 0x40) != 0;
            this.errorLsm = (value & 0x80) != 0;
        }

        public byte get() {
            return (byte)((this.warnTiltAngle ? 1 : 0) | (this.warnOpticalTracking ? 2 : 0) | (this.errorPaa ? 64 : 0) | (this.errorLsm ? 128 : 0));
        }
    }

    public static class SelfTestConfig {
        public boolean start;
        public boolean inProgress;
        public boolean pass;
        public boolean fail;

        public SelfTestConfig() {
            this.set((byte)0);
        }

        public SelfTestConfig(byte value) {
            this.set(value);
        }

        public void set(byte value) {
            this.start = (value & 1) != 0;
            this.inProgress = (value & 2) != 0;
            this.pass = (value & 4) != 0;
            this.fail = (value & 8) != 0;
        }

        public byte get() {
            return (byte)((this.start ? 1 : 0) | (this.inProgress ? 2 : 0) | (this.pass ? 4 : 0) | (this.fail ? 8 : 0));
        }
    }

    public static class SignalProcessConfig {
        public boolean enLut;
        public boolean enAcc;
        public boolean enRot;
        public boolean enVar;

        public SignalProcessConfig() {
            this.set((byte)0);
        }

        public SignalProcessConfig(byte value) {
            this.set(value);
        }

        public void set(byte value) {
            this.enLut = (value & 1) != 0;
            this.enAcc = (value & 2) != 0;
            this.enRot = (value & 4) != 0;
            this.enVar = (value & 8) != 0;
        }

        public byte get() {
            return (byte)((this.enLut ? 1 : 0) | (this.enAcc ? 2 : 0) | (this.enRot ? 4 : 0) | (this.enVar ? 8 : 0));
        }
    }

    public static class Version {
        public byte minor;
        public byte major;

        public Version() {
            this.set((byte)0);
        }

        public Version(byte value) {
            this.set(value);
        }

        public void set(byte value) {
            this.minor = (byte)(value & 0xF);
            this.major = (byte)(value >> 4 & 0xF);
        }

        public byte get() {
            return (byte)(this.major << 4 | this.minor);
        }
    }

    public static class Pose2D {
        public double x;
        public double y;
        public double h;

        public Pose2D() {
            this.x = 0.0;
            this.y = 0.0;
            this.h = 0.0;
        }

        public Pose2D(double x, double y, double h) {
            this.x = x;
            this.y = y;
            this.h = h;
        }

        public void set(Pose2D pose) {
            this.x = pose.x;
            this.y = pose.y;
            this.h = pose.h;
        }
    }
}

