/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.stmicroelectronics;

import com.qualcomm.robotcore.hardware.DistanceSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareDeviceHealth;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.TypeConversion;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

public class VL53L0X
extends I2cDeviceSynchDevice<I2cDeviceSynch>
implements DistanceSensor {
    public static final I2cAddr ADDRESS_I2C_DEFAULT = I2cAddr.create8bit((int)82);
    protected static final int FAKE_DISTANCE_MM = 65535;
    protected String MYTAG = "STMicroVL53L0X: ";
    private byte stop_variable = 0;
    private byte spad_count;
    private boolean spad_type_is_aperture;
    long measurement_timing_budget_us;
    protected int io_timeout = 0;
    protected ElapsedTime ioElapsedTime;
    boolean did_timeout = false;
    boolean assume_uninitialized = true;

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Other;
    }

    public String getDeviceName() {
        return "STMicroelectronics_VL53L0X_Range_Sensor";
    }

    public byte getModelID() {
        return this.readReg(Register.IDENTIFICATION_MODEL_ID);
    }

    public double getDistance(DistanceUnit unit) {
        double range = this.readRangeContinuousMillimeters();
        if (unit == DistanceUnit.CM) {
            return range / 10.0;
        }
        if (unit == DistanceUnit.METER) {
            return range / 1000.0;
        }
        if (unit == DistanceUnit.INCH) {
            return range / 25.4;
        }
        return range;
    }

    public boolean didTimeoutOccur() {
        return this.did_timeout;
    }

    public VL53L0X(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned);
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(ADDRESS_I2C_DEFAULT);
        super.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
        this.ioElapsedTime = new ElapsedTime(ElapsedTime.Resolution.MILLISECONDS);
        this.did_timeout = false;
    }

    protected synchronized boolean doInitialize() {
        RobotLog.dd((String)this.MYTAG, (String)"Checking to see if it's really a VL53L0X sensor...");
        byte bVal = ((I2cDeviceSynch)this.deviceClient).read8(192);
        RobotLog.dd((String)this.MYTAG, (String)"Reg 0xC0 = %x (should be 0xEE)", (Object[])new Object[]{bVal});
        bVal = ((I2cDeviceSynch)this.deviceClient).read8(193);
        RobotLog.dd((String)this.MYTAG, (String)"Reg 0xC1 = %x (should be 0xAA)", (Object[])new Object[]{bVal});
        bVal = ((I2cDeviceSynch)this.deviceClient).read8(194);
        RobotLog.dd((String)this.MYTAG, (String)"Reg 0xC2 = %x (should be 0x10)", (Object[])new Object[]{bVal});
        bVal = ((I2cDeviceSynch)this.deviceClient).read8(81);
        RobotLog.dd((String)this.MYTAG, (String)"Reg 0x51 = %x (should be 0x0099)", (Object[])new Object[]{bVal});
        bVal = ((I2cDeviceSynch)this.deviceClient).read8(97);
        RobotLog.dd((String)this.MYTAG, (String)"Reg 0x61 = %x (should be 0x0000)", (Object[])new Object[]{bVal});
        return this.initVL53L0X(false);
    }

    private boolean initVL53L0X(boolean bUse2v8) {
        if (bUse2v8) {
            this.writeReg(Register.VHV_CONFIG_PAD_SCL_SDA__EXTSUP_HV, (byte)(this.readReg(Register.VHV_CONFIG_PAD_SCL_SDA__EXTSUP_HV) | 1));
        }
        this.writeReg(136, 0);
        this.writeReg(128, 1);
        this.writeReg(255, 1);
        this.writeReg(0, 0);
        this.stop_variable = ((I2cDeviceSynch)this.deviceClient).read8(145);
        this.writeReg(0, 1);
        this.writeReg(255, 0);
        this.writeReg(128, 0);
        this.writeReg(Register.MSRC_CONFIG_CONTROL, (byte)(this.readReg(Register.MSRC_CONFIG_CONTROL) | 0x12));
        RobotLog.dd((String)this.MYTAG, (String)"initial sig rate lim (MCPS) %.06f", (Object[])new Object[]{Float.valueOf(this.getSignalRateLimit())});
        this.setSignalRateLimit(0.25f);
        RobotLog.dd((String)this.MYTAG, (String)"adjusted sig rate lim (MCPS) %.06f", (Object[])new Object[]{Float.valueOf(this.getSignalRateLimit())});
        this.writeReg(Register.SYSTEM_SEQUENCE_CONFIG, (byte)-1);
        if (!this.getSpadInfo()) {
            return false;
        }
        byte[] ref_spad_map = ((I2cDeviceSynch)this.deviceClient).read(Register.GLOBAL_CONFIG_SPAD_ENABLES_REF_0.bVal, 6);
        this.writeReg(255, 1);
        this.writeReg(Register.DYNAMIC_SPAD_REF_EN_START_OFFSET.bVal, 0);
        this.writeReg(Register.DYNAMIC_SPAD_NUM_REQUESTED_REF_SPAD.bVal, 44);
        this.writeReg(255, 0);
        this.writeReg(Register.GLOBAL_CONFIG_REF_EN_START_SELECT.bVal, 180);
        byte first_spad_to_enable = (byte)(this.spad_type_is_aperture ? 12 : 0);
        byte spads_enabled = 0;
        for (byte i = 0; i < 48; i = (byte)(i + 1)) {
            if (i < first_spad_to_enable || spads_enabled == this.spad_count) {
                int n = i / 8;
                ref_spad_map[n] = (byte)(ref_spad_map[n] & ~(1 << i % 8));
                continue;
            }
            if ((ref_spad_map[i / 8] >> i % 8 & 1) == 0) continue;
            spads_enabled = (byte)(spads_enabled + 1);
        }
        ((I2cDeviceSynch)this.deviceClient).write(Register.GLOBAL_CONFIG_SPAD_ENABLES_REF_0.bVal, ref_spad_map);
        this.writeReg(255, 1);
        this.writeReg(0, 0);
        this.writeReg(255, 0);
        this.writeReg(9, 0);
        this.writeReg(16, 0);
        this.writeReg(17, 0);
        this.writeReg(36, 1);
        this.writeReg(37, 255);
        this.writeReg(117, 0);
        this.writeReg(255, 1);
        this.writeReg(78, 44);
        this.writeReg(72, 0);
        this.writeReg(48, 32);
        this.writeReg(255, 0);
        this.writeReg(48, 9);
        this.writeReg(84, 0);
        this.writeReg(49, 4);
        this.writeReg(50, 3);
        this.writeReg(64, 131);
        this.writeReg(70, 37);
        this.writeReg(96, 0);
        this.writeReg(39, 0);
        this.writeReg(80, 6);
        this.writeReg(81, 0);
        this.writeReg(82, 150);
        this.writeReg(86, 8);
        this.writeReg(87, 48);
        this.writeReg(97, 0);
        this.writeReg(98, 0);
        this.writeReg(100, 0);
        this.writeReg(101, 0);
        this.writeReg(102, 160);
        this.writeReg(255, 1);
        this.writeReg(34, 50);
        this.writeReg(71, 20);
        this.writeReg(73, 255);
        this.writeReg(74, 0);
        this.writeReg(255, 0);
        this.writeReg(122, 10);
        this.writeReg(123, 0);
        this.writeReg(120, 33);
        this.writeReg(255, 1);
        this.writeReg(35, 52);
        this.writeReg(66, 0);
        this.writeReg(68, 255);
        this.writeReg(69, 38);
        this.writeReg(70, 5);
        this.writeReg(64, 64);
        this.writeReg(14, 6);
        this.writeReg(32, 26);
        this.writeReg(67, 64);
        this.writeReg(255, 0);
        this.writeReg(52, 3);
        this.writeReg(53, 68);
        this.writeReg(255, 1);
        this.writeReg(49, 4);
        this.writeReg(75, 9);
        this.writeReg(76, 5);
        this.writeReg(77, 4);
        this.writeReg(255, 0);
        this.writeReg(68, 0);
        this.writeReg(69, 32);
        this.writeReg(71, 8);
        this.writeReg(72, 40);
        this.writeReg(103, 0);
        this.writeReg(112, 4);
        this.writeReg(113, 1);
        this.writeReg(114, 254);
        this.writeReg(118, 0);
        this.writeReg(119, 0);
        this.writeReg(255, 1);
        this.writeReg(13, 1);
        this.writeReg(255, 0);
        this.writeReg(128, 1);
        this.writeReg(1, 248);
        this.writeReg(255, 1);
        this.writeReg(142, 1);
        this.writeReg(0, 1);
        this.writeReg(255, 0);
        this.writeReg(128, 0);
        this.writeReg(Register.SYSTEM_INTERRUPT_CONFIG_GPIO.bVal, 4);
        this.writeReg(Register.GPIO_HV_MUX_ACTIVE_HIGH.bVal, this.readReg(Register.GPIO_HV_MUX_ACTIVE_HIGH) & 0xFFFFFFEF);
        this.writeReg(Register.SYSTEM_INTERRUPT_CLEAR.bVal, 1);
        this.measurement_timing_budget_us = this.getMeasurementTimingBudget();
        this.writeReg(Register.SYSTEM_SEQUENCE_CONFIG.bVal, 232);
        this.setMeasurementTimingBudget(this.measurement_timing_budget_us);
        this.writeReg(Register.SYSTEM_SEQUENCE_CONFIG.bVal, 1);
        if (!this.performSingleRefCalibration(64)) {
            return false;
        }
        this.writeReg(Register.SYSTEM_SEQUENCE_CONFIG.bVal, 2);
        if (!this.performSingleRefCalibration(0)) {
            return false;
        }
        this.writeReg(Register.SYSTEM_SEQUENCE_CONFIG.bVal, 232);
        this.assume_uninitialized = false;
        this.setTimeout(200);
        this.startContinuous();
        return true;
    }

    private boolean setSignalRateLimit(float limit_Mcps) {
        if (limit_Mcps < 0.0f || (double)limit_Mcps > 511.99) {
            return false;
        }
        this.writeShort(Register.FINAL_RANGE_CONFIG_MIN_COUNT_RATE_RTN_LIMIT, (short)(limit_Mcps * 128.0f));
        return true;
    }

    private float getSignalRateLimit() {
        return (float)this.readShort(Register.FINAL_RANGE_CONFIG_MIN_COUNT_RATE_RTN_LIMIT) / 128.0f;
    }

    private boolean getSpadInfo() {
        this.writeReg(128, 1);
        this.writeReg(255, 1);
        this.writeReg(0, 0);
        this.writeReg(255, 6);
        this.writeReg(131, (int)((byte)(((I2cDeviceSynch)this.deviceClient).read8(131) | 4)));
        this.writeReg(255, 7);
        this.writeReg(129, 1);
        this.writeReg(128, 1);
        this.writeReg(148, 107);
        this.writeReg(131, 0);
        this.writeReg(131, 1);
        byte tmp = this.readReg(146);
        this.spad_count = (byte)(tmp & 0x7F);
        this.spad_type_is_aperture = (tmp >> 7 & 1) != 0;
        this.writeReg(129, 0);
        this.writeReg(255, 6);
        this.writeReg(131, this.readReg(131) & 0xFFFFFFFB);
        this.writeReg(255, 1);
        this.writeReg(0, 1);
        this.writeReg(255, 0);
        this.writeReg(128, 0);
        return true;
    }

    long getMeasurementTimingBudget() {
        SequenceStepEnables enables = new SequenceStepEnables();
        SequenceStepTimeouts timeouts = new SequenceStepTimeouts();
        int StartOverhead = 1910;
        int EndOverhead = 960;
        int MsrcOverhead = 660;
        int TccOverhead = 590;
        int DssOverhead = 690;
        int PreRangeOverhead = 660;
        int FinalRangeOverhead = 550;
        long budget_us = 2870L;
        this.getSequenceStepEnables(enables);
        this.getSequenceStepTimeouts(enables, timeouts);
        if (enables.tcc) {
            budget_us += timeouts.msrc_dss_tcc_us + 590L;
        }
        if (enables.dss) {
            budget_us += 2L * (timeouts.msrc_dss_tcc_us + 690L);
        } else if (enables.msrc) {
            budget_us += timeouts.msrc_dss_tcc_us + 660L;
        }
        if (enables.pre_range) {
            budget_us += timeouts.pre_range_us + 660L;
        }
        if (enables.final_range) {
            budget_us += timeouts.final_range_us + 550L;
        }
        this.measurement_timing_budget_us = budget_us;
        return budget_us;
    }

    protected void getSequenceStepEnables(SequenceStepEnables enables) {
        byte sequence_config = this.readReg(Register.SYSTEM_SEQUENCE_CONFIG);
        enables.tcc = (sequence_config >> 4 & 1) != 0;
        enables.dss = (sequence_config >> 3 & 1) != 0;
        enables.msrc = (sequence_config >> 2 & 1) != 0;
        enables.pre_range = (sequence_config >> 6 & 1) != 0;
        enables.final_range = (sequence_config >> 7 & 1) != 0;
    }

    protected void getSequenceStepTimeouts(SequenceStepEnables enables, SequenceStepTimeouts timeouts) {
        timeouts.pre_range_vcsel_period_pclks = this.getVcselPulsePeriod(vcselPeriodType.VcselPeriodPreRange);
        timeouts.msrc_dss_tcc_mclks = this.readReg(Register.MSRC_CONFIG_TIMEOUT_MACROP) + 1;
        timeouts.msrc_dss_tcc_us = this.timeoutMclksToMicroseconds(timeouts.msrc_dss_tcc_mclks, timeouts.pre_range_vcsel_period_pclks);
        timeouts.pre_range_mclks = this.decodeTimeout(this.readShort(Register.PRE_RANGE_CONFIG_TIMEOUT_MACROP_HI));
        timeouts.pre_range_us = this.timeoutMclksToMicroseconds(timeouts.pre_range_mclks, timeouts.pre_range_vcsel_period_pclks);
        timeouts.final_range_vcsel_period_pclks = this.getVcselPulsePeriod(vcselPeriodType.VcselPeriodFinalRange);
        timeouts.final_range_mclks = this.decodeTimeout(this.readShort(Register.FINAL_RANGE_CONFIG_TIMEOUT_MACROP_HI));
        if (enables.pre_range) {
            timeouts.final_range_mclks -= timeouts.pre_range_mclks;
        }
        timeouts.final_range_us = this.timeoutMclksToMicroseconds(timeouts.final_range_mclks, timeouts.final_range_vcsel_period_pclks);
    }

    int decodeTimeout(int reg_val) {
        return ((reg_val & 0xFF) << ((reg_val & 0xFF00) >> 8)) + 1;
    }

    protected int getVcselPulsePeriod(vcselPeriodType type) {
        if (type == vcselPeriodType.VcselPeriodPreRange) {
            return this.decodeVcselPeriod(this.readReg(Register.PRE_RANGE_CONFIG_VCSEL_PERIOD));
        }
        if (type == vcselPeriodType.VcselPeriodFinalRange) {
            return this.decodeVcselPeriod(this.readReg(Register.FINAL_RANGE_CONFIG_VCSEL_PERIOD));
        }
        return 255;
    }

    protected int decodeVcselPeriod(int reg_val) {
        int val = reg_val + 1 << 1;
        return val;
    }

    protected long timeoutMclksToMicroseconds(int timeout_period_mclks, int vcsel_period_pclks) {
        long macro_period_ns = this.calcMacroPeriod(vcsel_period_pclks);
        return ((long)timeout_period_mclks * macro_period_ns + macro_period_ns / 2L) / 1000L;
    }

    protected long calcMacroPeriod(int vcsel_period_pclks) {
        long val = (2304L * (long)vcsel_period_pclks * 1655L + 500L) / 1000L;
        return val;
    }

    protected boolean setMeasurementTimingBudget(long budget_us) {
        SequenceStepEnables enables = new SequenceStepEnables();
        SequenceStepTimeouts timeouts = new SequenceStepTimeouts();
        int StartOverhead = 1320;
        int EndOverhead = 960;
        int MsrcOverhead = 660;
        int TccOverhead = 590;
        int DssOverhead = 690;
        int PreRangeOverhead = 660;
        int FinalRangeOverhead = 550;
        long MinTimingBudget = 20000L;
        if (budget_us < 20000L) {
            return false;
        }
        long used_budget_us = 2280L;
        this.getSequenceStepEnables(enables);
        this.getSequenceStepTimeouts(enables, timeouts);
        if (enables.tcc) {
            used_budget_us += timeouts.msrc_dss_tcc_us + 590L;
        }
        if (enables.dss) {
            used_budget_us += 2L * (timeouts.msrc_dss_tcc_us + 690L);
        } else if (enables.msrc) {
            used_budget_us += timeouts.msrc_dss_tcc_us + 660L;
        }
        if (enables.pre_range) {
            used_budget_us += timeouts.pre_range_us + 660L;
        }
        if (enables.final_range) {
            if ((used_budget_us += 550L) > budget_us) {
                return false;
            }
            long final_range_timeout_us = budget_us - used_budget_us;
            long final_range_timeout_mclks = this.timeoutMicrosecondsToMclks(final_range_timeout_us, timeouts.final_range_vcsel_period_pclks);
            if (enables.pre_range) {
                final_range_timeout_mclks += (long)timeouts.pre_range_mclks;
            }
            this.writeShort(Register.FINAL_RANGE_CONFIG_TIMEOUT_MACROP_HI, (short)this.encodeTimeout((int)final_range_timeout_mclks));
            this.measurement_timing_budget_us = budget_us;
        }
        return true;
    }

    protected long timeoutMicrosecondsToMclks(long timeout_period_us, int vcsel_period_pclks) {
        long macro_period_ns = this.calcMacroPeriod(vcsel_period_pclks);
        return (timeout_period_us * 1000L + macro_period_ns / 2L) / macro_period_ns;
    }

    protected long encodeTimeout(int timeout_mclks) {
        long ls_byte = 0L;
        int ms_byte = 0;
        if (timeout_mclks > 0) {
            ls_byte = timeout_mclks - 1;
            while ((ls_byte & 0xFFFFFFFFFFFFFF00L) > 0L) {
                ls_byte >>= 1;
                ++ms_byte;
            }
            return (long)(ms_byte << 8) | ls_byte & 0xFFL;
        }
        return 0L;
    }

    protected boolean performSingleRefCalibration(int vhv_init_byte) {
        this.writeReg(Register.SYSRANGE_START.bVal, 1 | vhv_init_byte);
        this.writeReg(Register.SYSTEM_INTERRUPT_CLEAR.bVal, 1);
        this.writeReg(Register.SYSRANGE_START.bVal, 0);
        return true;
    }

    protected void startContinuous() {
        this.startContinuous(0);
    }

    protected void startContinuous(int period_ms) {
        this.writeReg(128, 1);
        this.writeReg(255, 1);
        this.writeReg(0, 0);
        this.writeReg(145, (int)this.stop_variable);
        this.writeReg(0, 1);
        this.writeReg(255, 0);
        this.writeReg(128, 0);
        if (period_ms != 0) {
            short osc_calibrate_val = this.readShort(Register.OSC_CALIBRATE_VAL);
            if (osc_calibrate_val != 0) {
                period_ms *= osc_calibrate_val;
            }
            ((I2cDeviceSynch)this.deviceClient).write(Register.SYSTEM_INTERMEASUREMENT_PERIOD.bVal, TypeConversion.intToByteArray((int)period_ms));
            this.writeReg(Register.SYSRANGE_START.bVal, 4);
        } else {
            this.writeReg(Register.SYSRANGE_START.bVal, 2);
        }
    }

    protected void stopContinuous() {
        this.writeReg(Register.SYSRANGE_START.bVal, 1);
        this.writeReg(255, 1);
        this.writeReg(0, 0);
        this.writeReg(145, 0);
        this.writeReg(0, 1);
        this.writeReg(255, 0);
    }

    protected void setTimeout(int timeout) {
        this.io_timeout = timeout;
    }

    protected int getTimeout() {
        return this.io_timeout;
    }

    protected int readRangeContinuousMillimeters() {
        if (this.io_timeout > 0) {
            this.ioElapsedTime.reset();
        }
        if (this.assume_uninitialized) {
            return 65535;
        }
        while ((this.readReg(Register.RESULT_INTERRUPT_STATUS) & 7) == 0) {
            if (this.did_timeout && ((I2cDeviceSynch)this.deviceClient).getHealthStatus() == HardwareDeviceHealth.HealthStatus.UNHEALTHY || Thread.currentThread().isInterrupted()) {
                return 65535;
            }
            if (!(this.ioElapsedTime.milliseconds() > (double)this.io_timeout)) continue;
            this.did_timeout = true;
            if (((I2cDeviceSynch)this.deviceClient).getHealthStatus() == HardwareDeviceHealth.HealthStatus.HEALTHY) {
                this.assume_uninitialized = true;
            }
            return 65535;
        }
        this.did_timeout = false;
        short range = TypeConversion.byteArrayToShort((byte[])((I2cDeviceSynch)this.deviceClient).read(Register.RESULT_RANGE_STATUS.bVal + 10, 2));
        this.writeReg(Register.SYSTEM_INTERRUPT_CLEAR.bVal, 1);
        return range;
    }

    protected byte readReg(Register reg) {
        return ((I2cDeviceSynch)this.deviceClient).read8(reg.bVal);
    }

    protected byte readReg(byte bVal) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)bVal);
    }

    protected byte readReg(int iVal) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)((byte)iVal));
    }

    protected void writeReg(Register reg, byte value) {
        this.writeReg(reg, value, I2cWaitControl.NONE);
    }

    protected void writeReg(byte addr, byte value) {
        this.writeReg(addr, value, I2cWaitControl.NONE);
    }

    protected void writeReg(int addr, int value) {
        this.writeReg((byte)addr, (byte)value, I2cWaitControl.NONE);
    }

    protected void writeReg(Register reg, byte value, I2cWaitControl waitControl) {
        ((I2cDeviceSynch)this.deviceClient).write8(reg.bVal, (int)value, waitControl);
    }

    protected void writeReg(byte addr, byte value, I2cWaitControl waitControl) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)addr, (int)value, waitControl);
    }

    protected void writeReg(int addr, int value, I2cWaitControl waitControl) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)((byte)addr), (int)((byte)value), waitControl);
    }

    protected int readUnsignedByte(Register reg) {
        return TypeConversion.unsignedByteToInt((byte)this.readReg(reg));
    }

    protected void writeShort(Register reg, short value) {
        ((I2cDeviceSynch)this.deviceClient).write(reg.bVal, TypeConversion.shortToByteArray((short)value));
    }

    protected short readShort(Register reg) {
        return TypeConversion.byteArrayToShort((byte[])((I2cDeviceSynch)this.deviceClient).read(reg.bVal, 2));
    }

    protected class SequenceStepTimeouts {
        int pre_range_vcsel_period_pclks;
        int final_range_vcsel_period_pclks;
        int msrc_dss_tcc_mclks;
        int pre_range_mclks;
        int final_range_mclks;
        long msrc_dss_tcc_us;
        long pre_range_us;
        long final_range_us;

        protected SequenceStepTimeouts() {
        }
    }

    protected class SequenceStepEnables {
        boolean tcc;
        boolean msrc;
        boolean dss;
        boolean pre_range;
        boolean final_range;

        protected SequenceStepEnables() {
        }
    }

    static enum vcselPeriodType {
        VcselPeriodPreRange,
        VcselPeriodFinalRange;

    }

    public static enum Register {
        SYSRANGE_START(0),
        SYSTEM_THRESH_HIGH(12),
        SYSTEM_THRESH_LOW(14),
        SYSTEM_SEQUENCE_CONFIG(1),
        SYSTEM_RANGE_CONFIG(9),
        SYSTEM_INTERMEASUREMENT_PERIOD(4),
        SYSTEM_INTERRUPT_CONFIG_GPIO(10),
        GPIO_HV_MUX_ACTIVE_HIGH(132),
        SYSTEM_INTERRUPT_CLEAR(11),
        RESULT_INTERRUPT_STATUS(19),
        RESULT_RANGE_STATUS(20),
        RESULT_CORE_AMBIENT_WINDOW_EVENTS_RTN(188),
        RESULT_CORE_RANGING_TOTAL_EVENTS_RTN(192),
        RESULT_CORE_AMBIENT_WINDOW_EVENTS_REF(208),
        RESULT_CORE_RANGING_TOTAL_EVENTS_REF(212),
        RESULT_PEAK_SIGNAL_RATE_REF(182),
        ALGO_PART_TO_PART_RANGE_OFFSET_MM(40),
        I2C_SLAVE_DEVICE_ADDRESS(138),
        MSRC_CONFIG_CONTROL(96),
        PRE_RANGE_CONFIG_MIN_SNR(39),
        PRE_RANGE_CONFIG_VALID_PHASE_LOW(86),
        PRE_RANGE_CONFIG_VALID_PHASE_HIGH(87),
        PRE_RANGE_MIN_COUNT_RATE_RTN_LIMIT(100),
        FINAL_RANGE_CONFIG_MIN_SNR(103),
        FINAL_RANGE_CONFIG_VALID_PHASE_LOW(71),
        FINAL_RANGE_CONFIG_VALID_PHASE_HIGH(72),
        FINAL_RANGE_CONFIG_MIN_COUNT_RATE_RTN_LIMIT(68),
        PRE_RANGE_CONFIG_SIGMA_THRESH_HI(97),
        PRE_RANGE_CONFIG_SIGMA_THRESH_LO(98),
        PRE_RANGE_CONFIG_VCSEL_PERIOD(80),
        PRE_RANGE_CONFIG_TIMEOUT_MACROP_HI(81),
        PRE_RANGE_CONFIG_TIMEOUT_MACROP_LO(82),
        SYSTEM_HISTOGRAM_BIN(129),
        HISTOGRAM_CONFIG_INITIAL_PHASE_SELECT(51),
        HISTOGRAM_CONFIG_READOUT_CTRL(85),
        FINAL_RANGE_CONFIG_VCSEL_PERIOD(112),
        FINAL_RANGE_CONFIG_TIMEOUT_MACROP_HI(113),
        FINAL_RANGE_CONFIG_TIMEOUT_MACROP_LO(114),
        CROSSTALK_COMPENSATION_PEAK_RATE_MCPS(32),
        MSRC_CONFIG_TIMEOUT_MACROP(70),
        SOFT_RESET_GO2_SOFT_RESET_N(191),
        IDENTIFICATION_MODEL_ID(192),
        IDENTIFICATION_REVISION_ID(194),
        OSC_CALIBRATE_VAL(248),
        GLOBAL_CONFIG_VCSEL_WIDTH(50),
        GLOBAL_CONFIG_SPAD_ENABLES_REF_0(176),
        GLOBAL_CONFIG_SPAD_ENABLES_REF_1(177),
        GLOBAL_CONFIG_SPAD_ENABLES_REF_2(178),
        GLOBAL_CONFIG_SPAD_ENABLES_REF_3(179),
        GLOBAL_CONFIG_SPAD_ENABLES_REF_4(180),
        GLOBAL_CONFIG_SPAD_ENABLES_REF_5(181),
        GLOBAL_CONFIG_REF_EN_START_SELECT(182),
        DYNAMIC_SPAD_NUM_REQUESTED_REF_SPAD(78),
        DYNAMIC_SPAD_REF_EN_START_OFFSET(79),
        POWER_MANAGEMENT_GO1_POWER_FORCE(128),
        VHV_CONFIG_PAD_SCL_SDA__EXTSUP_HV(137),
        ALGO_PHASECAL_LIM(48),
        ALGO_PHASECAL_CONFIG_TIMEOUT(48);

        public int bVal;

        private Register(int bVal) {
            this.bVal = bVal;
        }
    }
}

