/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.ams;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.ams.AMSColorSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDeviceWithParameters;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.Light;
import com.qualcomm.robotcore.hardware.NormalizedRGBA;
import com.qualcomm.robotcore.util.Range;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.system.Deadline;

public abstract class AMSColorSensorImpl
extends I2cDeviceSynchDeviceWithParameters<I2cDeviceSynchSimple, AMSColorSensor.Parameters>
implements AMSColorSensor,
I2cAddrConfig,
Light {
    public static final String TAG = "AMSColorSensorImpl";
    private float softwareGain = 1.0f;

    protected AMSColorSensorImpl(AMSColorSensor.Parameters params, I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(deviceClient, deviceClientIsOwned, (Object)params);
        this.deviceClient.setLogging(((AMSColorSensor.Parameters)this.parameters).loggingEnabled);
        this.deviceClient.setLoggingTag(((AMSColorSensor.Parameters)this.parameters).loggingTag);
        this.registerArmingStateCallback(true);
        this.engage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean internalInitialize(@NonNull AMSColorSensor.Parameters parameters) {
        RobotLog.vv((String)TAG, (String)"internalInitialize()...");
        try {
            if (((AMSColorSensor.Parameters)this.parameters).deviceId != parameters.deviceId) {
                throw new IllegalArgumentException(String.format("can't change device types (modify existing params instead): old=%d new=%d", ((AMSColorSensor.Parameters)this.parameters).deviceId, parameters.deviceId));
            }
            this.parameters = parameters.clone();
            this.setI2cAddress(parameters.i2cAddr);
            if (!this.deviceClient.isArmed()) {
                boolean bl = false;
                return bl;
            }
            byte id = this.getDeviceID();
            if (id != parameters.deviceId) {
                RobotLog.ee((String)TAG, (String)"unexpected AMS color sensor chipid: found=%d expected=%d", (Object[])new Object[]{id, parameters.deviceId});
                boolean bl = false;
                return bl;
            }
            this.dumpState();
            this.disable();
            this.setIntegrationTime(parameters.atime);
            this.setHardwareGain(parameters.gain);
            this.setPDrive(parameters.ledDrive);
            if (this.is3782() && parameters.useProximityIfAvailable) {
                this.setProximityPulseCount(parameters.proximityPulseCount);
            }
            this.enable();
            this.dumpState();
            if (this.deviceClient instanceof I2cDeviceSynch && parameters.readWindow != null) {
                I2cDeviceSynch synch = (I2cDeviceSynch)this.deviceClient;
                synch.setReadWindow(parameters.readWindow);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            RobotLog.vv((String)TAG, (String)"...internalInitialize()");
        }
    }

    protected void dumpState() {
        int cb = 25;
        RobotLog.logBytes((String)TAG, (String)"state", (byte[])this.read(AMSColorSensor.Register.ENABLE, cb), (int)cb);
    }

    protected synchronized void enable() {
        boolean needPEN;
        byte enabled = this.readEnable();
        RobotLog.vv((String)TAG, (String)"enable() enabled=0x%02x...", (Object[])new Object[]{enabled});
        boolean needPON = !this.testBits(enabled, AMSColorSensor.Enable.PON);
        boolean wantAEN = true;
        boolean needAEN = wantAEN && (needPON || !this.testBits(enabled, AMSColorSensor.Enable.AEN));
        boolean wantPEN = this.is3782() && ((AMSColorSensor.Parameters)this.parameters).useProximityIfAvailable;
        boolean bl = needPEN = wantPEN && !this.testBits(enabled, AMSColorSensor.Enable.PEN);
        if (needPON) {
            this.writeEnable(AMSColorSensor.Enable.PON.bVal);
        }
        this.delay(3);
        if (needAEN || needPEN) {
            this.writeEnable(AMSColorSensor.Enable.PON.bVal | (needAEN ? AMSColorSensor.Enable.AEN.bVal : (byte)0) | (needPEN ? AMSColorSensor.Enable.PEN.bVal : (byte)0));
        }
        enabled = this.readEnableAfterWrite();
        RobotLog.vv((String)TAG, (String)"...enable() enabled=0x%02x", (Object[])new Object[]{enabled});
    }

    protected synchronized void disable() {
        byte enabled = this.readEnable();
        RobotLog.vv((String)TAG, (String)"disable() enabled=0x%02x...", (Object[])new Object[]{enabled});
        this.writeEnable(enabled & ~(AMSColorSensor.Enable.PON.bVal | AMSColorSensor.Enable.AEN.bVal | AMSColorSensor.Enable.PEN.bVal));
        enabled = this.readEnableAfterWrite();
        RobotLog.vv((String)TAG, (String)"...disable() enabled=0x%02x", (Object[])new Object[]{enabled});
    }

    protected boolean isConnectedAndEnabled() {
        byte enabled = this.readEnable();
        return this.testBits(enabled, AMSColorSensor.Enable.PON);
    }

    protected boolean testBits(byte value, byte desired) {
        return this.testBits(value, desired, desired);
    }

    protected boolean testBits(byte value, byte mask, byte desired) {
        return (value & mask) == desired;
    }

    protected boolean testBits(byte value, AMSColorSensor.Enable desired) {
        return this.testBits(value, desired, desired);
    }

    protected boolean testBits(byte value, AMSColorSensor.Enable mask, AMSColorSensor.Enable desired) {
        return this.testBits(value, mask.bVal, desired.bVal);
    }

    protected void writeEnable(int value) {
        int reserved = (this.is3782() ? AMSColorSensor.Enable.PIEN.bVal : (byte)0) | AMSColorSensor.Enable.RES7.bVal | AMSColorSensor.Enable.RES6.bVal;
        int weDontUse = AMSColorSensor.Enable.PIEN.bVal | AMSColorSensor.Enable.AIEN.bVal;
        this.write8(AMSColorSensor.Register.ENABLE, value &= ~(weDontUse | reserved));
    }

    protected byte readEnable() {
        return this.read8(AMSColorSensor.Register.ENABLE);
    }

    protected byte readEnableAfterWrite() {
        this.delay(5);
        return this.readEnable();
    }

    protected void setIntegrationTime(int atime) {
        RobotLog.vv((String)TAG, (String)"setIntegrationTime(0x%02x)", (Object[])new Object[]{atime});
        this.write8(AMSColorSensor.Register.ATIME, atime);
    }

    protected void setProximityPulseCount(int proximityPulseCount) {
        RobotLog.vv((String)TAG, (String)"setProximityPulseCount(0x%02x)", (Object[])new Object[]{proximityPulseCount});
        this.write8(AMSColorSensor.Register.PPLUSE, proximityPulseCount);
    }

    protected boolean is3782() {
        return ((AMSColorSensor.Parameters)this.parameters).deviceId == 96 || ((AMSColorSensor.Parameters)this.parameters).deviceId == 105;
    }

    protected void setHardwareGain(AMSColorSensor.Gain gain) {
        RobotLog.vv((String)TAG, (String)"setGain(%s)", (Object[])new Object[]{gain});
        this.updateControl(AMSColorSensor.Gain.MASK.bVal, gain.bVal);
    }

    protected void setPDrive(AMSColorSensor.LEDDrive ledDrive) {
        RobotLog.vv((String)TAG, (String)"setPDrive(%s)", (Object[])new Object[]{ledDrive});
        this.updateControl(AMSColorSensor.LEDDrive.MASK.bVal, ledDrive.bVal);
    }

    protected void updateControl(int mask, int value) {
        int control = this.read8(AMSColorSensor.Register.CONTROL);
        if (this.is3782()) {
            control |= 0x20;
        }
        control = control & ~mask | value & mask;
        this.write8(AMSColorSensor.Register.CONTROL, control);
    }

    @Override
    public byte getDeviceID() {
        return this.read8(AMSColorSensor.Register.DEVICE_ID);
    }

    public float getGain() {
        return this.softwareGain;
    }

    public void setGain(float newGain) {
        this.softwareGain = newGain;
    }

    public synchronized int red() {
        return this.normalToUnsignedShort(this.getNormalizedColors().red);
    }

    public synchronized int green() {
        return this.normalToUnsignedShort(this.getNormalizedColors().green);
    }

    public synchronized int blue() {
        return this.normalToUnsignedShort(this.getNormalizedColors().blue);
    }

    public synchronized int alpha() {
        return this.normalToUnsignedShort(this.getNormalizedColors().alpha);
    }

    protected int normalToUnsignedShort(float normal) {
        return (int)(normal * (float)((AMSColorSensor.Parameters)this.parameters).getMaximumReading());
    }

    @ColorInt
    public synchronized int argb() {
        return this.getNormalizedColors().toColor();
    }

    public NormalizedRGBA getNormalizedColors() {
        int cbRead;
        Deadline deadline = new Deadline(2L, TimeUnit.SECONDS);
        byte[] data = null;
        while (!this.testBits((data = this.read(AMSColorSensor.Register.STATUS, cbRead = AMSColorSensor.Register.PDATA.bVal - AMSColorSensor.Register.STATUS.bVal))[0], AMSColorSensor.Status.AVALID.bVal)) {
            if (Thread.currentThread().isInterrupted() || !this.isConnectedAndEnabled() || deadline.hasExpired()) {
                return new NormalizedRGBA();
            }
            this.delay(3);
        }
        boolean dib = true;
        int alpha = TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
        int red = TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)3, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
        int green = TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)5, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
        int blue = TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)7, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
        float colorNormalizationFactor = 1.0f / (float)((AMSColorSensor.Parameters)this.parameters).getMaximumReading();
        NormalizedRGBA result = new NormalizedRGBA();
        result.alpha = Range.clip((float)((float)alpha * this.softwareGain * colorNormalizationFactor), (float)0.0f, (float)1.0f);
        result.red = Range.clip((float)((float)red * this.softwareGain * colorNormalizationFactor), (float)0.0f, (float)1.0f);
        result.green = Range.clip((float)((float)green * this.softwareGain * colorNormalizationFactor), (float)0.0f, (float)1.0f);
        result.blue = Range.clip((float)((float)blue * this.softwareGain * colorNormalizationFactor), (float)0.0f, (float)1.0f);
        return result;
    }

    public synchronized void enableLed(boolean enable) {
    }

    public boolean isLightOn() {
        return true;
    }

    public synchronized I2cAddr getI2cAddress() {
        return this.deviceClient.getI2cAddress();
    }

    public synchronized void setI2cAddress(I2cAddr i2cAddr) {
        ((AMSColorSensor.Parameters)this.parameters).i2cAddr = i2cAddr;
        this.deviceClient.setI2cAddress(i2cAddr);
    }

    public String getDeviceName() {
        return "AMS I2C Color Sensor";
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.AMS;
    }

    public void resetDeviceConfigurationForOpMode() {
        super.resetDeviceConfigurationForOpMode();
        this.softwareGain = 1.0f;
    }

    protected int readUnsignedByte(AMSColorSensor.Register reg) {
        return TypeConversion.unsignedByteToInt((byte)this.read8(reg));
    }

    protected int readUnsignedShort(AMSColorSensor.Register reg, ByteOrder byteOrder) {
        byte[] data = this.read(reg, 2);
        return TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)0, (ByteOrder)byteOrder));
    }

    @Override
    public synchronized byte read8(AMSColorSensor.Register reg) {
        return this.deviceClient.read8(reg.bVal | 0x80);
    }

    @Override
    public synchronized byte[] read(AMSColorSensor.Register reg, int cb) {
        return this.deviceClient.read(reg.bVal | 0x80, cb);
    }

    @Override
    public synchronized void write8(AMSColorSensor.Register reg, int data) {
        this.deviceClient.write8(reg.bVal | 0x80, data, I2cWaitControl.WRITTEN);
    }

    @Override
    public void write(AMSColorSensor.Register reg, byte[] data) {
        this.deviceClient.write(reg.bVal | 0x80 | 0x20, data, I2cWaitControl.WRITTEN);
    }

    protected void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

