/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.andymark;

import com.qualcomm.robotcore.hardware.ColorRangeSensor;
import com.qualcomm.robotcore.hardware.ColorSensor;
import com.qualcomm.robotcore.hardware.DistanceSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.NormalizedRGBA;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.Range;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

@I2cDeviceType
@DeviceProperties(name="AndyMark Proximity & Color Sensor", description="AndyMark Proximity & Color Sensor", xmlTag="AndyMarkColor")
public class AndyMarkColorSensor
extends I2cDeviceSynchDevice<I2cDeviceSynch>
implements ColorRangeSensor,
DistanceSensor,
ColorSensor {
    private static final int REG_PCFG1 = 143;
    private static final int REG_PCFG0 = 142;
    private static final I2cAddr I2C_ADDRESS = I2cAddr.create7bit((int)57);
    private static final int ID_REGISTER = 146;
    private static final int EXPECTED_ID = 228;
    private static final int STATUS_REGISTER = 147;
    private static final int WTIME_REGISTER = 131;
    private static final int ATIME_REGISTER = 129;
    private static final int CONTROL_REGISTER = 143;
    private static final int ENABLE_REGISTER = 128;
    private static final int PROXIMITY_DATA = 156;
    private static final int ALS_CLEAR_LOW = 148;
    private static final int ALS_CLEAR_HIGH = 149;
    private static final int ALS_RED_LOW = 150;
    private static final int ALS_RED_HIGH = 151;
    private static final int ALS_GREEN_LOW = 152;
    private static final int ALS_GREEN_HIGH = 153;
    private static final int ALS_BLUE_LOW = 154;
    private static final int ALS_BLUE_HIGH = 155;

    public AndyMarkColorSensor(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned);
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(I2C_ADDRESS);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    public String getDeviceName() {
        return "AndyMark Proximity & Color Sensor";
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.AMS;
    }

    public void setI2cAddress(I2cAddr newAddress) {
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(newAddress);
    }

    public I2cAddr getI2cAddress() {
        return ((I2cDeviceSynch)this.deviceClient).getI2cAddress();
    }

    protected boolean doInitialize() {
        this.writeRegister(128, 15);
        this.writeRegister(129, 255);
        this.writeRegister(131, 255);
        this.writeRegister(143, 111);
        return this.readRegister(146) == 228;
    }

    public String classifyColor() {
        int a = this.alpha();
        int r = this.red();
        int g = this.green();
        int b = this.blue();
        int brightness = r + g + b;
        if (a < 50 || brightness < 50) {
            return "Unknown";
        }
        if (brightness < 90) {
            return "Black";
        }
        if (brightness > 450) {
            return "White";
        }
        if (r > 115 && g > 90 && b < 45) {
            return "Yellow";
        }
        if (g > 45 && b > 38 && r < 40) {
            return "Cyan";
        }
        if (r > 65 && g < 30 && b < 30) {
            return "Magenta";
        }
        int margin = 10;
        if (r > g + margin && r > b + margin) {
            return "Red";
        }
        if (g > r + margin && g > b + margin) {
            return "Green";
        }
        if (b > r + margin && b > g + margin) {
            return "Blue";
        }
        return "Unknown";
    }

    public int argb() {
        int a = this.alpha();
        int r = this.red();
        int g = this.green();
        int b = this.blue();
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public NormalizedRGBA getNormalizedColors() {
        NormalizedRGBA normalized = new NormalizedRGBA();
        normalized.alpha = Range.clip((float)((float)this.alpha() / 65535.0f), (float)0.0f, (float)1.0f);
        normalized.red = Range.clip((float)((float)this.red() / 65535.0f), (float)0.0f, (float)1.0f);
        normalized.green = Range.clip((float)((float)this.green() / 65535.0f), (float)0.0f, (float)1.0f);
        normalized.blue = Range.clip((float)((float)this.blue() / 65535.0f), (float)0.0f, (float)1.0f);
        return normalized;
    }

    public int alpha() {
        return this.read16BitRegister(148, 149);
    }

    public double getRawLightDetected() {
        return Range.clip((double)((double)this.alpha() / 65535.0), (double)0.0, (double)1.0);
    }

    public double getLightDetected() {
        return this.getRawLightDetected();
    }

    public double getRawLightDetectedMax() {
        return 65535.0;
    }

    public int red() {
        return this.read16BitRegister(150, 151);
    }

    public int green() {
        return this.read16BitRegister(152, 153);
    }

    public int blue() {
        return this.read16BitRegister(154, 155);
    }

    public void enableLed(boolean enable) {
    }

    public void setGain(float gain) {
    }

    public float getGain() {
        return 1.0f;
    }

    public double getDistance(DistanceUnit unit) {
        int rawProximity = this.getProximity();
        double inDistance = this.inFromProximity(rawProximity);
        return unit.fromUnit(DistanceUnit.INCH, inDistance);
    }

    private double inFromProximity(int rawProximity) {
        double a = 250.0;
        double b = -1.25;
        double c = 0.0;
        double adjusted = Math.max((double)rawProximity - 0.0, 1.0);
        double distance_mm = Math.pow(adjusted / 250.0, -0.8);
        double distance_in = distance_mm / 25.4;
        distance_in = Math.max(0.25, Math.min(6.0, distance_in));
        return distance_in;
    }

    public int getProximity() {
        return this.readRegister(156);
    }

    public void setProximityGain(ProximityGain gain) {
        int pcfg1 = this.readRegister(143);
        pcfg1 &= 0x3F;
        this.writeRegister(143, pcfg1 |= gain.bits & 0xC0);
    }

    public void setProximityLedPulses(int pulses) {
        if (pulses < 1 || pulses > 64) {
            throw new IllegalArgumentException("Pulses must be between 1 and 64.");
        }
        int ppulseValue = pulses - 1;
        int pcfg0 = this.readRegister(142);
        pcfg0 &= 0xC0;
        this.writeRegister(142, pcfg0 |= ppulseValue & 0x3F);
    }

    public void setProximityLedPulseLength(ProximityPulseLength pulseLength) {
        int pcfg0 = this.readRegister(142);
        pcfg0 &= 0x3F;
        this.writeRegister(142, pcfg0 |= pulseLength.bits & 0xC0);
    }

    public void configureProximitySettings(ProximityGain gain, int pulses, ProximityPulseLength pulseLength) {
        this.setProximityGain(gain);
        this.setProximityLedPulses(pulses);
        this.setProximityLedPulseLength(pulseLength);
    }

    public String status() {
        return this.getDeviceName() + " connected";
    }

    private void writeRegister(int register, int value) {
        ((I2cDeviceSynch)this.deviceClient).write8(register, value);
    }

    private int readRegister(int register) {
        return ((I2cDeviceSynch)this.deviceClient).read8(register) & 0xFF;
    }

    private int read16BitRegister(int lowRegister, int highRegister) {
        int low = this.readRegister(lowRegister);
        int high = this.readRegister(highRegister);
        return high << 8 | low;
    }

    public static enum ProximityGain {
        GAIN_1X(0),
        GAIN_2X(64),
        GAIN_4X(128),
        GAIN_8X(192);

        public final int bits;

        private ProximityGain(int bits) {
            this.bits = bits;
        }
    }

    public static enum ProximityPulseLength {
        LENGTH_4US(0),
        LENGTH_8US(64),
        LENGTH_16US(128),
        LENGTH_32US(192);

        public final int bits;

        private ProximityPulseLength(int bits) {
            this.bits = bits;
        }
    }
}

