/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.andymark;

import com.qualcomm.robotcore.hardware.ImuOrientationOnRobot;
import com.qualcomm.robotcore.hardware.QuaternionBasedImuHelper;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;

public class AndyMarkIMUOrientationOnRobot
implements ImuOrientationOnRobot {
    private final Quaternion robotCoordinateSystemFromPerspectiveOfImu;
    private final Quaternion imuRotationOffset;
    private final Quaternion angularVelocityTransform;

    public AndyMarkIMUOrientationOnRobot(LogoFacingDirection logoFacingDirection, I2cPortFacingDirection i2cPortFacingDirection) {
        this(AndyMarkIMUOrientationOnRobot.friendlyApiToOrientation(logoFacingDirection, i2cPortFacingDirection));
    }

    public AndyMarkIMUOrientationOnRobot(Orientation rotation) {
        this(Quaternion.fromMatrix((MatrixF)rotation.getRotationMatrix(), (long)0L));
    }

    public AndyMarkIMUOrientationOnRobot(Quaternion rotation) {
        Quaternion imuRotation = QuaternionBasedImuHelper.quaternionFromZAxisRotation((float)-90.0f, (AngleUnit)AngleUnit.DEGREES);
        rotation = rotation.multiply(imuRotation, 0L).normalized();
        this.angularVelocityTransform = new Quaternion(rotation.w, rotation.x, rotation.y, rotation.z, 0L);
        this.robotCoordinateSystemFromPerspectiveOfImu = new Quaternion(rotation.w, 0.0f, 0.0f, rotation.z, 0L).normalized();
        rotation = rotation.multiply(this.robotCoordinateSystemFromPerspectiveOfImu.inverse(), 0L).normalized();
        this.imuRotationOffset = rotation.inverse().normalized();
    }

    public Quaternion imuCoordinateSystemOrientationFromPerspectiveOfRobot() {
        return this.robotCoordinateSystemFromPerspectiveOfImu;
    }

    public Quaternion imuRotationOffset() {
        return this.imuRotationOffset;
    }

    public Quaternion angularVelocityTransform() {
        return this.angularVelocityTransform;
    }

    protected static Orientation friendlyApiToOrientation(LogoFacingDirection logoFacingDirection, I2cPortFacingDirection i2cPortFacingDirection) {
        if (logoFacingDirection == LogoFacingDirection.UP) {
            if (i2cPortFacingDirection == I2cPortFacingDirection.UP) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else if (i2cPortFacingDirection == I2cPortFacingDirection.DOWN) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else {
                if (i2cPortFacingDirection == I2cPortFacingDirection.FORWARD) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(0.0, 0.0, 0.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.BACKWARD) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(180.0, 0.0, 0.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.LEFT) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(90.0, 0.0, 0.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.RIGHT) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(-90.0, 0.0, 0.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.DOWN) {
            if (i2cPortFacingDirection == I2cPortFacingDirection.UP) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else if (i2cPortFacingDirection == I2cPortFacingDirection.DOWN) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else {
                if (i2cPortFacingDirection == I2cPortFacingDirection.FORWARD) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(0.0, 180.0, 0.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.BACKWARD) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(180.0, 180.0, 0.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.LEFT) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(90.0, 180.0, 0.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.RIGHT) {
                    return AndyMarkIMUOrientationOnRobot.zyxOrientation(-90.0, 180.0, 0.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.FORWARD) {
            if (i2cPortFacingDirection == I2cPortFacingDirection.UP) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(90.0, 180.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.DOWN) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(-90.0, 0.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.FORWARD) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else if (i2cPortFacingDirection == I2cPortFacingDirection.BACKWARD) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else {
                if (i2cPortFacingDirection == I2cPortFacingDirection.LEFT) {
                    return AndyMarkIMUOrientationOnRobot.xyzOrientation(-90.0, 0.0, 90.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.RIGHT) {
                    return AndyMarkIMUOrientationOnRobot.xyzOrientation(-90.0, 0.0, -90.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.BACKWARD) {
            if (i2cPortFacingDirection == I2cPortFacingDirection.UP) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(90.0, 0.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.DOWN) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(90.0, 0.0, 180.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.FORWARD) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else if (i2cPortFacingDirection == I2cPortFacingDirection.BACKWARD) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else {
                if (i2cPortFacingDirection == I2cPortFacingDirection.LEFT) {
                    return AndyMarkIMUOrientationOnRobot.xyzOrientation(90.0, 0.0, 90.0);
                }
                if (i2cPortFacingDirection == I2cPortFacingDirection.RIGHT) {
                    return AndyMarkIMUOrientationOnRobot.xyzOrientation(90.0, 0.0, -90.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.LEFT) {
            if (i2cPortFacingDirection == I2cPortFacingDirection.UP) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(90.0, -90.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.DOWN) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(-90.0, -90.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.FORWARD) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(0.0, -90.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.BACKWARD) {
                return AndyMarkIMUOrientationOnRobot.xyzOrientation(0.0, -90.0, 180.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.LEFT) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else if (i2cPortFacingDirection == I2cPortFacingDirection.RIGHT) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            }
        } else if (logoFacingDirection == LogoFacingDirection.RIGHT) {
            if (i2cPortFacingDirection == I2cPortFacingDirection.UP) {
                return AndyMarkIMUOrientationOnRobot.zyxOrientation(90.0, 0.0, 90.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.DOWN) {
                return AndyMarkIMUOrientationOnRobot.zyxOrientation(-90.0, 0.0, -90.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.FORWARD) {
                return AndyMarkIMUOrientationOnRobot.zyxOrientation(0.0, 90.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.BACKWARD) {
                return AndyMarkIMUOrientationOnRobot.zyxOrientation(180.0, -90.0, 0.0);
            }
            if (i2cPortFacingDirection == I2cPortFacingDirection.LEFT) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            } else if (i2cPortFacingDirection == I2cPortFacingDirection.RIGHT) {
                AndyMarkIMUOrientationOnRobot.throwIllegalImuOrientationException();
            }
        }
        throw new RuntimeException("The FTC SDK developers forgot about this combination, please file a bug report.");
    }

    private static void throwIllegalImuOrientationException() {
        throw new IllegalArgumentException("The specified AndyMark IMU orientation is physically impossible");
    }

    public static Orientation zyxOrientation(double z, double y, double x) {
        return new Orientation(AxesReference.INTRINSIC, AxesOrder.ZYX, AngleUnit.DEGREES, (float)z, (float)y, (float)x, 0L);
    }

    public static Orientation xyzOrientation(double x, double y, double z) {
        return new Orientation(AxesReference.INTRINSIC, AxesOrder.XYZ, AngleUnit.DEGREES, (float)x, (float)y, (float)z, 0L);
    }

    public static enum LogoFacingDirection {
        UP,
        DOWN,
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT;

    }

    public static enum I2cPortFacingDirection {
        UP,
        DOWN,
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT;

    }
}

