/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.Locale;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.MagneticFlux;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.Temperature;
import org.firstinspires.ftc.robotcore.external.navigation.Velocity;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;

public interface BNO055IMU {
    public static final I2cAddr I2CADDR_UNSPECIFIED = I2cAddr.zero();
    public static final I2cAddr I2CADDR_DEFAULT = I2cAddr.create7bit((int)40);
    public static final I2cAddr I2CADDR_ALTERNATE = I2cAddr.create7bit((int)41);

    public boolean initialize(@NonNull Parameters var1);

    @NonNull
    public Parameters getParameters();

    public void close();

    public Orientation getAngularOrientation();

    public Orientation getAngularOrientation(AxesReference var1, AxesOrder var2, org.firstinspires.ftc.robotcore.external.navigation.AngleUnit var3);

    public Acceleration getOverallAcceleration();

    public AngularVelocity getAngularVelocity();

    public Acceleration getLinearAcceleration();

    public Acceleration getGravity();

    public Temperature getTemperature();

    public MagneticFlux getMagneticFieldStrength();

    public Quaternion getQuaternionOrientation();

    public Position getPosition();

    public Velocity getVelocity();

    public Acceleration getAcceleration();

    public void startAccelerationIntegration(Position var1, Velocity var2, int var3);

    public void stopAccelerationIntegration();

    public SystemStatus getSystemStatus();

    public SystemError getSystemError();

    public CalibrationStatus getCalibrationStatus();

    public boolean isSystemCalibrated();

    public boolean isGyroCalibrated();

    public boolean isAccelerometerCalibrated();

    public boolean isMagnetometerCalibrated();

    public CalibrationData readCalibrationData();

    public void writeCalibrationData(CalibrationData var1);

    public byte read8(Register var1);

    public byte[] read(Register var1, int var2);

    public void write8(Register var1, int var2);

    public void write(Register var1, byte[] var2);

    public static enum Register {
        PAGE_ID(7),
        CHIP_ID(0),
        ACC_ID(1),
        MAG_ID(2),
        GYR_ID(3),
        SW_REV_ID_LSB(4),
        SW_REV_ID_MSB(5),
        BL_REV_ID(6),
        ACC_DATA_X_LSB(8),
        ACC_DATA_X_MSB(9),
        ACC_DATA_Y_LSB(10),
        ACC_DATA_Y_MSB(11),
        ACC_DATA_Z_LSB(12),
        ACC_DATA_Z_MSB(13),
        MAG_DATA_X_LSB(14),
        MAG_DATA_X_MSB(15),
        MAG_DATA_Y_LSB(16),
        MAG_DATA_Y_MSB(17),
        MAG_DATA_Z_LSB(18),
        MAG_DATA_Z_MSB(19),
        GYR_DATA_X_LSB(20),
        GYR_DATA_X_MSB(21),
        GYR_DATA_Y_LSB(22),
        GYR_DATA_Y_MSB(23),
        GYR_DATA_Z_LSB(24),
        GYR_DATA_Z_MSB(25),
        EUL_H_LSB(26),
        EUL_H_MSB(27),
        EUL_R_LSB(28),
        EUL_R_MSB(29),
        EUL_P_LSB(30),
        EUL_P_MSB(31),
        QUA_DATA_W_LSB(32),
        QUA_DATA_W_MSB(33),
        QUA_DATA_X_LSB(34),
        QUA_DATA_X_MSB(35),
        QUA_DATA_Y_LSB(36),
        QUA_DATA_Y_MSB(37),
        QUA_DATA_Z_LSB(38),
        QUA_DATA_Z_MSB(39),
        LIA_DATA_X_LSB(40),
        LIA_DATA_X_MSB(41),
        LIA_DATA_Y_LSB(42),
        LIA_DATA_Y_MSB(43),
        LIA_DATA_Z_LSB(44),
        LIA_DATA_Z_MSB(45),
        GRV_DATA_X_LSB(46),
        GRV_DATA_X_MSB(47),
        GRV_DATA_Y_LSB(48),
        GRV_DATA_Y_MSB(49),
        GRV_DATA_Z_LSB(50),
        GRV_DATA_Z_MSB(51),
        TEMP(52),
        CALIB_STAT(53),
        SELFTEST_RESULT(54),
        INTR_STAT(55),
        SYS_CLK_STAT(56),
        SYS_STAT(57),
        SYS_ERR(58),
        UNIT_SEL(59),
        DATA_SELECT(60),
        OPR_MODE(61),
        PWR_MODE(62),
        SYS_TRIGGER(63),
        TEMP_SOURCE(64),
        AXIS_MAP_CONFIG(65),
        AXIS_MAP_SIGN(66),
        SIC_MATRIX_0_LSB(67),
        SIC_MATRIX_0_MSB(68),
        SIC_MATRIX_1_LSB(69),
        SIC_MATRIX_1_MSB(70),
        SIC_MATRIX_2_LSB(71),
        SIC_MATRIX_2_MSB(72),
        SIC_MATRIX_3_LSB(73),
        SIC_MATRIX_3_MSB(74),
        SIC_MATRIX_4_LSB(75),
        SIC_MATRIX_4_MSB(76),
        SIC_MATRIX_5_LSB(77),
        SIC_MATRIX_5_MSB(78),
        SIC_MATRIX_6_LSB(79),
        SIC_MATRIX_6_MSB(80),
        SIC_MATRIX_7_LSB(81),
        SIC_MATRIX_7_MSB(82),
        SIC_MATRIX_8_LSB(83),
        SIC_MATRIX_8_MSB(84),
        ACC_OFFSET_X_LSB(85),
        ACC_OFFSET_X_MSB(86),
        ACC_OFFSET_Y_LSB(87),
        ACC_OFFSET_Y_MSB(88),
        ACC_OFFSET_Z_LSB(89),
        ACC_OFFSET_Z_MSB(90),
        MAG_OFFSET_X_LSB(91),
        MAG_OFFSET_X_MSB(92),
        MAG_OFFSET_Y_LSB(93),
        MAG_OFFSET_Y_MSB(94),
        MAG_OFFSET_Z_LSB(95),
        MAG_OFFSET_Z_MSB(96),
        GYR_OFFSET_X_LSB(97),
        GYR_OFFSET_X_MSB(98),
        GYR_OFFSET_Y_LSB(99),
        GYR_OFFSET_Y_MSB(100),
        GYR_OFFSET_Z_LSB(101),
        GYR_OFFSET_Z_MSB(102),
        ACC_RADIUS_LSB(103),
        ACC_RADIUS_MSB(104),
        MAG_RADIUS_LSB(105),
        MAG_RADIUS_MSB(106),
        ACC_CONFIG(8),
        MAG_CONFIG(9),
        GYR_CONFIG_0(10),
        GYR_CONFIG_1(11),
        ACC_SLEEP_CONFIG(12),
        GYR_SLEEP_CONFIG(13),
        INT_MSK(15),
        INT_EN(16),
        ACC_AM_THRES(17),
        ACC_INT_SETTINGS(18),
        ACC_HG_DURATION(19),
        ACC_HG_THRES(20),
        ACC_NM_THRES(21),
        ACC_NM_SET(22),
        GRYO_INT_SETTING(23),
        GRYO_HR_X_SET(24),
        GRYO_DUR_X(25),
        GRYO_HR_Y_SET(26),
        GRYO_DUR_Y(27),
        GRYO_HR_Z_SET(28),
        GRYO_DUR_Z(29),
        GRYO_AM_THRES(30),
        GRYO_AM_SET(31),
        UNIQUE_ID_FIRST(80),
        UNIQUE_ID_LAST(95);

        public final byte bVal;

        private Register(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum SensorMode {
        CONFIG(0),
        ACCONLY(1),
        MAGONLY(2),
        GYRONLY(3),
        ACCMAG(4),
        ACCGYRO(5),
        MAGGYRO(6),
        AMG(7),
        IMU(8),
        COMPASS(9),
        M4G(10),
        NDOF_FMC_OFF(11),
        NDOF(12),
        DISABLED(-1);

        public final byte bVal;

        private SensorMode(int i) {
            this.bVal = (byte)i;
        }

        public boolean isFusionMode() {
            switch (this) {
                case IMU: 
                case COMPASS: 
                case M4G: 
                case NDOF_FMC_OFF: 
                case NDOF: {
                    return true;
                }
            }
            return false;
        }

        public static SensorMode fromByte(byte b) {
            b = (byte)(b & 0xF);
            for (SensorMode sensorMode : SensorMode.values()) {
                if (sensorMode.bVal != b) continue;
                return sensorMode;
            }
            RobotLog.ee((String)"BNO055", (Throwable)new RuntimeException(), (String)"Unexpected SensorMode value: 0x%X", (Object[])new Object[]{b});
            return IMU;
        }
    }

    public static class CalibrationStatus {
        public final byte calibrationStatus;

        public CalibrationStatus(int calibrationStatus) {
            this.calibrationStatus = (byte)calibrationStatus;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(String.format(Locale.getDefault(), "s%d", this.calibrationStatus >> 6 & 3));
            result.append(" ");
            result.append(String.format(Locale.getDefault(), "g%d", this.calibrationStatus >> 4 & 3));
            result.append(" ");
            result.append(String.format(Locale.getDefault(), "a%d", this.calibrationStatus >> 2 & 3));
            result.append(" ");
            result.append(String.format(Locale.getDefault(), "m%d", this.calibrationStatus >> 0 & 3));
            return result.toString();
        }
    }

    public static enum SystemError {
        UNKNOWN(-1),
        NO_ERROR(0),
        PERIPHERAL_INITIALIZATION_ERROR(1),
        SYSTEM_INITIALIZATION_ERROR(2),
        SELF_TEST_FAILED(3),
        REGISTER_MAP_OUT_OF_RANGE(4),
        REGISTER_MAP_ADDRESS_OUT_OF_RANGE(5),
        REGISTER_MAP_WRITE_ERROR(6),
        LOW_POWER_MODE_NOT_AVAILABLE(7),
        ACCELEROMETER_POWER_MODE_NOT_AVAILABLE(8),
        FUSION_CONFIGURATION_ERROR(9),
        SENSOR_CONFIGURATION_ERROR(10);

        public final byte bVal;

        private SystemError(int value) {
            this.bVal = (byte)value;
        }

        public static SystemError from(int value) {
            for (SystemError systemError : SystemError.values()) {
                if (systemError.bVal != value) continue;
                return systemError;
            }
            return UNKNOWN;
        }
    }

    public static enum SystemStatus {
        UNKNOWN(-1),
        IDLE(0),
        SYSTEM_ERROR(1),
        INITIALIZING_PERIPHERALS(2),
        SYSTEM_INITIALIZATION(3),
        SELF_TEST(4),
        RUNNING_FUSION(5),
        RUNNING_NO_FUSION(6);

        public final byte bVal;

        private SystemStatus(int value) {
            this.bVal = (byte)value;
        }

        public static SystemStatus from(int value) {
            for (SystemStatus systemStatus : SystemStatus.values()) {
                if (systemStatus.bVal != value) continue;
                return systemStatus;
            }
            return UNKNOWN;
        }

        public String toShortString() {
            switch (this) {
                case IDLE: {
                    return "idle";
                }
                case SYSTEM_ERROR: {
                    return "syserr";
                }
                case INITIALIZING_PERIPHERALS: {
                    return "periph";
                }
                case SYSTEM_INITIALIZATION: {
                    return "sysinit";
                }
                case SELF_TEST: {
                    return "selftest";
                }
                case RUNNING_FUSION: {
                    return "fusion";
                }
                case RUNNING_NO_FUSION: {
                    return "running";
                }
            }
            return "unk";
        }
    }

    public static enum MagPowerMode {
        NORMAL(0),
        SLEEP(1),
        SUSPEND(2),
        FORCE(3);

        public final byte bVal;

        private MagPowerMode(int i) {
            this.bVal = (byte)(i << 5);
        }
    }

    public static enum MagOpMode {
        LOW(0),
        REGULAR(1),
        ENHANCED(2),
        HIGH(3);

        public final byte bVal;

        private MagOpMode(int i) {
            this.bVal = (byte)(i << 3);
        }
    }

    public static enum MagRate {
        HZ2(0),
        HZ6(1),
        HZ8(2),
        HZ10(3),
        HZ15(4),
        HZ20(5),
        HZ25(6),
        HZ30(7);

        public final byte bVal;

        private MagRate(int i) {
            this.bVal = (byte)(i << 0);
        }
    }

    public static enum AccelPowerMode {
        NORMAL(0),
        SUSPEND(1),
        LOW1(2),
        STANDBY(3),
        LOW2(4),
        DEEP(5);

        public final byte bVal;

        private AccelPowerMode(int i) {
            this.bVal = (byte)(i << 5);
        }
    }

    public static enum AccelBandwidth {
        HZ7_81(0),
        HZ15_63(1),
        HZ31_25(2),
        HZ62_5(3),
        HZ125(4),
        HZ250(5),
        HZ500(6),
        HZ1000(7);

        public final byte bVal;

        private AccelBandwidth(int i) {
            this.bVal = (byte)(i << 2);
        }
    }

    public static enum AccelRange {
        G2(0),
        G4(1),
        G8(2),
        G16(3);

        public final byte bVal;

        private AccelRange(int i) {
            this.bVal = (byte)(i << 0);
        }
    }

    public static enum GyroPowerMode {
        NORMAL(0),
        FAST(1),
        DEEP(2),
        SUSPEND(3),
        ADVANCED(4);

        public final byte bVal;

        private GyroPowerMode(int i) {
            this.bVal = (byte)(i << 0);
        }
    }

    public static enum GyroBandwidth {
        HZ523(0),
        HZ230(1),
        HZ116(2),
        HZ47(3),
        HZ23(4),
        HZ12(5),
        HZ64(6),
        HZ32(7);

        public final byte bVal;

        private GyroBandwidth(int i) {
            this.bVal = (byte)(i << 3);
        }
    }

    public static enum GyroRange {
        DPS2000(0),
        DPS1000(1),
        DPS500(2),
        DPS250(3),
        DPS125(4);

        public final byte bVal;

        private GyroRange(int i) {
            this.bVal = (byte)(i << 0);
        }
    }

    public static enum PitchMode {
        WINDOWS(0),
        ANDROID(1);

        public final byte bVal;

        private PitchMode(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum AccelUnit {
        METERS_PERSEC_PERSEC(0),
        MILLI_EARTH_GRAVITY(1);

        public final byte bVal;

        private AccelUnit(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum AngleUnit {
        DEGREES(0),
        RADIANS(1);

        public final byte bVal;

        private AngleUnit(int i) {
            this.bVal = (byte)i;
        }

        public org.firstinspires.ftc.robotcore.external.navigation.AngleUnit toAngleUnit() {
            if (this == DEGREES) {
                return org.firstinspires.ftc.robotcore.external.navigation.AngleUnit.DEGREES;
            }
            return org.firstinspires.ftc.robotcore.external.navigation.AngleUnit.RADIANS;
        }

        public static AngleUnit fromAngleUnit(org.firstinspires.ftc.robotcore.external.navigation.AngleUnit angleUnit) {
            if (angleUnit == org.firstinspires.ftc.robotcore.external.navigation.AngleUnit.DEGREES) {
                return DEGREES;
            }
            return RADIANS;
        }
    }

    public static enum TempUnit {
        CELSIUS(0),
        FARENHEIT(1);

        public final byte bVal;

        private TempUnit(int i) {
            this.bVal = (byte)i;
        }

        public org.firstinspires.ftc.robotcore.external.navigation.TempUnit toTempUnit() {
            if (this == CELSIUS) {
                return org.firstinspires.ftc.robotcore.external.navigation.TempUnit.CELSIUS;
            }
            return org.firstinspires.ftc.robotcore.external.navigation.TempUnit.FARENHEIT;
        }

        public static TempUnit fromTempUnit(org.firstinspires.ftc.robotcore.external.navigation.TempUnit tempUnit) {
            if (tempUnit == org.firstinspires.ftc.robotcore.external.navigation.TempUnit.CELSIUS) {
                return CELSIUS;
            }
            if (tempUnit == org.firstinspires.ftc.robotcore.external.navigation.TempUnit.FARENHEIT) {
                return FARENHEIT;
            }
            throw new UnsupportedOperationException("TempUnit." + tempUnit + " is not supported by BNO055IMU");
        }
    }

    public static class CalibrationData
    implements Cloneable {
        public short dxAccel;
        public short dyAccel;
        public short dzAccel;
        public short dxMag;
        public short dyMag;
        public short dzMag;
        public short dxGyro;
        public short dyGyro;
        public short dzGyro;
        public short radiusAccel;
        public short radiusMag;

        public String serialize() {
            return SimpleGson.getInstance().toJson((Object)this);
        }

        public static CalibrationData deserialize(String data) {
            return (CalibrationData)SimpleGson.getInstance().fromJson(data, CalibrationData.class);
        }

        public CalibrationData clone() {
            try {
                CalibrationData result = (CalibrationData)super.clone();
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("internal error: CalibrationData can't be cloned");
            }
        }
    }

    public static interface AccelerationIntegrator {
        public void initialize(@NonNull Parameters var1, @Nullable Position var2, @Nullable Velocity var3);

        public Position getPosition();

        public Velocity getVelocity();

        public Acceleration getAcceleration();

        public void update(Acceleration var1);
    }

    public static class Parameters
    implements Cloneable {
        public I2cAddr i2cAddr = I2CADDR_DEFAULT;
        public SensorMode mode = SensorMode.IMU;
        public boolean useExternalCrystal = true;
        public TempUnit temperatureUnit = TempUnit.CELSIUS;
        public AngleUnit angleUnit = AngleUnit.RADIANS;
        public AccelUnit accelUnit = AccelUnit.METERS_PERSEC_PERSEC;
        @Deprecated
        public PitchMode pitchMode = PitchMode.ANDROID;
        public AccelRange accelRange = AccelRange.G4;
        public AccelBandwidth accelBandwidth = AccelBandwidth.HZ62_5;
        public AccelPowerMode accelPowerMode = AccelPowerMode.NORMAL;
        public GyroRange gyroRange = GyroRange.DPS2000;
        public GyroBandwidth gyroBandwidth = GyroBandwidth.HZ32;
        public GyroPowerMode gyroPowerMode = GyroPowerMode.NORMAL;
        public MagRate magRate = MagRate.HZ10;
        public MagOpMode magOpMode = MagOpMode.REGULAR;
        public MagPowerMode magPowerMode = MagPowerMode.NORMAL;
        public CalibrationData calibrationData = null;
        public String calibrationDataFile = null;
        public AccelerationIntegrator accelerationIntegrationAlgorithm = null;
        public boolean loggingEnabled = false;
        public String loggingTag = "BNO055IMU";

        public Parameters clone() {
            try {
                Parameters result = (Parameters)super.clone();
                result.calibrationData = result.calibrationData == null ? null : result.calibrationData.clone();
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("internal error: Parameters can't be cloned");
            }
        }
    }
}

