/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import android.util.Log;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.hardware.bosch.BNO055Util;
import com.qualcomm.hardware.bosch.NaiveAccelerationIntegrator;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.hardware.Gyroscope;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDeviceWithParameters;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.I2cWarningManager;
import com.qualcomm.robotcore.hardware.IntegratingGyroscope;
import com.qualcomm.robotcore.hardware.QuaternionBasedImuHelper;
import com.qualcomm.robotcore.hardware.TimestampedData;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.external.Func;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Axis;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.external.navigation.MagneticFlux;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.Temperature;
import org.firstinspires.ftc.robotcore.external.navigation.Velocity;

public abstract class BNO055IMUImpl
extends I2cDeviceSynchDeviceWithParameters<I2cDeviceSynch, BNO055IMU.Parameters>
implements BNO055IMU,
Gyroscope,
IntegratingGyroscope,
I2cAddrConfig,
OpModeManagerNotifier.Notifications {
    protected final Object dataLock = new Object();
    protected BNO055IMU.AccelerationIntegrator accelerationAlgorithm;
    protected final Object startStopLock = new Object();
    protected ExecutorService accelerationMananger;
    protected float delayScale = 1.0f;
    protected static final int msAwaitChipId = 2000;
    protected static final int msAwaitSelfTest = 2000;
    protected static final I2cDeviceSynch.ReadMode readMode = I2cDeviceSynch.ReadMode.REPEAT;
    protected static final I2cDeviceSynch.ReadWindow lowerWindow = BNO055IMUImpl.newWindow(BNO055IMU.Register.CHIP_ID, BNO055IMU.Register.EUL_H_LSB);
    protected static final I2cDeviceSynch.ReadWindow upperWindow = BNO055IMUImpl.newWindow(BNO055IMU.Register.EUL_H_LSB, BNO055IMU.Register.TEMP);
    protected static final int msExtra = 50;
    public static final byte bCHIP_ID_VALUE = -96;

    public static boolean imuIsPresent(I2cDeviceSynchSimple deviceClient, boolean retryAfterWaiting) {
        return BNO055Util.imuIsPresent(deviceClient, retryAfterWaiting);
    }

    protected static I2cDeviceSynch.ReadWindow newWindow(BNO055IMU.Register regFirst, BNO055IMU.Register regMax) {
        return new I2cDeviceSynch.ReadWindow((int)regFirst.bVal, regMax.bVal - regFirst.bVal, readMode);
    }

    protected void throwIfNotInitialized() {
        if (((BNO055IMU.Parameters)this.parameters).mode == BNO055IMU.SensorMode.DISABLED) {
            throw new ImuNotInitializedException();
        }
    }

    public BNO055IMUImpl(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned, (Object)BNO055IMUImpl.disabledParameters());
        ((I2cDeviceSynch)this.deviceClient).setReadWindow(lowerWindow);
        ((I2cDeviceSynch)this.deviceClient).engage();
        this.accelerationAlgorithm = new NaiveAccelerationIntegrator();
        this.accelerationMananger = null;
        this.registerArmingStateCallback(false);
    }

    protected static BNO055IMU.Parameters disabledParameters() {
        BNO055IMU.Parameters result = new BNO055IMU.Parameters();
        result.mode = BNO055IMU.SensorMode.DISABLED;
        return result;
    }

    public void resetDeviceConfigurationForOpMode() {
        BNO055IMU.Parameters previousParameters = (BNO055IMU.Parameters)this.parameters;
        boolean previouslyInitialized = this.isInitialized;
        this.stopAccelerationIntegration();
        super.resetDeviceConfigurationForOpMode();
        this.parameters = previousParameters;
        this.isInitialized = previouslyInitialized;
    }

    public void onOpModePreInit(OpMode opMode) {
    }

    public void onOpModePreStart(OpMode opMode) {
    }

    public void onOpModePostStop(OpMode opMode) {
        this.stopAccelerationIntegration();
    }

    public I2cAddr getI2cAddress() {
        return ((BNO055IMU.Parameters)this.parameters).i2cAddr;
    }

    public void setI2cAddress(I2cAddr newAddress) {
        ((BNO055IMU.Parameters)this.parameters).i2cAddr = newAddress;
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(newAddress);
    }

    public boolean internalInitialize(@NonNull BNO055IMU.Parameters parameters) {
        BNO055IMU.SystemStatus expectedStatus;
        if (parameters.mode == BNO055IMU.SensorMode.DISABLED) {
            return true;
        }
        BNO055IMU.Parameters prevParameters = (BNO055IMU.Parameters)this.parameters;
        parameters = parameters.clone();
        this.parameters = parameters;
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(parameters.i2cAddr);
        BNO055IMU.SystemStatus systemStatus = expectedStatus = parameters.mode.isFusionMode() ? BNO055IMU.SystemStatus.RUNNING_FUSION : BNO055IMU.SystemStatus.RUNNING_NO_FUSION;
        if (this.internalInitializeOnce(expectedStatus)) {
            this.isInitialized = true;
            return true;
        }
        this.log_e("IMU initialization failed", new Object[0]);
        this.parameters = prevParameters;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalInitializeOnce(BNO055IMU.SystemStatus expectedStatus) {
        if (BNO055IMU.SensorMode.CONFIG == ((BNO055IMU.Parameters)this.parameters).mode) {
            throw new IllegalArgumentException("SensorMode.CONFIG illegal for use as initialization mode");
        }
        ElapsedTime elapsed = new ElapsedTime();
        if (((BNO055IMU.Parameters)this.parameters).accelerationIntegrationAlgorithm != null) {
            this.accelerationAlgorithm = ((BNO055IMU.Parameters)this.parameters).accelerationIntegrationAlgorithm;
        }
        if (!BNO055IMUImpl.imuIsPresent(this.deviceClient, true)) {
            this.log_e("IMU appears to not be present", new Object[0]);
            return false;
        }
        this.setSensorMode(BNO055IMU.SensorMode.CONFIG);
        I2cWarningManager.suppressNewProblemDeviceWarnings((boolean)true);
        try {
            byte chipId;
            elapsed.reset();
            this.write8(BNO055IMU.Register.SYS_TRIGGER, 32, I2cWaitControl.WRITTEN);
            this.delay(400);
            RobotLog.vv((String)this.getLoggingTag(), (String)"Now polling until IMU comes out of reset. It is normal to see I2C failures below");
            while (!this.isStopRequested() && (chipId = this.read8(BNO055IMU.Register.CHIP_ID)) != -96) {
                this.delayExtra(10);
                if (!(elapsed.milliseconds() > 2000.0)) continue;
                this.log_e("failed to retrieve chip id", new Object[0]);
                boolean bl = false;
                return bl;
            }
            this.delayLoreExtra(50);
        }
        finally {
            I2cWarningManager.suppressNewProblemDeviceWarnings((boolean)false);
        }
        RobotLog.vv((String)this.getLoggingTag(), (String)"IMU has come out of reset. No more I2C failures should occur.");
        try {
            BNO055Util.sharedInit(this.deviceClient, (BNO055IMU.Parameters)this.parameters);
        }
        catch (BNO055Util.InitException e) {
            RobotLog.ee((String)this.getLoggingTag(), (Throwable)e, (String)"Failed to initialize BNO055 IMU");
            return false;
        }
        BNO055IMU.SystemStatus status = this.getSystemStatus();
        if (status == expectedStatus) {
            return true;
        }
        this.log_w("IMU initialization failed: system status=%s expected=%s", new Object[]{status, expectedStatus});
        return false;
    }

    protected void setSensorMode(BNO055IMU.SensorMode mode) {
        BNO055Util.setSensorMode(this.deviceClient, mode);
    }

    @Override
    public synchronized BNO055IMU.SystemStatus getSystemStatus() {
        return BNO055Util.getSystemStatus(this.deviceClient, this.getLoggingTag());
    }

    @Override
    public synchronized BNO055IMU.SystemError getSystemError() {
        byte bVal = this.read8(BNO055IMU.Register.SYS_ERR);
        BNO055IMU.SystemError error = BNO055IMU.SystemError.from(bVal);
        if (error == BNO055IMU.SystemError.UNKNOWN) {
            this.log_w("unknown system error observed: 0x%08x", bVal);
        }
        return error;
    }

    @Override
    public synchronized BNO055IMU.CalibrationStatus getCalibrationStatus() {
        byte bVal = this.read8(BNO055IMU.Register.CALIB_STAT);
        return new BNO055IMU.CalibrationStatus(bVal);
    }

    @Override
    public void close() {
        this.stopAccelerationIntegration();
        super.close();
    }

    public abstract String getDeviceName();

    public abstract HardwareDevice.Manufacturer getManufacturer();

    public Set<Axis> getAngularVelocityAxes() {
        HashSet<Axis> result = new HashSet<Axis>();
        result.add(Axis.X);
        result.add(Axis.Y);
        result.add(Axis.Z);
        return result;
    }

    public Set<Axis> getAngularOrientationAxes() {
        HashSet<Axis> result = new HashSet<Axis>();
        result.add(Axis.X);
        result.add(Axis.Y);
        result.add(Axis.Z);
        return result;
    }

    public synchronized AngularVelocity getAngularVelocity(AngleUnit unit) {
        this.throwIfNotInitialized();
        this.ensureReadWindow(new I2cDeviceSynch.ReadWindow((int)VECTOR.GYROSCOPE.getValue(), 6, readMode));
        AngularVelocity rawAngularVelocity = BNO055Util.getRawAngularVelocity(this.deviceClient, ((BNO055IMU.Parameters)this.parameters).angleUnit, unit);
        return new AngularVelocity(unit, -rawAngularVelocity.xRotationRate, -rawAngularVelocity.yRotationRate, rawAngularVelocity.zRotationRate, rawAngularVelocity.acquisitionTime);
    }

    @Override
    public Orientation getAngularOrientation(AxesReference reference, AxesOrder order, AngleUnit angleUnit) {
        return this.getAngularOrientation().toAxesReference(reference).toAxesOrder(order).toAngleUnit(angleUnit);
    }

    @Override
    public synchronized boolean isSystemCalibrated() {
        byte b = this.read8(BNO055IMU.Register.CALIB_STAT);
        return (b >> 6 & 3) == 3;
    }

    @Override
    public synchronized boolean isGyroCalibrated() {
        byte b = this.read8(BNO055IMU.Register.CALIB_STAT);
        return (b >> 4 & 3) == 3;
    }

    @Override
    public synchronized boolean isAccelerometerCalibrated() {
        byte b = this.read8(BNO055IMU.Register.CALIB_STAT);
        return (b >> 2 & 3) == 3;
    }

    @Override
    public synchronized boolean isMagnetometerCalibrated() {
        byte b = this.read8(BNO055IMU.Register.CALIB_STAT);
        return (b & 3) == 3;
    }

    @Override
    public BNO055IMU.CalibrationData readCalibrationData() {
        BNO055IMU.SensorMode prevMode = BNO055Util.getSensorMode(this.deviceClient);
        if (prevMode != BNO055IMU.SensorMode.CONFIG) {
            this.setSensorMode(BNO055IMU.SensorMode.CONFIG);
        }
        BNO055IMU.CalibrationData result = new BNO055IMU.CalibrationData();
        result.dxAccel = this.readShort(BNO055IMU.Register.ACC_OFFSET_X_LSB);
        result.dyAccel = this.readShort(BNO055IMU.Register.ACC_OFFSET_Y_LSB);
        result.dzAccel = this.readShort(BNO055IMU.Register.ACC_OFFSET_Z_LSB);
        result.dxMag = this.readShort(BNO055IMU.Register.MAG_OFFSET_X_LSB);
        result.dyMag = this.readShort(BNO055IMU.Register.MAG_OFFSET_Y_LSB);
        result.dzMag = this.readShort(BNO055IMU.Register.MAG_OFFSET_Z_LSB);
        result.dxGyro = this.readShort(BNO055IMU.Register.GYR_OFFSET_X_LSB);
        result.dyGyro = this.readShort(BNO055IMU.Register.GYR_OFFSET_Y_LSB);
        result.dzGyro = this.readShort(BNO055IMU.Register.GYR_OFFSET_Z_LSB);
        result.radiusAccel = this.readShort(BNO055IMU.Register.ACC_RADIUS_LSB);
        result.radiusMag = this.readShort(BNO055IMU.Register.MAG_RADIUS_LSB);
        if (prevMode != BNO055IMU.SensorMode.CONFIG) {
            this.setSensorMode(prevMode);
        }
        return result;
    }

    @Override
    public void writeCalibrationData(BNO055IMU.CalibrationData data) {
        BNO055Util.writeCalibrationData(this.deviceClient, data);
    }

    @Override
    public synchronized Temperature getTemperature() {
        this.throwIfNotInitialized();
        byte b = this.read8(BNO055IMU.Register.TEMP);
        return new Temperature(((BNO055IMU.Parameters)this.parameters).temperatureUnit.toTempUnit(), (double)b, System.nanoTime());
    }

    @Override
    public synchronized MagneticFlux getMagneticFieldStrength() {
        this.throwIfNotInitialized();
        VectorData vector = this.getVector(VECTOR.MAGNETOMETER, this.getFluxScale());
        return new MagneticFlux((double)vector.next(), (double)vector.next(), (double)vector.next(), vector.data.nanoTime);
    }

    @Override
    public synchronized Acceleration getOverallAcceleration() {
        this.throwIfNotInitialized();
        VectorData vector = this.getVector(VECTOR.ACCELEROMETER, this.getMetersAccelerationScale());
        return new Acceleration(DistanceUnit.METER, (double)vector.next(), (double)vector.next(), (double)vector.next(), vector.data.nanoTime);
    }

    @Override
    public synchronized Acceleration getLinearAcceleration() {
        this.throwIfNotInitialized();
        VectorData vector = this.getVector(VECTOR.LINEARACCEL, this.getMetersAccelerationScale());
        return new Acceleration(DistanceUnit.METER, (double)vector.next(), (double)vector.next(), (double)vector.next(), vector.data.nanoTime);
    }

    @Override
    public synchronized Acceleration getGravity() {
        this.throwIfNotInitialized();
        VectorData vector = this.getVector(VECTOR.GRAVITY, this.getMetersAccelerationScale());
        return new Acceleration(DistanceUnit.METER, (double)vector.next(), (double)vector.next(), (double)vector.next(), vector.data.nanoTime);
    }

    @Override
    public synchronized AngularVelocity getAngularVelocity() {
        this.throwIfNotInitialized();
        return this.getAngularVelocity(((BNO055IMU.Parameters)this.parameters).angleUnit.toAngleUnit());
    }

    @Override
    public synchronized Orientation getAngularOrientation() {
        this.throwIfNotInitialized();
        VectorData vector = this.getVector(VECTOR.EULER, this.getAngularScale());
        AngleUnit angleUnit = ((BNO055IMU.Parameters)this.parameters).angleUnit.toAngleUnit();
        return new Orientation(AxesReference.INTRINSIC, AxesOrder.ZYX, angleUnit, angleUnit.normalize(-vector.next()), angleUnit.normalize(vector.next()), angleUnit.normalize(vector.next()), vector.data.nanoTime);
    }

    @Override
    public synchronized Quaternion getQuaternionOrientation() {
        this.throwIfNotInitialized();
        ((I2cDeviceSynch)this.deviceClient).ensureReadWindow(new I2cDeviceSynch.ReadWindow((int)BNO055IMU.Register.QUA_DATA_W_LSB.bVal, 8, readMode), upperWindow);
        try {
            return BNO055Util.getRawQuaternion(this.deviceClient);
        }
        catch (QuaternionBasedImuHelper.FailedToRetrieveQuaternionException e) {
            if (((BNO055IMU.Parameters)this.parameters).loggingEnabled) {
                RobotLog.ww((String)this.getLoggingTag(), (String)"Failed to retrieve valid quaternion. Returning identity quaternion.");
            }
            return Quaternion.identityQuaternion();
        }
    }

    protected float getAngularScale() {
        return BNO055Util.getAngularScale(((BNO055IMU.Parameters)this.parameters).angleUnit);
    }

    protected float getAccelerationScale() {
        return ((BNO055IMU.Parameters)this.parameters).accelUnit == BNO055IMU.AccelUnit.METERS_PERSEC_PERSEC ? 100.0f : 1.0f;
    }

    protected float getMetersAccelerationScale() {
        float scaleConversionFactor = 100.0f;
        return ((BNO055IMU.Parameters)this.parameters).accelUnit == BNO055IMU.AccelUnit.METERS_PERSEC_PERSEC ? this.getAccelerationScale() : this.getAccelerationScale() * scaleConversionFactor;
    }

    protected float getFluxScale() {
        return 1.6E7f;
    }

    protected VectorData getVector(VECTOR vector, float scale) {
        this.ensureReadWindow(new I2cDeviceSynch.ReadWindow((int)vector.getValue(), 6, readMode));
        return new VectorData(((I2cDeviceSynch)this.deviceClient).readTimeStamped((int)vector.getValue(), 6), scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Acceleration getAcceleration() {
        Object object = this.dataLock;
        synchronized (object) {
            Acceleration result = this.accelerationAlgorithm.getAcceleration();
            if (result == null) {
                result = new Acceleration();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Velocity getVelocity() {
        Object object = this.dataLock;
        synchronized (object) {
            Velocity result = this.accelerationAlgorithm.getVelocity();
            if (result == null) {
                result = new Velocity();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Position getPosition() {
        Object object = this.dataLock;
        synchronized (object) {
            Position result = this.accelerationAlgorithm.getPosition();
            if (result == null) {
                result = new Position();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAccelerationIntegration(Position initalPosition, Velocity initialVelocity, int msPollInterval) {
        this.throwIfNotInitialized();
        Object object = this.startStopLock;
        synchronized (object) {
            this.stopAccelerationIntegration();
            this.accelerationAlgorithm.initialize((BNO055IMU.Parameters)this.parameters, initalPosition, initialVelocity);
            this.accelerationMananger = ThreadPool.newSingleThreadExecutor((String)"imu acceleration");
            this.accelerationMananger.execute(new AccelerationManager(msPollInterval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAccelerationIntegration() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.accelerationMananger != null) {
                this.accelerationMananger.shutdownNow();
                ThreadPool.awaitTerminationOrExitApplication((ExecutorService)this.accelerationMananger, (long)10L, (TimeUnit)TimeUnit.SECONDS, (String)"IMU acceleration", (String)"unresponsive user acceleration code");
                this.accelerationMananger = null;
            }
        }
    }

    boolean isStopRequested() {
        return Thread.currentThread().isInterrupted();
    }

    @Override
    public synchronized byte read8(BNO055IMU.Register reg) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)reg.bVal);
    }

    @Override
    public synchronized byte[] read(BNO055IMU.Register reg, int cb) {
        return ((I2cDeviceSynch)this.deviceClient).read((int)reg.bVal, cb);
    }

    protected short readShort(BNO055IMU.Register reg) {
        byte[] data = this.read(reg, 2);
        return TypeConversion.byteArrayToShort((byte[])data, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write8(BNO055IMU.Register reg, int data) {
        this.write8(reg, data, I2cWaitControl.ATOMIC);
    }

    public void write8(BNO055IMU.Register reg, int data, I2cWaitControl waitControl) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)reg.bVal, data, waitControl);
    }

    @Override
    public void write(BNO055IMU.Register reg, byte[] data) {
        this.write(reg, data, I2cWaitControl.ATOMIC);
    }

    public void write(BNO055IMU.Register reg, byte[] data, I2cWaitControl waitControl) {
        ((I2cDeviceSynch)this.deviceClient).write((int)reg.bVal, data, waitControl);
    }

    protected void writeShort(BNO055IMU.Register reg, short value) {
        byte[] data = TypeConversion.shortToByteArray((short)value, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.write(reg, data);
    }

    protected void waitForWriteCompletions() {
        ((I2cDeviceSynch)this.deviceClient).waitForWriteCompletions(I2cWaitControl.ATOMIC);
    }

    protected String getLoggingTag() {
        return ((BNO055IMU.Parameters)this.parameters).loggingTag;
    }

    protected void log_v(String format, Object ... args) {
        if (((BNO055IMU.Parameters)this.parameters).loggingEnabled) {
            String message = String.format(format, args);
            Log.v((String)this.getLoggingTag(), (String)message);
        }
    }

    protected void log_d(String format, Object ... args) {
        if (((BNO055IMU.Parameters)this.parameters).loggingEnabled) {
            String message = String.format(format, args);
            Log.d((String)this.getLoggingTag(), (String)message);
        }
    }

    protected void log_w(String format, Object ... args) {
        if (((BNO055IMU.Parameters)this.parameters).loggingEnabled) {
            String message = String.format(format, args);
            Log.w((String)this.getLoggingTag(), (String)message);
        }
    }

    protected void log_e(String format, Object ... args) {
        if (((BNO055IMU.Parameters)this.parameters).loggingEnabled) {
            String message = String.format(format, args);
            Log.e((String)this.getLoggingTag(), (String)message);
        }
    }

    protected void ensureReadWindow(I2cDeviceSynch.ReadWindow needed) {
        I2cDeviceSynch.ReadWindow windowToSet = lowerWindow.containsWithSameMode(needed) ? lowerWindow : (upperWindow.containsWithSameMode(needed) ? upperWindow : needed);
        ((I2cDeviceSynch)this.deviceClient).ensureReadWindow(needed, windowToSet);
    }

    protected void delayExtra(int ms) {
        this.delay(ms + 50);
    }

    protected void delayLoreExtra(int ms) {
        this.delayLore(ms + 50);
    }

    protected void delayLore(int ms) {
        this.delay(ms);
    }

    protected void delay(int ms) {
        try {
            this.waitForWriteCompletions();
            Thread.sleep((int)((float)ms * this.delayScale));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void enterConfigModeFor(Runnable action) {
        BNO055IMU.SensorMode modePrev = BNO055Util.getSensorMode(this.deviceClient);
        this.setSensorMode(BNO055IMU.SensorMode.CONFIG);
        this.delayLoreExtra(25);
        try {
            action.run();
        }
        finally {
            this.setSensorMode(modePrev);
            this.delayLoreExtra(20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T enterConfigModeFor(Func<T> lambda) {
        Object result;
        BNO055IMU.SensorMode modePrev = BNO055Util.getSensorMode(this.deviceClient);
        this.setSensorMode(BNO055IMU.SensorMode.CONFIG);
        this.delayLoreExtra(25);
        try {
            result = lambda.value();
        }
        finally {
            this.setSensorMode(modePrev);
            this.delayLoreExtra(20);
        }
        return (T)result;
    }

    public static class ImuNotInitializedException
    extends RuntimeException {
        public ImuNotInitializedException() {
            super("The IMU was not initialized");
        }
    }

    static enum VECTOR {
        ACCELEROMETER(BNO055IMU.Register.ACC_DATA_X_LSB),
        MAGNETOMETER(BNO055IMU.Register.MAG_DATA_X_LSB),
        GYROSCOPE(BNO055IMU.Register.GYR_DATA_X_LSB),
        EULER(BNO055IMU.Register.EUL_H_LSB),
        LINEARACCEL(BNO055IMU.Register.LIA_DATA_X_LSB),
        GRAVITY(BNO055IMU.Register.GRV_DATA_X_LSB);

        protected byte value;

        private VECTOR(int value) {
            this.value = (byte)value;
        }

        private VECTOR(BNO055IMU.Register register) {
            this(register.bVal);
        }

        public byte getValue() {
            return this.value;
        }
    }

    protected static class VectorData {
        public TimestampedData data;
        public float scale;
        protected ByteBuffer buffer;

        public VectorData(TimestampedData data, float scale) {
            this.data = data;
            this.scale = scale;
            this.buffer = ByteBuffer.wrap(data.data).order(ByteOrder.LITTLE_ENDIAN);
        }

        public float next() {
            return (float)this.buffer.getShort() / this.scale;
        }
    }

    class AccelerationManager
    implements Runnable {
        protected final int msPollInterval;
        protected static final long nsPerMs = 1000000L;

        AccelerationManager(int msPollInterval) {
            this.msPollInterval = msPollInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!BNO055IMUImpl.this.isStopRequested()) {
                    Acceleration linearAcceleration = BNO055IMUImpl.this.getLinearAcceleration();
                    Object object = BNO055IMUImpl.this.dataLock;
                    synchronized (object) {
                        BNO055IMUImpl.this.accelerationAlgorithm.update(linearAcceleration);
                    }
                    if (this.msPollInterval > 0) {
                        long msSoFar = (System.nanoTime() - linearAcceleration.acquisitionTime) / 1000000L;
                        long msReadFudge = 5L;
                        Thread.sleep(Math.max(0L, (long)this.msPollInterval - msSoFar - msReadFudge));
                        continue;
                    }
                    Thread.yield();
                }
            }
            catch (InterruptedException | CancellationException e) {
                return;
            }
        }
    }

    static enum POWER_MODE {
        NORMAL(0),
        LOWPOWER(1),
        SUSPEND(2);

        protected byte value;

        private POWER_MODE(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

