/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.hardware.bosch.BNO055Util;
import com.qualcomm.hardware.rev.RevHubOrientationOnRobot;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDeviceWithParameters;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.IMU;
import com.qualcomm.robotcore.hardware.ImuOrientationOnRobot;
import com.qualcomm.robotcore.hardware.QuaternionBasedImuHelper;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.YawPitchRollAngles;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public abstract class BNO055IMUNew
extends I2cDeviceSynchDeviceWithParameters<I2cDeviceSynchSimple, IMU.Parameters>
implements IMU {
    private static final String TAG = "BNO055IMU (new)";
    private static final BNO055IMU.AngleUnit INTERNAL_ANGLE_UNIT = BNO055IMU.AngleUnit.DEGREES;
    private final QuaternionBasedImuHelper helper;
    @Nullable
    private final I2cAddr guaranteedAddress;

    public BNO055IMUNew(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        this(deviceClient, deviceClientIsOwned, null);
    }

    public BNO055IMUNew(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned, @Nullable I2cAddr guaranteedAddress) {
        super(deviceClient, deviceClientIsOwned, (Object)new Parameters(new RevHubOrientationOnRobot(RevHubOrientationOnRobot.LogoFacingDirection.UP, RevHubOrientationOnRobot.UsbFacingDirection.FORWARD)));
        this.helper = new QuaternionBasedImuHelper(((IMU.Parameters)this.parameters).imuOrientationOnRobot);
        this.guaranteedAddress = guaranteedAddress;
        I2cAddr assumedAddress = guaranteedAddress;
        if (assumedAddress == null) {
            assumedAddress = BNO055IMU.I2CADDR_DEFAULT;
        }
        deviceClient.setI2cAddress(assumedAddress);
        if (BNO055Util.imuIsPresent(deviceClient, false) && this.initialize((IMU.Parameters)this.parameters)) {
            this.helper.resetYaw(TAG, () -> BNO055Util.getRawQuaternion(deviceClient), 500);
        }
    }

    protected boolean internalInitialize(@NonNull IMU.Parameters genericParameters) {
        Parameters parameters;
        if ((genericParameters = genericParameters.copy()) instanceof Parameters) {
            parameters = (Parameters)genericParameters;
        } else {
            if (!genericParameters.getClass().equals(IMU.Parameters.class)) {
                RobotLog.addGlobalWarningMessage((String)AppUtil.getDefContext().getString(R.string.parametersForOtherDeviceUsed));
            }
            parameters = new Parameters(genericParameters);
        }
        this.parameters = parameters;
        this.helper.setImuOrientationOnRobot(parameters.imuOrientationOnRobot);
        if (this.guaranteedAddress == null) {
            this.deviceClient.setI2cAddress(parameters.i2cAddr);
        } else {
            this.deviceClient.setI2cAddress(this.guaranteedAddress);
        }
        try {
            if (!BNO055Util.imuIsPresent(this.deviceClient, true)) {
                throw new BNO055Util.InitException("IMU appears to not be present");
            }
            BNO055Util.setSensorMode(this.deviceClient, BNO055IMU.SensorMode.CONFIG);
            BNO055Util.sharedInit(this.deviceClient, parameters.toOldParameters());
        }
        catch (BNO055Util.InitException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to initialize BNO055 IMU");
            return false;
        }
        BNO055IMU.SystemStatus status = BNO055Util.getSystemStatus(this.deviceClient, TAG);
        return status == BNO055IMU.SystemStatus.RUNNING_FUSION;
    }

    public void resetYaw() {
        this.helper.resetYaw(TAG, () -> BNO055Util.getRawQuaternion(this.deviceClient), 100);
    }

    public YawPitchRollAngles getRobotYawPitchRollAngles() {
        return this.helper.getRobotYawPitchRollAngles(TAG, () -> BNO055Util.getRawQuaternion(this.deviceClient));
    }

    public Orientation getRobotOrientation(AxesReference reference, AxesOrder order, AngleUnit angleUnit) {
        return this.helper.getRobotOrientation(TAG, () -> BNO055Util.getRawQuaternion(this.deviceClient), reference, order, angleUnit);
    }

    public Quaternion getRobotOrientationAsQuaternion() {
        return this.helper.getRobotOrientationAsQuaternion(TAG, () -> BNO055Util.getRawQuaternion(this.deviceClient), true);
    }

    public AngularVelocity getRobotAngularVelocity(AngleUnit angleUnit) {
        return this.helper.getRobotAngularVelocity(BNO055Util.getRawAngularVelocity(this.deviceClient, INTERNAL_ANGLE_UNIT, INTERNAL_ANGLE_UNIT.toAngleUnit()), angleUnit);
    }

    public abstract String getDeviceName();

    public abstract HardwareDevice.Manufacturer getManufacturer();

    public static class Parameters
    extends IMU.Parameters {
        public I2cAddr i2cAddr = BNO055IMU.I2CADDR_DEFAULT;
        public BNO055IMU.CalibrationData calibrationData = null;
        public String calibrationDataFile = null;

        public Parameters(ImuOrientationOnRobot imuOrientationOnRobot) {
            super(imuOrientationOnRobot);
        }

        private Parameters(IMU.Parameters genericParameters) {
            super(genericParameters.imuOrientationOnRobot);
        }

        public Parameters copy() {
            Parameters copy = new Parameters(this.imuOrientationOnRobot);
            copy.i2cAddr = this.i2cAddr;
            copy.calibrationData = this.calibrationData;
            copy.calibrationDataFile = this.calibrationDataFile;
            return copy;
        }

        private BNO055IMU.Parameters toOldParameters() {
            BNO055IMU.Parameters result = new BNO055IMU.Parameters();
            result.angleUnit = INTERNAL_ANGLE_UNIT;
            result.calibrationData = this.calibrationData;
            result.calibrationDataFile = this.calibrationDataFile;
            return result;
        }
    }
}

