/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.hardware.bosch.BNO055IMUImpl;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.I2cWarningManager;
import com.qualcomm.robotcore.hardware.QuaternionBasedImuHelper;
import com.qualcomm.robotcore.hardware.TimestampedData;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.TypeConversion;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class BNO055Util {
    public static void sharedInit(I2cDeviceSynchSimple deviceClient, BNO055IMU.Parameters parameters) throws InitException {
        BNO055Util.write8(deviceClient, BNO055IMU.Register.PWR_MODE, BNO055IMUImpl.POWER_MODE.NORMAL.getValue(), I2cWaitControl.WRITTEN);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.PAGE_ID, 0);
        int unitsel = parameters.pitchMode.bVal << 7 | parameters.temperatureUnit.bVal << 4 | parameters.angleUnit.bVal << 2 | parameters.angleUnit.bVal << 1 | parameters.accelUnit.bVal;
        BNO055Util.write8(deviceClient, BNO055IMU.Register.UNIT_SEL, unitsel);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.AXIS_MAP_CONFIG, 36);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.AXIS_MAP_SIGN, 0);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.PAGE_ID, 1);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.ACC_CONFIG, parameters.accelPowerMode.bVal | parameters.accelBandwidth.bVal | parameters.accelRange.bVal);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.MAG_CONFIG, parameters.magPowerMode.bVal | parameters.magOpMode.bVal | parameters.magRate.bVal);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.GYR_CONFIG_0, parameters.gyroBandwidth.bVal | parameters.gyroRange.bVal);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.GYR_CONFIG_1, parameters.gyroPowerMode.bVal);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.PAGE_ID, 0);
        BNO055Util.write8(deviceClient, BNO055IMU.Register.SYS_TRIGGER, 0);
        if (parameters.calibrationData != null) {
            BNO055Util.writeCalibrationData(deviceClient, parameters.calibrationData);
        } else if (parameters.calibrationDataFile != null) {
            try {
                File file = AppUtil.getInstance().getSettingsFile(parameters.calibrationDataFile);
                String serialized = ReadWriteFile.readFileOrThrow((File)file);
                BNO055IMU.CalibrationData data = BNO055IMU.CalibrationData.deserialize(serialized);
                BNO055Util.writeCalibrationData(deviceClient, data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        BNO055Util.setSensorMode(deviceClient, parameters.mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean imuIsPresent(I2cDeviceSynchSimple deviceClient, boolean retryAfterWaiting) {
        String TAG = "BNO055";
        RobotLog.vv((String)"BNO055", (String)"Suppressing I2C warnings while we check for a BNO055 IMU");
        I2cWarningManager.suppressNewProblemDeviceWarnings((boolean)true);
        try {
            byte chipId = BNO055Util.read8(deviceClient, BNO055IMU.Register.CHIP_ID);
            if (chipId != -96 && retryAfterWaiting) {
                try {
                    Thread.sleep(650L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                chipId = BNO055Util.read8(deviceClient, BNO055IMU.Register.CHIP_ID);
            }
            if (chipId == -96) {
                RobotLog.vv((String)"BNO055", (String)"Found BNO055 IMU");
                boolean bl = true;
                return bl;
            }
            RobotLog.vv((String)"BNO055", (String)"No BNO055 IMU found");
            boolean bl = false;
            return bl;
        }
        finally {
            I2cWarningManager.suppressNewProblemDeviceWarnings((boolean)false);
        }
    }

    public static BNO055IMU.SystemStatus getSystemStatus(I2cDeviceSynchSimple deviceClient, String tag) {
        byte bVal = BNO055Util.read8(deviceClient, BNO055IMU.Register.SYS_STAT);
        BNO055IMU.SystemStatus status = BNO055IMU.SystemStatus.from(bVal);
        if (status == BNO055IMU.SystemStatus.UNKNOWN) {
            RobotLog.ww((String)tag, (String)"unknown system status observed: 0x%08x", (Object[])new Object[]{bVal});
        }
        return status;
    }

    public static void writeCalibrationData(I2cDeviceSynchSimple deviceClient, BNO055IMU.CalibrationData data) {
        BNO055IMU.SensorMode prevMode = BNO055Util.getSensorMode(deviceClient);
        if (prevMode != BNO055IMU.SensorMode.CONFIG) {
            BNO055Util.setSensorMode(deviceClient, BNO055IMU.SensorMode.CONFIG);
        }
        BNO055Util.write8(deviceClient, BNO055IMU.Register.PAGE_ID, 0);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.ACC_OFFSET_X_LSB, data.dxAccel);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.ACC_OFFSET_Y_LSB, data.dyAccel);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.ACC_OFFSET_Z_LSB, data.dzAccel);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.MAG_OFFSET_X_LSB, data.dxMag);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.MAG_OFFSET_Y_LSB, data.dyMag);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.MAG_OFFSET_Z_LSB, data.dzMag);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.GYR_OFFSET_X_LSB, data.dxGyro);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.GYR_OFFSET_Y_LSB, data.dyGyro);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.GYR_OFFSET_Z_LSB, data.dzGyro);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.ACC_RADIUS_LSB, data.radiusAccel);
        BNO055Util.writeShort(deviceClient, BNO055IMU.Register.MAG_RADIUS_LSB, data.radiusMag);
        if (prevMode != BNO055IMU.SensorMode.CONFIG) {
            BNO055Util.setSensorMode(deviceClient, prevMode);
        }
    }

    public static void setSensorMode(I2cDeviceSynchSimple deviceClient, BNO055IMU.SensorMode mode) {
        if (BNO055Util.getSensorMode(deviceClient) == mode) {
            return;
        }
        BNO055Util.write8(deviceClient, BNO055IMU.Register.OPR_MODE, mode.bVal & 0xF, I2cWaitControl.WRITTEN);
        try {
            if (mode == BNO055IMU.SensorMode.CONFIG) {
                Thread.sleep(25L);
            } else {
                Thread.sleep(15L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static BNO055IMU.SensorMode getSensorMode(I2cDeviceSynchSimple deviceClient) {
        return BNO055IMU.SensorMode.fromByte(BNO055Util.read8(deviceClient, BNO055IMU.Register.OPR_MODE));
    }

    public static Quaternion getRawQuaternion(I2cDeviceSynchSimple deviceClient) throws QuaternionBasedImuHelper.FailedToRetrieveQuaternionException {
        TimestampedData ts = deviceClient.readTimeStamped((int)BNO055IMU.Register.QUA_DATA_W_LSB.bVal, 8);
        boolean receivedAllZeros = true;
        for (byte b : ts.data) {
            if (b == 0) continue;
            receivedAllZeros = false;
            break;
        }
        if (receivedAllZeros) {
            throw new QuaternionBasedImuHelper.FailedToRetrieveQuaternionException();
        }
        BNO055IMUImpl.VectorData vector = new BNO055IMUImpl.VectorData(ts, 16384.0f);
        return new Quaternion(vector.next(), vector.next(), vector.next(), vector.next(), vector.data.nanoTime);
    }

    public static AngularVelocity getRawAngularVelocity(I2cDeviceSynchSimple deviceClient, BNO055IMU.AngleUnit angleUnitConfiguredOnImu, AngleUnit desiredAngleUnit) {
        BNO055IMUImpl.VectorData vector = new BNO055IMUImpl.VectorData(deviceClient.readTimeStamped((int)BNO055IMUImpl.VECTOR.GYROSCOPE.getValue(), 6), BNO055Util.getAngularScale(angleUnitConfiguredOnImu));
        float xRotationRate = vector.next();
        float yRotationRate = vector.next();
        float zRotationRate = vector.next();
        return new AngularVelocity(angleUnitConfiguredOnImu.toAngleUnit(), xRotationRate, yRotationRate, zRotationRate, vector.data.nanoTime).toAngleUnit(desiredAngleUnit);
    }

    public static float getAngularScale(BNO055IMU.AngleUnit angleUnit) {
        return angleUnit == BNO055IMU.AngleUnit.DEGREES ? 16.0f : 900.0f;
    }

    public static byte read8(I2cDeviceSynchSimple deviceClient, BNO055IMU.Register reg) {
        return deviceClient.read8((int)reg.bVal);
    }

    public static byte[] read(I2cDeviceSynchSimple deviceClient, BNO055IMU.Register reg, int cb) {
        return deviceClient.read((int)reg.bVal, cb);
    }

    public static void write8(I2cDeviceSynchSimple deviceClient, BNO055IMU.Register reg, int data) {
        BNO055Util.write8(deviceClient, reg, data, I2cWaitControl.ATOMIC);
    }

    public static void write8(I2cDeviceSynchSimple deviceClient, BNO055IMU.Register reg, int data, I2cWaitControl waitControl) {
        deviceClient.write8((int)reg.bVal, data, waitControl);
    }

    public static void write(I2cDeviceSynchSimple deviceClient, BNO055IMU.Register reg, byte[] data) {
        deviceClient.write((int)reg.bVal, data);
    }

    public static void writeShort(I2cDeviceSynchSimple deviceClient, BNO055IMU.Register reg, short value) {
        byte[] data = TypeConversion.shortToByteArray((short)value, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        BNO055Util.write(deviceClient, reg, data);
    }

    public static class InitException
    extends Exception {
        public InitException(String message) {
            super(message);
        }
    }
}

