/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Velocity;

public class JustLoggingAccelerationIntegrator
implements BNO055IMU.AccelerationIntegrator {
    BNO055IMU.Parameters parameters;
    Acceleration acceleration;

    @Override
    public void initialize(BNO055IMU.Parameters parameters, Position initialPosition, Velocity initialVelocity) {
        this.parameters = parameters;
    }

    @Override
    public Position getPosition() {
        return new Position();
    }

    @Override
    public Velocity getVelocity() {
        return new Velocity();
    }

    @Override
    public Acceleration getAcceleration() {
        return this.acceleration == null ? new Acceleration() : this.acceleration;
    }

    @Override
    public void update(Acceleration linearAcceleration) {
        if (linearAcceleration.acquisitionTime != 0L) {
            if (this.acceleration != null) {
                Acceleration accelPrev = this.acceleration;
                this.acceleration = linearAcceleration;
                if (this.parameters.loggingEnabled) {
                    RobotLog.vv((String)this.parameters.loggingTag, (String)"dt=%.3fs accel=%s", (Object[])new Object[]{(double)(this.acceleration.acquisitionTime - accelPrev.acquisitionTime) * 1.0E-9, this.acceleration});
                }
            } else {
                this.acceleration = linearAcceleration;
            }
        }
    }
}

