/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.broadcom;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.broadcom.BroadcomColorSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDeviceWithParameters;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.Light;
import com.qualcomm.robotcore.hardware.NormalizedRGBA;
import com.qualcomm.robotcore.util.Range;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteOrder;

public abstract class BroadcomColorSensorImpl
extends I2cDeviceSynchDeviceWithParameters<I2cDeviceSynchSimple, BroadcomColorSensor.Parameters>
implements BroadcomColorSensor,
I2cAddrConfig,
Light {
    public static final String TAG = "BroadcomColorSensorImpl";
    NormalizedRGBA colors = new NormalizedRGBA();
    int red = 0;
    int green = 0;
    int blue = 0;
    int alpha = 0;
    float softwareGain = 1.0f;

    protected BroadcomColorSensorImpl(BroadcomColorSensor.Parameters params, I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(deviceClient, deviceClientIsOwned, (Object)params);
        this.deviceClient.setLogging(((BroadcomColorSensor.Parameters)this.parameters).loggingEnabled);
        this.deviceClient.setLoggingTag(((BroadcomColorSensor.Parameters)this.parameters).loggingTag);
        this.registerArmingStateCallback(true);
        this.engage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean internalInitialize(@NonNull BroadcomColorSensor.Parameters parameters) {
        RobotLog.vv((String)TAG, (String)"internalInitialize()...");
        try {
            if (((BroadcomColorSensor.Parameters)this.parameters).deviceId != parameters.deviceId) {
                throw new IllegalArgumentException(String.format("can't change device types (modify existing params instead): old=%d new=%d", ((BroadcomColorSensor.Parameters)this.parameters).deviceId, parameters.deviceId));
            }
            this.parameters = parameters.clone();
            this.setI2cAddress(parameters.i2cAddr);
            if (!this.deviceClient.isArmed()) {
                boolean bl = false;
                return bl;
            }
            byte id = this.getDeviceID();
            if (id != parameters.deviceId) {
                RobotLog.ee((String)TAG, (String)"unexpected Broadcom color sensor chipid: found=%d expected=%d", (Object[])new Object[]{id, parameters.deviceId});
                boolean bl = false;
                return bl;
            }
            this.dumpState();
            this.setHardwareGain(parameters.gain);
            this.setLEDParameters(parameters.pulseModulation, parameters.ledCurrent);
            this.setProximityPulseCount(parameters.proximityPulseCount);
            this.setPSRateAndRes(BroadcomColorSensor.Parameters.proximityResolution, parameters.proximityMeasRate);
            this.setLSRateAndRes(BroadcomColorSensor.Parameters.lightSensorResolution, parameters.lightSensorMeasRate);
            this.enable();
            this.dumpState();
            if (this.deviceClient instanceof I2cDeviceSynch && parameters.readWindow != null) {
                I2cDeviceSynch synch = (I2cDeviceSynch)this.deviceClient;
                synch.setReadWindow(parameters.readWindow);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            RobotLog.vv((String)TAG, (String)"...internalInitialize()");
        }
    }

    protected void dumpState() {
        int cb = 7;
        RobotLog.logBytes((String)TAG, (String)"state", (byte[])this.read(BroadcomColorSensor.Register.MAIN_CTRL, cb), (int)cb);
    }

    protected synchronized void enable() {
        byte enabled = this.readMainCtrl();
        RobotLog.vv((String)TAG, (String)"enable() enabled=0x%02x...", (Object[])new Object[]{enabled});
        this.write8(BroadcomColorSensor.Register.MAIN_CTRL, BroadcomColorSensor.MainControl.PS_EN.bVal | BroadcomColorSensor.MainControl.LS_EN.bVal | BroadcomColorSensor.MainControl.RGB_MODE.bVal);
        enabled = this.readMainCtrl();
        RobotLog.vv((String)TAG, (String)"...enable() enabled=0x%02x", (Object[])new Object[]{enabled});
    }

    protected synchronized void disable() {
        byte enabled = this.readMainCtrl();
        RobotLog.vv((String)TAG, (String)"disable() enabled=0x%02x...", (Object[])new Object[]{enabled});
        this.write8(BroadcomColorSensor.Register.MAIN_CTRL, enabled & ~(BroadcomColorSensor.MainControl.PS_EN.bVal | BroadcomColorSensor.MainControl.LS_EN.bVal | BroadcomColorSensor.MainControl.RGB_MODE.bVal));
        enabled = this.readMainCtrl();
        RobotLog.vv((String)TAG, (String)"...disable() enabled=0x%02x", (Object[])new Object[]{enabled});
    }

    protected boolean testBits(byte value, byte desired) {
        return this.testBits(value, desired, desired);
    }

    protected boolean testBits(byte value, byte mask, byte desired) {
        return (value & mask) == desired;
    }

    protected byte readMainCtrl() {
        return this.read8(BroadcomColorSensor.Register.MAIN_CTRL);
    }

    protected void setProximityPulseCount(int proximityPulseCount) {
        RobotLog.vv((String)TAG, (String)"setProximityPulseCount(0x%02x)", (Object[])new Object[]{proximityPulseCount});
        this.write8(BroadcomColorSensor.Register.PS_PULSES, proximityPulseCount);
    }

    protected void setHardwareGain(BroadcomColorSensor.Gain gain) {
        RobotLog.vv((String)TAG, (String)"setGain(0x%02x)", (Object[])new Object[]{gain.bVal});
        this.write8(BroadcomColorSensor.Register.LS_GAIN, gain.bVal);
    }

    protected void setPDrive(BroadcomColorSensor.LEDCurrent ledDrive) {
        RobotLog.vv((String)TAG, (String)"setPDrive(0x%02x)", (Object[])new Object[]{ledDrive.bVal});
        this.write8(BroadcomColorSensor.Register.PS_LED, ledDrive.bVal);
    }

    @Override
    public byte getDeviceID() {
        return this.read8(BroadcomColorSensor.Register.PART_ID);
    }

    protected void setLEDParameters(BroadcomColorSensor.LEDPulseModulation pulseMod, BroadcomColorSensor.LEDCurrent curr) {
        int val = pulseMod.bVal << 4 | curr.bVal;
        RobotLog.vv((String)TAG, (String)"setLEDParameters(0x%02x)", (Object[])new Object[]{(byte)val});
        this.write8(BroadcomColorSensor.Register.PS_LED, (byte)val);
    }

    protected void setPSRateAndRes(BroadcomColorSensor.PSResolution res, BroadcomColorSensor.PSMeasurementRate rate) {
        int val = res.bVal << 3 | rate.bVal;
        RobotLog.vv((String)TAG, (String)"setPSMeasRate(0x%02x)", (Object[])new Object[]{(byte)val});
        this.write8(BroadcomColorSensor.Register.PS_MEAS_RATE, (byte)val);
    }

    protected void setLSRateAndRes(BroadcomColorSensor.LSResolution res, BroadcomColorSensor.LSMeasurementRate rate) {
        int val = res.bVal << 4 | rate.bVal;
        RobotLog.vv((String)TAG, (String)"setLSMeasRate(0x%02x)", (Object[])new Object[]{(byte)val});
        this.write8(BroadcomColorSensor.Register.LS_MEAS_RATE, (byte)val);
    }

    public synchronized int red() {
        this.updateColors();
        return this.red;
    }

    public synchronized int green() {
        this.updateColors();
        return this.green;
    }

    public synchronized int blue() {
        this.updateColors();
        return this.blue;
    }

    public synchronized int alpha() {
        this.updateColors();
        return this.alpha;
    }

    @ColorInt
    public synchronized int argb() {
        return this.getNormalizedColors().toColor();
    }

    public void setGain(float newGain) {
        this.softwareGain = newGain;
    }

    public float getGain() {
        return this.softwareGain;
    }

    private void updateColors() {
        byte[] data = null;
        byte mainStatus = this.read8(BroadcomColorSensor.Register.MAIN_STATUS);
        if (this.testBits(mainStatus, BroadcomColorSensor.MainStatus.LS_DATA_STATUS.bVal)) {
            int cbRead = 9;
            data = this.read(BroadcomColorSensor.Register.LS_DATA_GREEN, 9);
            boolean dib = false;
            this.green = TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)0, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
            this.blue = Range.clip((int)((int)(1.55 * (double)TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)3, (ByteOrder)ByteOrder.LITTLE_ENDIAN)))), (int)0, (int)65535);
            this.red = Range.clip((int)((int)(1.07 * (double)TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)6, (ByteOrder)ByteOrder.LITTLE_ENDIAN)))), (int)0, (int)65535);
            this.alpha = (this.red + this.green + this.blue) / 3;
            this.colors.red = Range.clip((float)((float)this.red * this.softwareGain / (float)((BroadcomColorSensor.Parameters)this.parameters).colorSaturation), (float)0.0f, (float)1.0f);
            this.colors.green = Range.clip((float)((float)this.green * this.softwareGain / (float)((BroadcomColorSensor.Parameters)this.parameters).colorSaturation), (float)0.0f, (float)1.0f);
            this.colors.blue = Range.clip((float)((float)this.blue * this.softwareGain / (float)((BroadcomColorSensor.Parameters)this.parameters).colorSaturation), (float)0.0f, (float)1.0f);
            float avg = (float)(this.red + this.green + this.blue) / 3.0f;
            this.colors.alpha = (float)(-(65535.0 / (Math.pow(avg, 2.0) + 65535.0)) + 1.0);
        }
    }

    public NormalizedRGBA getNormalizedColors() {
        this.updateColors();
        return this.colors;
    }

    public synchronized void enableLed(boolean enable) {
    }

    public boolean isLightOn() {
        return true;
    }

    public synchronized I2cAddr getI2cAddress() {
        return this.deviceClient.getI2cAddress();
    }

    public synchronized void setI2cAddress(I2cAddr i2cAddr) {
        ((BroadcomColorSensor.Parameters)this.parameters).i2cAddr = i2cAddr;
        this.deviceClient.setI2cAddress(i2cAddr);
    }

    public String getDeviceName() {
        return "Broadcom I2C Color Sensor";
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Broadcom;
    }

    public void resetDeviceConfigurationForOpMode() {
        super.resetDeviceConfigurationForOpMode();
        this.softwareGain = 1.0f;
    }

    protected int readUnsignedByte(BroadcomColorSensor.Register reg) {
        return TypeConversion.unsignedByteToInt((byte)this.read8(reg));
    }

    protected int readUnsignedShort(BroadcomColorSensor.Register reg, ByteOrder byteOrder) {
        byte[] data = this.read(reg, 2);
        return TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])data, (int)0, (ByteOrder)byteOrder));
    }

    @Override
    public synchronized byte read8(BroadcomColorSensor.Register reg) {
        return this.deviceClient.read8((int)reg.bVal);
    }

    @Override
    public synchronized byte[] read(BroadcomColorSensor.Register reg, int cb) {
        return this.deviceClient.read((int)reg.bVal, cb);
    }

    @Override
    public synchronized void write8(BroadcomColorSensor.Register reg, int data) {
        this.deviceClient.write8((int)reg.bVal, data, I2cWaitControl.WRITTEN);
    }

    @Override
    public void write(BroadcomColorSensor.Register reg, byte[] data) {
        this.deviceClient.write((int)reg.bVal, data, I2cWaitControl.WRITTEN);
    }

    protected void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

