/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.dfrobot;

import com.qualcomm.hardware.R;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.TypeConversion;
import com.qualcomm.robotcore.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

@I2cDeviceType
@DeviceProperties(name="@string/dfrobot_huskylens_name", description="@string/dfrobot_huskylens_description", xmlTag="HuskyLens")
public class HuskyLens
extends I2cDeviceSynchDevice<I2cDeviceSynch> {
    private final String TAG = "HuskyLens";
    private final byte CMD_REQUEST_KNOCK = (byte)44;
    private final byte CMD_REQUEST_ALL = (byte)32;
    private final byte CMD_REQUEST_BLOCKS = (byte)33;
    private final byte CMD_REQUEST_BLOCK_BY_ID = (byte)39;
    private final byte CMD_REQUEST_ARROWS = (byte)34;
    private final byte CMD_REQUEST_ARROW_BY_ID = (byte)40;
    private final byte CMD_REQUEST_ALGORITHM = (byte)45;
    private final byte LEARNED = (byte)35;
    private final byte BLOCKS_LEARNED = (byte)36;
    private final byte ARROWS_LEARNED = (byte)37;
    private final byte BY_ID = (byte)38;
    private final byte BLOCKS_BY_ID = (byte)39;
    private final byte ARROWS_BY_ID = (byte)40;
    private final byte CMD_RESP_OK = (byte)46;
    private final byte CMD_RESP_INFO = (byte)41;
    private final byte CMD_RESP_BLOCK = (byte)42;
    private final byte CMD_RESP_ARROW = (byte)43;
    private final byte FACE_RECOGNITION = 0;
    private final byte OBJECT_TRACKING = 1;
    private final byte OBJECT_RECOGNITION = (byte)2;
    private final byte LINE_TRACKING = (byte)3;
    private final byte COLOR_RECOGNITION = (byte)4;
    private final byte TAG_RECOGNITION = (byte)5;
    private final byte OBJECT_CLASSIFICATION = (byte)6;
    private final byte HEADER_BYTE_1 = (byte)85;
    private final byte HEADER_BYTE_2 = (byte)-86;
    private final byte PROTOCOL_ADDR = (byte)17;
    protected final int DEFAULT_I2C_ADDR = 50;
    private final byte CMD_RESP_INFO_LEN = (byte)16;
    private final byte CMD_RESP_BLOCK_LEN = (byte)16;
    private final byte CMD_RESP_ARROW_LEN = (byte)16;
    private final byte CMD_RESP_OK_LEN = (byte)6;
    private final byte MAX_BLOCKS_IN_RESPONSE = (byte)6;
    private final byte MAX_ARROWS_IN_RESPONSE = (byte)6;
    private static final Block[] NO_BLOCKS = new Block[0];
    private static final Arrow[] NO_ARROWS = new Arrow[0];
    private static final boolean debug = false;

    public HuskyLens(I2cDeviceSynch deviceClient) {
        super((I2cDeviceSynchSimple)deviceClient, true);
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(I2cAddr.create7bit((int)50));
        super.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.DFRobot;
    }

    protected synchronized boolean doInitialize() {
        return this.knock();
    }

    public String getDeviceName() {
        return AppUtil.getDefContext().getString(R.string.dfrobot_huskylens_name);
    }

    public boolean knock() {
        this.sendCommand((byte)44);
        byte[] buf = ((I2cDeviceSynch)this.deviceClient).read(6);
        if (buf == null) {
            RobotLog.ee((String)"HuskyLens", (String)"I2C transaction failed");
            return false;
        }
        if (!this.verifyChecksum(buf)) {
            RobotLog.ee((String)"HuskyLens", (String)"Checksum failed for command KNOCK ");
            return false;
        }
        return true;
    }

    public void selectAlgorithm(Algorithm algorithm) {
        this.sendCommandWithData((byte)45, algorithm.bVal, (byte)0);
    }

    public Block[] blocks() {
        this.sendCommand((byte)33);
        return this.readBlocksResponse();
    }

    public Block[] blocks(int id) {
        byte highByte = (byte)(id & 0xFF);
        byte lowByte = (byte)(id >> 8 & 0xFF);
        this.sendCommandWithData((byte)39, highByte, lowByte);
        return this.readBlocksResponse();
    }

    public Arrow[] arrows() {
        this.sendCommand((byte)34);
        return this.readArrowsResponse();
    }

    public Arrow[] arrows(int id) {
        byte highByte = (byte)(id & 0xFF);
        byte lowByte = (byte)(id >> 8 & 0xFF);
        this.sendCommandWithData((byte)40, highByte, lowByte);
        return this.readArrowsResponse();
    }

    protected byte[] readInfo() {
        return ((I2cDeviceSynch)this.deviceClient).read(0, 16);
    }

    protected Block[] readBlocksResponse() {
        byte[] info = this.readInfo();
        if (!this.verifyChecksum(info)) {
            return NO_BLOCKS;
        }
        int count = this.byteToShort(info, 5);
        if (count == 0) {
            return NO_BLOCKS;
        }
        if (count > 6) {
            count = 6;
        }
        Block[] blocks = new Block[count];
        byte[] block_buf = new byte[16];
        byte[] buf = ((I2cDeviceSynch)this.deviceClient).read(16 * count - 1);
        byte[] prependByte = new byte[]{85};
        ByteBuffer byteBuf = ByteBuffer.wrap(Util.concatenateByteArrays((byte[])prependByte, (byte[])buf));
        for (int i = 0; i < count; ++i) {
            byteBuf.get(block_buf, 0, 16);
            if (!this.verifyChecksum(block_buf)) {
                RobotLog.ee((String)"HuskyLens", (String)("Checksum failed for block " + i));
                RobotLog.logBytes((String)"HuskyLens", (String)"Checksum failure: ", (byte[])block_buf, (int)block_buf.length);
                continue;
            }
            blocks[i] = new Block(block_buf);
            RobotLog.ii((String)"HuskyLens", (String)blocks[i].toString());
        }
        return blocks;
    }

    protected Arrow[] readArrowsResponse() {
        byte[] info = this.readInfo();
        if (!this.verifyChecksum(info)) {
            return NO_ARROWS;
        }
        int count = this.byteToShort(info, 5);
        if (count == 0) {
            return NO_ARROWS;
        }
        if (count > 6) {
            count = 6;
        }
        Arrow[] arrows = new Arrow[count];
        byte[] arrow_buf = new byte[16];
        byte[] buf = ((I2cDeviceSynch)this.deviceClient).read(16 * count - 1);
        byte[] prependByte = new byte[]{85};
        ByteBuffer byteBuf = ByteBuffer.wrap(Util.concatenateByteArrays((byte[])prependByte, (byte[])buf));
        for (int i = 0; i < count; ++i) {
            byteBuf.get(arrow_buf, 0, 16);
            if (!this.verifyChecksum(arrow_buf)) {
                RobotLog.ee((String)"HuskyLens", (String)("Checksum failed for arrow " + i));
                RobotLog.logBytes((String)"HuskyLens", (String)"Checksum failure: ", (byte[])arrow_buf, (int)arrow_buf.length);
                continue;
            }
            arrows[i] = new Arrow(arrow_buf);
            RobotLog.ii((String)"HuskyLens", (String)arrows[i].toString());
        }
        return arrows;
    }

    protected void sendCommand(byte cmd) {
        byte[] tmp = new byte[]{85, -86, 17, 0, cmd, 0};
        ByteBuffer buf = ByteBuffer.wrap(tmp);
        buf.put(5, this.calculateChecksum(tmp));
        ((I2cDeviceSynch)this.deviceClient).write(buf.array());
    }

    protected void sendCommandWithData(byte cmd, byte d1, byte d2) {
        byte[] tmp = new byte[]{85, -86, 17, 2, cmd, d1, d2, 0};
        ByteBuffer buf = ByteBuffer.wrap(tmp);
        buf.put(7, this.calculateChecksum(tmp));
        ((I2cDeviceSynch)this.deviceClient).write(buf.array());
    }

    private int byteToShort(byte[] m, int i) {
        if (i + 1 > m.length) {
            throw new IllegalArgumentException();
        }
        return TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])m, (int)i, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
    }

    private byte calculateChecksum(byte[] buf) {
        int checksum = 0;
        for (int i = 0; i < buf.length - 1; ++i) {
            checksum += buf[i] & 0xFF;
        }
        return (byte)checksum;
    }

    private boolean verifyChecksum(byte[] buf) {
        byte sum = this.calculateChecksum(buf);
        if (sum == buf[buf.length - 1]) {
            return true;
        }
        return true;
    }

    public static enum Algorithm {
        FACE_RECOGNITION(0),
        OBJECT_TRACKING(1),
        OBJECT_RECOGNITION(2),
        LINE_TRACKING(3),
        COLOR_RECOGNITION(4),
        TAG_RECOGNITION(5),
        OBJECT_CLASSIFICATION(6),
        NONE(255);

        public byte bVal;

        private Algorithm(int val) {
            this.bVal = (byte)val;
        }
    }

    public class Block {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final int top;
        public final int left;
        public final int id;

        public Block(byte[] buf) {
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            if (buf.length < 16) {
                throw new IllegalArgumentException();
            }
            this.x = HuskyLens.this.byteToShort(buf, 5);
            this.y = HuskyLens.this.byteToShort(buf, 7);
            this.width = HuskyLens.this.byteToShort(buf, 9);
            this.height = HuskyLens.this.byteToShort(buf, 11);
            this.id = HuskyLens.this.byteToShort(buf, 13);
            this.top = this.y - this.height / 2;
            this.left = this.x - this.width / 2;
        }

        public String toString() {
            return "id=" + this.id + " size: " + this.width + "x" + this.height + " position: " + this.x + "," + this.y;
        }
    }

    public class Arrow {
        public final int x_origin;
        public final int y_origin;
        public final int x_target;
        public final int y_target;
        public final int id;

        public Arrow(byte[] buf) {
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            if (buf.length < 16) {
                throw new IllegalArgumentException();
            }
            this.x_origin = HuskyLens.this.byteToShort(buf, 5);
            this.y_origin = HuskyLens.this.byteToShort(buf, 7);
            this.x_target = HuskyLens.this.byteToShort(buf, 9);
            this.y_target = HuskyLens.this.byteToShort(buf, 11);
            this.id = HuskyLens.this.byteToShort(buf, 13);
        }

        public String toString() {
            return "id=" + this.id + " origin:" + this.x_origin + "," + this.y_origin + " target:" + this.x_target + "," + this.y_target;
        }
    }
}

