/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.digitalchickenlabs;

import androidx.annotation.NonNull;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import java.util.Locale;

public interface OctoQuad
extends HardwareDevice {
    public static final byte OCTOQUAD_CHIP_ID = 81;
    public static final int SUPPORTED_FW_VERSION_MAJ = 3;
    public static final int ENCODER_FIRST = 0;
    public static final int ENCODER_LAST = 7;
    public static final int NUM_ENCODERS = 8;
    public static final int MIN_VELOCITY_MEASUREMENT_INTERVAL_MS = 1;
    public static final int MAX_VELOCITY_MEASUREMENT_INTERVAL_MS = 255;
    public static final int MIN_PULSE_WIDTH_US = 0;
    public static final int MAX_PULSE_WIDTH_US = 65535;

    public byte getChipId();

    public FirmwareVersion getFirmwareVersion();

    public String getFirmwareVersionString();

    public void setSingleEncoderDirection(int var1, EncoderDirection var2);

    public EncoderDirection getSingleEncoderDirection(int var1);

    public void setAllEncoderDirections(boolean[] var1);

    public void setChannelBankConfig(ChannelBankConfig var1);

    public ChannelBankConfig getChannelBankConfig();

    public void readAllEncoderData(EncoderDataBlock var1);

    public EncoderDataBlock readAllEncoderData();

    public void setCachingMode(CachingMode var1);

    public void refreshCache();

    public int readSinglePosition_Caching(int var1);

    public short readSingleVelocity_Caching(int var1);

    @Deprecated
    public short readSingleVelocity(int var1);

    @Deprecated
    public int readSinglePosition(int var1);

    public void resetSinglePosition(int var1);

    public void resetAllPositions();

    public void resetMultiplePositions(boolean[] var1);

    public void resetMultiplePositions(int ... var1);

    public void setSingleVelocitySampleInterval(int var1, int var2);

    public int getSingleVelocitySampleInterval(int var1);

    public void setAllVelocitySampleIntervals(int var1);

    public void setSingleChannelPulseWidthParams(int var1, int var2, int var3);

    public void setSingleChannelPulseWidthParams(int var1, ChannelPulseWidthParams var2);

    public ChannelPulseWidthParams getSingleChannelPulseWidthParams(int var1);

    public void setSingleChannelPulseWidthTracksWrap(int var1, boolean var2);

    public boolean getSingleChannelPulseWidthTracksWrap(int var1);

    public void setAllChannelsPulseWidthTracksWrap(boolean[] var1);

    public void setLocalizerPortX(int var1);

    public void setLocalizerPortY(int var1);

    public void setLocalizerCountsPerMM_X(float var1);

    public void setLocalizerCountsPerMM_Y(float var1);

    public void setLocalizerTcpOffsetMM_X(float var1);

    public void setLocalizerTcpOffsetMM_Y(float var1);

    public void setLocalizerImuHeadingScalar(float var1);

    public void setLocalizerVelocityIntervalMS(int var1);

    public void setAllLocalizerParameters(int var1, int var2, float var3, float var4, float var5, float var6, float var7, int var8);

    public void readLocalizerData(LocalizerDataBlock var1);

    public LocalizerDataBlock readLocalizerData();

    public void readLocalizerDataAndAllEncoderData(LocalizerDataBlock var1, EncoderDataBlock var2);

    public void setLocalizerPose(int var1, int var2, float var3);

    public void setLocalizerHeading(float var1);

    public LocalizerStatus getLocalizerStatus();

    public LocalizerYawAxis getLocalizerHeadingAxisChoice();

    public void resetLocalizerAndCalibrateIMU();

    public void setI2cRecoveryMode(I2cRecoveryMode var1);

    public I2cRecoveryMode getI2cRecoveryMode();

    public void saveParametersToFlash();

    public void resetEverything();

    public static enum I2cRecoveryMode {
        NONE(0),
        MODE_1_PERIPH_RST_ON_FRAME_ERR(1),
        MODE_2_M1_PLUS_SCL_IDLE_ONESHOT_TGL(2);

        final byte bVal;

        private I2cRecoveryMode(int bVal) {
            this.bVal = (byte)bVal;
        }
    }

    public static enum LocalizerYawAxis {
        UNDECIDED(0),
        X(1),
        X_INV(2),
        Y(3),
        Y_INV(4),
        Z(5),
        Z_INV(6);

        final int code;

        private LocalizerYawAxis(int code) {
            this.code = code;
        }
    }

    public static enum LocalizerStatus {
        INVALID(0),
        NOT_INITIALIZED(1),
        WARMING_UP_IMU(2),
        CALIBRATING_IMU(3),
        RUNNING(4),
        FAULT_NO_IMU(5);

        final int code;

        private LocalizerStatus(int code) {
            this.code = code;
        }
    }

    public static class LocalizerDataBlock {
        public LocalizerStatus localizerStatus;
        public boolean crcOk;
        public float heading_rad;
        public short posX_mm;
        public short posY_mm;
        public short velX_mmS;
        public short velY_mmS;
        public float velHeading_radS;

        public boolean isDataValid() {
            return this.crcOk && this.localizerStatus == LocalizerStatus.RUNNING;
        }
    }

    public static class ChannelPulseWidthParams {
        public int min_length_us;
        public int max_length_us;

        public ChannelPulseWidthParams() {
        }

        public ChannelPulseWidthParams(int min_length_us, int max_length_us) {
            this.min_length_us = min_length_us;
            this.max_length_us = max_length_us;
        }
    }

    public static enum CachingMode {
        MANUAL,
        AUTO;

    }

    public static class EncoderDataBlock {
        public int[] positions = new int[8];
        public short[] velocities = new short[8];
        public boolean crcOk;

        public boolean isDataValid() {
            return this.crcOk;
        }

        public void copyTo(EncoderDataBlock target) {
            System.arraycopy(this.positions, 0, target.positions, 0, 8);
            System.arraycopy(this.velocities, 0, target.velocities, 0, 8);
            target.crcOk = this.crcOk;
        }
    }

    public static enum ChannelBankConfig {
        ALL_QUADRATURE(0),
        ALL_PULSE_WIDTH(1),
        BANK1_QUADRATURE_BANK2_PULSE_WIDTH(2);

        final byte bVal;

        private ChannelBankConfig(int bVal) {
            this.bVal = (byte)bVal;
        }
    }

    public static enum EncoderDirection {
        FORWARD,
        REVERSE;

    }

    public static class FirmwareVersion {
        public final int maj;
        public final int min;
        public final int eng;

        public FirmwareVersion(int maj, int min, int eng) {
            this.maj = maj;
            this.min = min;
            this.eng = eng;
        }

        @NonNull
        public String toString() {
            return String.format(Locale.US, "%d.%d.%d", this.maj, this.min, this.eng);
        }
    }
}

