/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.digitalchickenlabs;

import com.qualcomm.hardware.digitalchickenlabs.OctoQuad;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.Range;
import com.qualcomm.robotcore.util.RobotLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@I2cDeviceType
@DeviceProperties(xmlTag="OctoQuadFTC", name="OctoQuadFTC")
public class OctoQuadImpl
extends I2cDeviceSynchDevice<I2cDeviceSynchSimple>
implements OctoQuad {
    private static final int I2C_ADDRESS = 48;
    private static final int SUPPORTED_FW_VERSION_MAJ = 3;
    private static final int SUPPORTED_FW_VERSION_MIN = 0;
    private static final ByteOrder OCTOQUAD_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    private static final byte CMD_SET_PARAM = 1;
    private static final byte CMD_READ_PARAM = 2;
    private static final byte CMD_WRITE_PARAMS_TO_FLASH = 3;
    private static final byte CMD_RESET_EVERYTHING = 20;
    private static final byte CMD_RESET_ENCODERS = 21;
    private static final byte CMD_RESET_LOCALIZER = 40;
    private static final byte PARAM_ENCODER_DIRECTIONS = 0;
    private static final byte PARAM_I2C_RECOVERY_MODE = 1;
    private static final byte PARAM_CHANNEL_BANK_CONFIG = 2;
    private static final byte PARAM_CHANNEL_VEL_INTVL = 3;
    private static final byte PARAM_CHANNEL_PULSE_WIDTH_MIN_MAX = 4;
    private static final byte PARAM_CHANNEL_PULSE_WIDTH_TRACKS_WRAP = 5;
    private static final byte PARAM_LOCALIZER_X_TICKS_PER_MM = 50;
    private static final byte PARAM_LOCALIZER_Y_TICKS_PER_MM = 51;
    private static final byte PARAM_LOCALIZER_TCP_OFFSET_X_MM = 52;
    private static final byte PARAM_LOCALIZER_TCP_OFFSET_Y_MM = 53;
    private static final byte PARAM_LOCALIZER_IMU_HEADING_SCALAR = 54;
    private static final byte PARAM_LOCALIZER_PORT_X = 55;
    private static final byte PARAM_LOCALIZER_PORT_Y = 56;
    private static final byte PARAM_LOCALIZER_VEL_INTVL = 57;
    private static final float SCALAR_LOCALIZER_HEADING_VELOCITY = 0.0016666667f;
    private static final float SCALAR_LOCALIZER_HEADING = 2.0E-4f;
    private boolean isInitialized = false;
    protected OctoQuad.CachingMode cachingMode = OctoQuad.CachingMode.AUTO;
    protected OctoQuad.EncoderDataBlock cachedData = new OctoQuad.EncoderDataBlock();
    protected boolean[] posHasBeenRead = new boolean[8];
    protected boolean[] velHasBeenRead = new boolean[8];
    private static final short crc16_profibus_init = -1;
    private static final short crc16_profibus_xor_out = -1;
    private static final short[] crc16_profibus_table = new short[]{0, 7631, 15262, 9809, 30524, 27379, 19618, 20845, -4488, -3145, -10778, -14295, -26300, -31605, -23846, -16619, -16065, -8976, -1375, -6290, -18941, -21556, -29283, -28590, 12103, 12936, 5337, 2326, 22651, 17844, 25573, 32298, -24655, -32130, -23505, -17952, -6003, -2750, -11501, -12580, 29129, 27654, 19031, 22424, 1781, 6970, 15723, 8356, 24206, 17217, 25872, 30943, 10674, 13437, 4652, 4067, -20234, -21191, -29848, -26969, -14390, -9723, -940, -7781, 8877, 16226, 6451, 1276, 21905, 18526, 28175, 29632, -13099, -12006, -2229, -5500, -17431, -23002, -32649, -25160, -7278, -419, -10228, -14909, -27474, -30367, -20688, -19713, 3562, 4133, 13940, 11195, 31446, 26393, 16712, 23687, -17124, -24365, -31102, -25779, -13792, -10257, -3650, -5007, 21348, 20139, 26874, 30005, 9304, 14743, 8134, 521, 31779, 25068, 18365, 23154, 2847, 5840, 12417, 11598, -28069, -28780, -22075, -19446, -6809, -1880, -8455, -15562, 17754, 22677, 32452, 25355, 12902, 12201, 2552, 5175, -21726, -18707, -28484, -29325, -9186, -15919, -6272, -1457, -31643, -26198, -16389, -24012, -3239, -4458, -14137, -11000, 27165, 30674, 20867, 19532, 7457, 238, 9919, 15216, -9493, -14556, -7819, -838, -21033, -20456, -27063, -29818, 13459, 10588, 3853, 4802, 17327, 24160, 30769, 26110, 7124, 1563, 8266, 15749, 27880, 28967, 22390, 19129, -2644, -6045, -12750, -11267, -32112, -24737, -18162, -23359, 26615, 31288, 23657, 16806, 4299, 3332, 11093, 13978, -30321, -27584, -19951, -20514, -333, -7300, -15059, -10014, -22840, -17657, -25258, -32615, -11788, -13253, -5526, -2139, 18608, 21887, 29486, 28385, 16268, 8771, 1042, 6621, -1978, -6775, -15400, -8681, -28806, -27979, -19228, -22229, 5694, 3057, 11680, 12399, 24834, 31949, 23196, 18259, 14713, 9398, 743, 7976, 20037, 21386, 30171, 26644, -10495, -13618, -4961, -3760, -24515, -16910, -25693, -31124};

    public OctoQuadImpl(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(deviceClient, deviceClientIsOwned);
        this.deviceClient.setI2cAddress(I2cAddr.create7bit((int)48));
        super.registerArmingStateCallback(false);
    }

    protected boolean doInitialize() {
        ((LynxI2cDeviceSynch)this.deviceClient).setBusSpeed(LynxI2cDeviceSynch.BusSpeed.FAST_400K);
        this.isInitialized = false;
        this.verifyInitialization();
        return true;
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.DigitalChickenLabs;
    }

    public String getDeviceName() {
        return "OctoQuadFTC";
    }

    @Override
    public byte getChipId() {
        return this.readRegister(Register.CHIP_ID)[0];
    }

    @Override
    public OctoQuad.FirmwareVersion getFirmwareVersion() {
        byte[] fw = this.readContiguousRegisters(Register.FIRMWARE_VERSION_MAJOR, Register.FIRMWARE_VERSION_ENGINEERING);
        int maj = fw[0] & 0xFF;
        int min = fw[1] & 0xFF;
        int eng = fw[2] & 0xFF;
        return new OctoQuad.FirmwareVersion(maj, min, eng);
    }

    @Override
    public String getFirmwareVersionString() {
        return this.getFirmwareVersion().toString();
    }

    @Override
    public int readSinglePosition(int idx) {
        return this.readSinglePosition_Caching(idx);
    }

    @Override
    public void resetSinglePosition(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        byte dat = (byte)(1 << idx);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, dat});
        if (this.cachingMode == OctoQuad.CachingMode.AUTO) {
            this.refreshCache();
        }
    }

    @Override
    public void resetAllPositions() {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, -1});
        if (this.cachingMode == OctoQuad.CachingMode.AUTO) {
            this.refreshCache();
        }
    }

    @Override
    public void resetMultiplePositions(boolean[] resets) {
        this.verifyInitialization();
        if (resets.length != 8) {
            throw new IllegalArgumentException("resets.length != 8");
        }
        byte dat = 0;
        for (int i = 0; i <= 7; ++i) {
            dat = (byte)(dat | (resets[i] ? (byte)(1 << i) : (byte)0));
        }
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, dat});
        if (this.cachingMode == OctoQuad.CachingMode.AUTO) {
            this.refreshCache();
        }
    }

    @Override
    public void resetMultiplePositions(int ... indices) {
        this.verifyInitialization();
        for (int idx : indices) {
            Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        }
        byte dat = 0;
        for (int idx : indices) {
            dat = (byte)(dat | (byte)(1 << idx));
        }
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, dat});
        if (this.cachingMode == OctoQuad.CachingMode.AUTO) {
            this.refreshCache();
        }
    }

    @Override
    public void setSingleEncoderDirection(int idx, OctoQuad.EncoderDirection direction) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 0});
        byte directionRegisterData = this.readRegister(Register.COMMAND_DAT_0)[0];
        directionRegisterData = direction == OctoQuad.EncoderDirection.REVERSE ? (byte)(directionRegisterData | (byte)(1 << idx)) : (byte)(directionRegisterData & (byte)(~(1 << idx)));
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 0, directionRegisterData});
    }

    @Override
    public OctoQuad.EncoderDirection getSingleEncoderDirection(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 0});
        byte directions = this.readRegister(Register.COMMAND_DAT_0)[0];
        boolean reversed = (directions & 1 << idx) != 0;
        return reversed ? OctoQuad.EncoderDirection.REVERSE : OctoQuad.EncoderDirection.FORWARD;
    }

    @Override
    public void setAllEncoderDirections(boolean[] reverse) {
        this.verifyInitialization();
        if (reverse.length != 8) {
            throw new IllegalArgumentException("reverse.length != 8");
        }
        byte directionRegisterData = 0;
        for (int i = 0; i <= 7; ++i) {
            if (!reverse[i]) continue;
            directionRegisterData = (byte)(directionRegisterData | (byte)(1 << i));
        }
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 0, directionRegisterData});
    }

    @Override
    public short readSingleVelocity(int idx) {
        return this.readSingleVelocity_Caching(idx);
    }

    private void unpackAllEncoderData(ByteBuffer buffer, OctoQuad.EncoderDataBlock out) {
        int i;
        buffer.mark();
        byte[] asArray = new byte[(RegisterType.int32_t.length + RegisterType.int16_t.length) * 8];
        buffer.get(asArray);
        buffer.reset();
        for (i = 0; i < 8; ++i) {
            out.positions[i] = buffer.getInt();
        }
        for (i = 0; i < 8; ++i) {
            out.velocities[i] = buffer.getShort();
        }
        short crc = buffer.getShort();
        short calculatedCrc = OctoQuadImpl.calc_crc16_profibus(asArray);
        boolean bl = out.crcOk = calculatedCrc == crc;
        if (!out.crcOk) {
            RobotLog.ee((String)"OctoQuadImpl", (String)String.format("Encoder data CRC error! Expect = 0x%x Actual = 0x%x", calculatedCrc, crc));
        }
    }

    @Override
    public void readAllEncoderData(OctoQuad.EncoderDataBlock out) {
        this.verifyInitialization();
        if (out.positions.length != 8) {
            throw new IllegalArgumentException("out.counts.length != 8");
        }
        if (out.velocities.length != 8) {
            throw new IllegalArgumentException("out.velocities.length != 8");
        }
        byte[] bytes = this.readContiguousRegisters(Register.ENCODER_0_POSITION, Register.ENCODER_DATA_CRC16);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(OCTOQUAD_ENDIAN);
        this.unpackAllEncoderData(buffer, out);
        if (out.crcOk) {
            out.copyTo(this.cachedData);
            Arrays.fill(this.posHasBeenRead, false);
            Arrays.fill(this.velHasBeenRead, false);
        }
    }

    @Override
    public OctoQuad.EncoderDataBlock readAllEncoderData() {
        OctoQuad.EncoderDataBlock block = new OctoQuad.EncoderDataBlock();
        this.readAllEncoderData(block);
        return block;
    }

    @Override
    public void setSingleVelocitySampleInterval(int idx, int intvlms) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        Range.throwIfRangeIsInvalid((int)intvlms, (int)1, (int)255);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_2, new byte[]{1, 3, (byte)idx, (byte)intvlms});
    }

    @Override
    public int getSingleVelocitySampleInterval(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{2, 3, (byte)idx});
        byte ms = this.readRegister(Register.COMMAND_DAT_0)[0];
        return ms & 0xFF;
    }

    @Override
    public void setAllVelocitySampleIntervals(int intvlms) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)intvlms, (int)1, (int)255);
        for (int i = 0; i <= 7; ++i) {
            this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_2, new byte[]{1, 3, (byte)i, (byte)intvlms});
        }
    }

    @Override
    public void setSingleChannelPulseWidthParams(int idx, int min, int max) {
        this.setSingleChannelPulseWidthParams(idx, new OctoQuad.ChannelPulseWidthParams(min, max));
    }

    @Override
    public void setSingleChannelPulseWidthParams(int idx, OctoQuad.ChannelPulseWidthParams params) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        Range.throwIfRangeIsInvalid((int)params.min_length_us, (int)0, (int)65535);
        Range.throwIfRangeIsInvalid((int)params.max_length_us, (int)0, (int)65535);
        if (params.max_length_us <= params.min_length_us) {
            throw new RuntimeException("params.max_length_us <= params.min_length_us");
        }
        ByteBuffer outgoing = ByteBuffer.allocate(7);
        outgoing.order(OCTOQUAD_ENDIAN);
        outgoing.put((byte)1);
        outgoing.put((byte)4);
        outgoing.put((byte)idx);
        outgoing.putShort((short)params.min_length_us);
        outgoing.putShort((short)params.max_length_us);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_5, outgoing.array());
    }

    @Override
    public OctoQuad.ChannelPulseWidthParams getSingleChannelPulseWidthParams(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{2, 4, (byte)idx});
        byte[] result = this.readContiguousRegisters(Register.COMMAND_DAT_0, Register.COMMAND_DAT_3);
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.order(OCTOQUAD_ENDIAN);
        OctoQuad.ChannelPulseWidthParams params = new OctoQuad.ChannelPulseWidthParams();
        params.min_length_us = buffer.getShort() & 0xFFFF;
        params.max_length_us = buffer.getShort() & 0xFFFF;
        return params;
    }

    @Override
    public void setSingleChannelPulseWidthTracksWrap(int idx, boolean trackWrap) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 5});
        byte absWrapTrackRegisterData = this.readRegister(Register.COMMAND_DAT_0)[0];
        absWrapTrackRegisterData = trackWrap ? (byte)(absWrapTrackRegisterData | (byte)(1 << idx)) : (byte)(absWrapTrackRegisterData & (byte)(~(1 << idx)));
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 5, absWrapTrackRegisterData});
    }

    @Override
    public boolean getSingleChannelPulseWidthTracksWrap(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 5});
        byte tracking = this.readRegister(Register.COMMAND_DAT_0)[0];
        return (tracking & 1 << idx) != 0;
    }

    @Override
    public void setAllChannelsPulseWidthTracksWrap(boolean[] trackWrap) {
        this.verifyInitialization();
        if (trackWrap.length != 8) {
            throw new IllegalArgumentException("trackWrap.length != 8");
        }
        byte absWrapTrackRegisterData = 0;
        for (int i = 0; i <= 7; ++i) {
            if (!trackWrap[i]) continue;
            absWrapTrackRegisterData = (byte)(absWrapTrackRegisterData | (byte)(1 << i));
        }
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 5, absWrapTrackRegisterData});
    }

    @Override
    public void setLocalizerCountsPerMM_X(float ticksPerMM_x) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((double)ticksPerMM_x, (double)0.0, (double)3.4028234663852886E38);
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.order(OCTOQUAD_ENDIAN);
        buf.put((byte)1);
        buf.put((byte)50);
        buf.putFloat(ticksPerMM_x);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_4, buf.array());
    }

    @Override
    public void setLocalizerCountsPerMM_Y(float ticksPerMM_y) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((double)ticksPerMM_y, (double)0.0, (double)3.4028234663852886E38);
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.order(OCTOQUAD_ENDIAN);
        buf.put((byte)1);
        buf.put((byte)51);
        buf.putFloat(ticksPerMM_y);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_4, buf.array());
    }

    @Override
    public void setLocalizerTcpOffsetMM_X(float tcpOffsetMM_X) {
        this.verifyInitialization();
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.order(OCTOQUAD_ENDIAN);
        buf.put((byte)1);
        buf.put((byte)52);
        buf.putFloat(tcpOffsetMM_X);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_4, buf.array());
    }

    @Override
    public void setLocalizerTcpOffsetMM_Y(float tcpOffsetMM_Y) {
        this.verifyInitialization();
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.order(OCTOQUAD_ENDIAN);
        buf.put((byte)1);
        buf.put((byte)53);
        buf.putFloat(tcpOffsetMM_Y);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_4, buf.array());
    }

    @Override
    public void setLocalizerImuHeadingScalar(float headingScalar) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((double)headingScalar, (double)0.0, (double)3.4028234663852886E38);
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.order(OCTOQUAD_ENDIAN);
        buf.put((byte)1);
        buf.put((byte)54);
        buf.putFloat(headingScalar);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_4, buf.array());
    }

    @Override
    public void setLocalizerPortX(int port) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)port, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 55, (byte)port});
    }

    @Override
    public void setLocalizerPortY(int port) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)port, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 56, (byte)port});
    }

    @Override
    public void setLocalizerVelocityIntervalMS(int ms) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)ms, (int)1, (int)255);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 57, (byte)ms});
    }

    @Override
    public OctoQuad.LocalizerStatus getLocalizerStatus() {
        this.verifyInitialization();
        int state = this.readRegister(Register.LOCALIZER_STATUS)[0] & 0xFF;
        if (state < OctoQuad.LocalizerStatus.values().length) {
            return OctoQuad.LocalizerStatus.values()[state];
        }
        return OctoQuad.LocalizerStatus.INVALID;
    }

    @Override
    public OctoQuad.LocalizerYawAxis getLocalizerHeadingAxisChoice() {
        this.verifyInitialization();
        int code = this.readRegister(Register.LOCALIZER_YAW_AXIS)[0] & 0xFF;
        if (code < OctoQuad.LocalizerYawAxis.values().length) {
            return OctoQuad.LocalizerYawAxis.values()[code];
        }
        return OctoQuad.LocalizerYawAxis.UNDECIDED;
    }

    @Override
    public void resetLocalizerAndCalibrateIMU() {
        this.verifyInitialization();
        this.writeRegister(Register.COMMAND, new byte[]{40});
    }

    private void unpackLocalizerData(ByteBuffer buf, OctoQuad.LocalizerDataBlock out) {
        buf.mark();
        byte[] asArray = new byte[RegisterType.uint16_t.length * 6 + RegisterType.uint8_t.length];
        buf.get(asArray);
        buf.reset();
        int localizerStatusCode = buf.get() & 0xFF;
        out.localizerStatus = localizerStatusCode < OctoQuad.LocalizerStatus.values().length ? OctoQuad.LocalizerStatus.values()[localizerStatusCode] : OctoQuad.LocalizerStatus.INVALID;
        out.velX_mmS = buf.getShort();
        out.velY_mmS = buf.getShort();
        out.velHeading_radS = (float)buf.getShort() * 0.0016666667f;
        out.posX_mm = buf.getShort();
        out.posY_mm = buf.getShort();
        out.heading_rad = (float)buf.getShort() * 2.0E-4f;
        short crc = buf.getShort();
        short calculatedCrc = OctoQuadImpl.calc_crc16_profibus(asArray);
        boolean bl = out.crcOk = calculatedCrc == crc;
        if (!out.crcOk) {
            RobotLog.ee((String)"OctoQuadImpl", (String)String.format("Localizer data CRC error! Expect = 0x%x Actual = 0x%x", calculatedCrc, crc));
            StringBuilder bld = new StringBuilder();
            for (byte b : asArray) {
                bld.append(String.format(" 0x%x", b));
            }
            bld.append("\r\n");
            System.err.print(bld);
        }
    }

    @Override
    public void readLocalizerData(OctoQuad.LocalizerDataBlock out) {
        this.verifyInitialization();
        byte[] bytes = this.readContiguousRegisters(Register.LOCALIZER_STATUS, Register.LOCALIZER_CRC16);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(OCTOQUAD_ENDIAN);
        this.unpackLocalizerData(buffer, out);
    }

    @Override
    public OctoQuad.LocalizerDataBlock readLocalizerData() {
        OctoQuad.LocalizerDataBlock block = new OctoQuad.LocalizerDataBlock();
        this.readLocalizerData(block);
        return block;
    }

    @Override
    public void readLocalizerDataAndAllEncoderData(OctoQuad.LocalizerDataBlock localizerOut, OctoQuad.EncoderDataBlock encoderOut) {
        this.verifyInitialization();
        byte[] bytes = this.readContiguousRegisters(Register.LOCALIZER_STATUS, Register.ENCODER_DATA_CRC16);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(OCTOQUAD_ENDIAN);
        this.unpackLocalizerData(buffer, localizerOut);
        this.unpackAllEncoderData(buffer, encoderOut);
    }

    @Override
    public void setAllLocalizerParameters(int portX, int portY, float ticksPerMM_x, float ticksPerMM_y, float tcpOffsetMM_X, float tcpOffsetMM_Y, float headingScalar, int velocityIntervalMs) {
        this.setLocalizerPortX(portX);
        this.setLocalizerPortY(portY);
        this.setLocalizerCountsPerMM_X(ticksPerMM_x);
        this.setLocalizerCountsPerMM_Y(ticksPerMM_y);
        this.setLocalizerTcpOffsetMM_X(tcpOffsetMM_X);
        this.setLocalizerTcpOffsetMM_Y(tcpOffsetMM_Y);
        this.setLocalizerImuHeadingScalar(headingScalar);
        this.setLocalizerVelocityIntervalMS(velocityIntervalMs);
    }

    @Override
    public void setLocalizerPose(int posX_mm, int posY_mm, float heading_rad) {
        this.verifyInitialization();
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.order(OCTOQUAD_ENDIAN);
        buf.putShort((short)posX_mm);
        buf.putShort((short)posY_mm);
        buf.putShort((short)(heading_rad / 2.0E-4f));
        this.writeContiguousRegisters(Register.LOCALIZER_X, Register.LOCALIZER_H, buf.array());
    }

    @Override
    public void setLocalizerHeading(float headingRad) {
        this.verifyInitialization();
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(OCTOQUAD_ENDIAN);
        buf.putShort((short)(headingRad / 2.0E-4f));
        this.writeRegister(Register.LOCALIZER_H, buf.array());
    }

    @Override
    public void resetEverything() {
        this.verifyInitialization();
        this.writeRegister(Register.COMMAND, new byte[]{20});
    }

    @Override
    public void setChannelBankConfig(OctoQuad.ChannelBankConfig config) {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 2, config.bVal});
    }

    @Override
    public OctoQuad.ChannelBankConfig getChannelBankConfig() {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 2});
        byte result = this.readRegister(Register.COMMAND_DAT_0)[0];
        for (OctoQuad.ChannelBankConfig c : OctoQuad.ChannelBankConfig.values()) {
            if (c.bVal != result) continue;
            return c;
        }
        return OctoQuad.ChannelBankConfig.ALL_QUADRATURE;
    }

    @Override
    public void setI2cRecoveryMode(OctoQuad.I2cRecoveryMode mode) {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 1, mode.bVal});
    }

    @Override
    public OctoQuad.I2cRecoveryMode getI2cRecoveryMode() {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 1});
        byte result = this.readRegister(Register.COMMAND_DAT_0)[0];
        for (OctoQuad.I2cRecoveryMode m : OctoQuad.I2cRecoveryMode.values()) {
            if (m.bVal != result) continue;
            return m;
        }
        return OctoQuad.I2cRecoveryMode.NONE;
    }

    @Override
    public void saveParametersToFlash() {
        this.verifyInitialization();
        this.writeRegister(Register.COMMAND, new byte[]{3});
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void setCachingMode(OctoQuad.CachingMode mode) {
        this.cachingMode = mode;
    }

    @Override
    public void refreshCache() {
        this.readAllEncoderData(this.cachedData);
        Arrays.fill(this.posHasBeenRead, false);
        Arrays.fill(this.velHasBeenRead, false);
    }

    @Override
    public int readSinglePosition_Caching(int idx) {
        if (this.cachingMode == OctoQuad.CachingMode.AUTO && this.posHasBeenRead[idx]) {
            this.refreshCache();
        }
        this.posHasBeenRead[idx] = true;
        return this.cachedData.positions[idx];
    }

    @Override
    public short readSingleVelocity_Caching(int idx) {
        if (this.cachingMode == OctoQuad.CachingMode.AUTO && this.velHasBeenRead[idx]) {
            this.refreshCache();
        }
        this.velHasBeenRead[idx] = true;
        return this.cachedData.velocities[idx];
    }

    private void verifyInitialization() {
        if (!this.isInitialized) {
            byte chipId = this.getChipId();
            if (chipId != 81) {
                RobotLog.addGlobalWarningMessage((String)"OctoQuad does not report correct CHIP_ID value; (got 0x%X; expected 0x%X) this likely indicates I2C comms are not working", (Object[])new Object[]{chipId, (byte)81});
            }
            OctoQuad.FirmwareVersion fw = this.getFirmwareVersion();
            if (fw.maj != 3) {
                RobotLog.addGlobalWarningMessage((String)"OctoQuad is running a different major firmware version than this driver was built for (current=%d; expected=%d) IT IS HIGHLY LIKELY THAT NOTHING WILL WORK! You should flash the firmware to a compatible version (Refer to the \"Field-Upgradable Firmware\" section in the OctoQuad datasheet).", (Object[])new Object[]{fw.maj, 3});
            } else if (fw.min < 0) {
                RobotLog.addGlobalWarningMessage((String)"OctoQuad is running an older minor firmware revision than this driver was built for; certain features may not work (current=%d; expected=%d). You should update the firmware on your OctoQuad (Refer to Section 6 in the OctoQuad datasheet).", (Object[])new Object[]{fw.min, 0});
            } else if (fw.min > 0) {
                RobotLog.addGlobalWarningMessage((String)"OctoQuad is running a newer minor firmware revision than this driver was built for; (current=%d; expected=%d). You will not be able to access new features in the updated firmware without an updated I2C driver.", (Object[])new Object[]{fw.min, 0});
            }
            this.isInitialized = true;
        }
    }

    private byte[] readRegister(Register reg) {
        return this.deviceClient.read((int)reg.addr, reg.length);
    }

    private byte[] readContiguousRegisters(Register first, Register last) {
        byte addrStart = first.addr;
        int addrEnd = last.addr + last.length;
        int bytesToRead = addrEnd - addrStart;
        return this.deviceClient.read((int)addrStart, bytesToRead);
    }

    private void writeRegister(Register reg, byte[] bytes) {
        if (reg.length != bytes.length) {
            throw new IllegalArgumentException("reg.length != bytes.length");
        }
        this.deviceClient.write((int)reg.addr, bytes);
    }

    private void writeContiguousRegisters(Register first, Register last, byte[] dat) {
        int addrEnd = last.addr + last.length;
        byte addrStart = first.addr;
        int bytesToWrite = addrEnd - addrStart;
        if (bytesToWrite != dat.length) {
            throw new IllegalArgumentException("bytesToWrite != dat.length");
        }
        this.deviceClient.write((int)addrStart, dat);
    }

    private static short calc_crc16_profibus(byte[] data, int len) {
        int crc = -1;
        for (int i = 0; i < len; ++i) {
            crc = (short)(crc << 8 ^ crc16_profibus_table[(crc >> 8 ^ data[i & 0xFF]) & 0xFF]);
        }
        return (short)(~crc);
    }

    private static short calc_crc16_profibus(byte[] data) {
        return OctoQuadImpl.calc_crc16_profibus(data, data.length);
    }

    static enum Register {
        CHIP_ID(0, RegisterType.uint8_t),
        FIRMWARE_VERSION_MAJOR(1, RegisterType.uint8_t),
        FIRMWARE_VERSION_MINOR(2, RegisterType.uint8_t),
        FIRMWARE_VERSION_ENGINEERING(3, RegisterType.uint8_t),
        COMMAND(4, RegisterType.uint8_t),
        COMMAND_DAT_0(5, RegisterType.uint8_t),
        COMMAND_DAT_1(6, RegisterType.uint8_t),
        COMMAND_DAT_2(7, RegisterType.uint8_t),
        COMMAND_DAT_3(8, RegisterType.uint8_t),
        COMMAND_DAT_4(9, RegisterType.uint8_t),
        COMMAND_DAT_5(10, RegisterType.uint8_t),
        COMMAND_DAT_6(11, RegisterType.uint8_t),
        LOCALIZER_YAW_AXIS(12, RegisterType.uint8_t),
        LOCALIZER_STATUS(13, RegisterType.uint8_t),
        LOCALIZER_VX(14, RegisterType.int16_t),
        LOCALIZER_VY(16, RegisterType.int16_t),
        LOCALIZER_VH(18, RegisterType.int16_t),
        LOCALIZER_X(20, RegisterType.int16_t),
        LOCALIZER_Y(22, RegisterType.int16_t),
        LOCALIZER_H(24, RegisterType.int16_t),
        LOCALIZER_CRC16(26, RegisterType.uint16_t),
        ENCODER_0_POSITION(28, RegisterType.int32_t),
        ENCODER_1_POSITION(32, RegisterType.int32_t),
        ENCODER_2_POSITION(36, RegisterType.int32_t),
        ENCODER_3_POSITION(40, RegisterType.int32_t),
        ENCODER_4_POSITION(44, RegisterType.int32_t),
        ENCODER_5_POSITION(48, RegisterType.int32_t),
        ENCODER_6_POSITION(52, RegisterType.int32_t),
        ENCODER_7_POSITION(56, RegisterType.int32_t),
        ENCODER_0_VELOCITY(60, RegisterType.int16_t),
        ENCODER_1_VELOCITY(62, RegisterType.int16_t),
        ENCODER_2_VELOCITY(64, RegisterType.int16_t),
        ENCODER_3_VELOCITY(66, RegisterType.int16_t),
        ENCODER_4_VELOCITY(68, RegisterType.int16_t),
        ENCODER_5_VELOCITY(70, RegisterType.int16_t),
        ENCODER_6_VELOCITY(72, RegisterType.int16_t),
        ENCODER_7_VELOCITY(74, RegisterType.int16_t),
        ENCODER_DATA_CRC16(76, RegisterType.uint16_t);

        public final byte addr;
        public final int length;

        private Register(int addr, RegisterType type) {
            this.addr = (byte)addr;
            this.length = type.length;
        }
    }

    static enum RegisterType {
        uint8_t(1),
        int32_t(4),
        int16_t(2),
        uint16_t(2),
        float32(4);

        public final int length;

        private RegisterType(int length) {
            this.length = length;
        }
    }
}

