/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.gobilda;

import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.external.navigation.Pose2D;
import org.firstinspires.ftc.robotcore.external.navigation.UnnormalizedAngleUnit;

@I2cDeviceType
@DeviceProperties(name="goBILDA\u00ae Pinpoint Odometry Computer", xmlTag="goBILDAPinpoint", description="goBILDA\u00ae Pinpoint Odometry Computer (IMU Sensor Fusion for 2 Wheel Odometry)")
public class GoBildaPinpointDriver
extends I2cDeviceSynchDevice<I2cDeviceSynchSimple> {
    private int deviceStatus = 0;
    private int loopTime = 0;
    private int xEncoderValue = 0;
    private int yEncoderValue = 0;
    private float xPosition = 0.0f;
    private float yPosition = 0.0f;
    private float hOrientation = 0.0f;
    private float xVelocity = 0.0f;
    private float yVelocity = 0.0f;
    private float hVelocity = 0.0f;
    private static final float goBILDA_SWINGARM_POD = 13.262912f;
    private static final float goBILDA_4_BAR_POD = 19.894367f;
    private static final byte DEFAULT_ADDRESS = 49;

    public GoBildaPinpointDriver(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(deviceClient, deviceClientIsOwned);
        this.deviceClient.setI2cAddress(I2cAddr.create7bit((int)49));
        super.registerArmingStateCallback(false);
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.GoBilda;
    }

    protected synchronized boolean doInitialize() {
        ((LynxI2cDeviceSynch)this.deviceClient).setBusSpeed(LynxI2cDeviceSynch.BusSpeed.FAST_400K);
        return true;
    }

    public String getDeviceName() {
        return "goBILDA\u00ae Pinpoint Odometry Computer";
    }

    private void writeInt(Register reg, int i) {
        this.deviceClient.write(reg.bVal, TypeConversion.intToByteArray((int)i, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
    }

    private int readInt(Register reg) {
        return TypeConversion.byteArrayToInt((byte[])this.deviceClient.read(reg.bVal, 4), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    private float byteArrayToFloat(byte[] byteArray, ByteOrder byteOrder) {
        return ByteBuffer.wrap(byteArray).order(byteOrder).getFloat();
    }

    private float readFloat(Register reg) {
        return this.byteArrayToFloat(this.deviceClient.read(reg.bVal, 4), ByteOrder.LITTLE_ENDIAN);
    }

    private byte[] floatToByteArray(float value, ByteOrder byteOrder) {
        return ByteBuffer.allocate(4).order(byteOrder).putFloat(value).array();
    }

    private void writeByteArray(Register reg, byte[] bytes) {
        this.deviceClient.write(reg.bVal, bytes);
    }

    private void writeFloat(Register reg, float f) {
        byte[] bytes = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(f).array();
        this.deviceClient.write(reg.bVal, bytes);
    }

    private DeviceStatus lookupStatus(int s) {
        boolean yPodDetected;
        if ((s & DeviceStatus.CALIBRATING.status) != 0) {
            return DeviceStatus.CALIBRATING;
        }
        boolean xPodDetected = (s & DeviceStatus.FAULT_X_POD_NOT_DETECTED.status) == 0;
        boolean bl = yPodDetected = (s & DeviceStatus.FAULT_Y_POD_NOT_DETECTED.status) == 0;
        if (!xPodDetected && !yPodDetected) {
            return DeviceStatus.FAULT_NO_PODS_DETECTED;
        }
        if (!xPodDetected) {
            return DeviceStatus.FAULT_X_POD_NOT_DETECTED;
        }
        if (!yPodDetected) {
            return DeviceStatus.FAULT_Y_POD_NOT_DETECTED;
        }
        if ((s & DeviceStatus.FAULT_IMU_RUNAWAY.status) != 0) {
            return DeviceStatus.FAULT_IMU_RUNAWAY;
        }
        if ((s & DeviceStatus.READY.status) != 0) {
            return DeviceStatus.READY;
        }
        if ((s & DeviceStatus.FAULT_BAD_READ.status) != 0) {
            return DeviceStatus.FAULT_BAD_READ;
        }
        return DeviceStatus.NOT_READY;
    }

    private Float isPositionCorrupt(float oldValue, float newValue, int threshold, boolean bulkUpdate) {
        boolean isCorrupt;
        boolean noData = bulkUpdate && this.loopTime < 1;
        boolean bl = isCorrupt = noData || Float.isNaN(newValue) || Math.abs(newValue - oldValue) > (float)threshold;
        if (!isCorrupt) {
            return Float.valueOf(newValue);
        }
        this.deviceStatus = DeviceStatus.FAULT_BAD_READ.status;
        return Float.valueOf(oldValue);
    }

    private Float isVelocityCorrupt(float oldValue, float newValue, int threshold) {
        boolean noData;
        boolean isCorrupt = Float.isNaN(newValue) || Math.abs(newValue) > (float)threshold;
        boolean bl = noData = this.loopTime <= 1;
        if (!isCorrupt) {
            return Float.valueOf(newValue);
        }
        this.deviceStatus = DeviceStatus.FAULT_BAD_READ.status;
        return Float.valueOf(oldValue);
    }

    public void update() {
        int positionThreshold = 5000;
        int headingThreshold = 120;
        int velocityThreshold = 10000;
        int headingVelocityThreshold = 120;
        float oldPosX = this.xPosition;
        float oldPosY = this.yPosition;
        float oldPosH = this.hOrientation;
        float oldVelX = this.xVelocity;
        float oldVelY = this.yVelocity;
        float oldVelH = this.hVelocity;
        byte[] bArr = this.deviceClient.read(Register.BULK_READ.bVal, 40);
        this.deviceStatus = TypeConversion.byteArrayToInt((byte[])Arrays.copyOfRange(bArr, 0, 4), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.loopTime = TypeConversion.byteArrayToInt((byte[])Arrays.copyOfRange(bArr, 4, 8), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.xEncoderValue = TypeConversion.byteArrayToInt((byte[])Arrays.copyOfRange(bArr, 8, 12), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.yEncoderValue = TypeConversion.byteArrayToInt((byte[])Arrays.copyOfRange(bArr, 12, 16), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.xPosition = this.byteArrayToFloat(Arrays.copyOfRange(bArr, 16, 20), ByteOrder.LITTLE_ENDIAN);
        this.yPosition = this.byteArrayToFloat(Arrays.copyOfRange(bArr, 20, 24), ByteOrder.LITTLE_ENDIAN);
        this.hOrientation = this.byteArrayToFloat(Arrays.copyOfRange(bArr, 24, 28), ByteOrder.LITTLE_ENDIAN);
        this.xVelocity = this.byteArrayToFloat(Arrays.copyOfRange(bArr, 28, 32), ByteOrder.LITTLE_ENDIAN);
        this.yVelocity = this.byteArrayToFloat(Arrays.copyOfRange(bArr, 32, 36), ByteOrder.LITTLE_ENDIAN);
        this.hVelocity = this.byteArrayToFloat(Arrays.copyOfRange(bArr, 36, 40), ByteOrder.LITTLE_ENDIAN);
        this.xPosition = this.isPositionCorrupt(oldPosX, this.xPosition, 5000, true).floatValue();
        this.yPosition = this.isPositionCorrupt(oldPosY, this.yPosition, 5000, true).floatValue();
        this.hOrientation = this.isPositionCorrupt(oldPosH, this.hOrientation, 120, true).floatValue();
        this.xVelocity = this.isVelocityCorrupt(oldVelX, this.xVelocity, 10000).floatValue();
        this.yVelocity = this.isVelocityCorrupt(oldVelY, this.yVelocity, 10000).floatValue();
        this.hVelocity = this.isVelocityCorrupt(oldVelH, this.hVelocity, 120).floatValue();
    }

    public void update(ReadData data) {
        if (data == ReadData.ONLY_UPDATE_HEADING) {
            int headingThreshold = 120;
            float oldPosH = this.hOrientation;
            this.hOrientation = this.byteArrayToFloat(this.deviceClient.read(Register.H_ORIENTATION.bVal, 4), ByteOrder.LITTLE_ENDIAN);
            this.hOrientation = this.isPositionCorrupt(oldPosH, this.hOrientation, 120, false).floatValue();
            if (this.deviceStatus == DeviceStatus.FAULT_BAD_READ.status) {
                this.deviceStatus = DeviceStatus.READY.status;
            }
        }
    }

    public void setOffsets(double xOffset, double yOffset, DistanceUnit distanceUnit) {
        this.writeFloat(Register.X_POD_OFFSET, (float)distanceUnit.toMm(xOffset));
        this.writeFloat(Register.Y_POD_OFFSET, (float)distanceUnit.toMm(yOffset));
    }

    public void recalibrateIMU() {
        this.writeInt(Register.DEVICE_CONTROL, DeviceControl.RECALIBRATE_IMU.value);
    }

    public void resetPosAndIMU() {
        this.writeInt(Register.DEVICE_CONTROL, DeviceControl.RESET_POS_AND_IMU.value);
    }

    public void setEncoderDirections(EncoderDirection xEncoder, EncoderDirection yEncoder) {
        if (xEncoder == EncoderDirection.FORWARD) {
            this.writeInt(Register.DEVICE_CONTROL, DeviceControl.SET_X_ENCODER_FORWARD.value);
        }
        if (xEncoder == EncoderDirection.REVERSED) {
            this.writeInt(Register.DEVICE_CONTROL, DeviceControl.SET_X_ENCODER_REVERSED.value);
        }
        if (yEncoder == EncoderDirection.FORWARD) {
            this.writeInt(Register.DEVICE_CONTROL, DeviceControl.SET_Y_ENCODER_FORWARD.value);
        }
        if (yEncoder == EncoderDirection.REVERSED) {
            this.writeInt(Register.DEVICE_CONTROL, DeviceControl.SET_Y_ENCODER_REVERSED.value);
        }
    }

    public void setEncoderResolution(GoBildaOdometryPods pods) {
        if (pods == GoBildaOdometryPods.goBILDA_SWINGARM_POD) {
            this.setEncoderResolution(13.262911796569824, DistanceUnit.MM);
        }
        if (pods == GoBildaOdometryPods.goBILDA_4_BAR_POD) {
            this.setEncoderResolution(19.894367218017578, DistanceUnit.MM);
        }
    }

    public void setEncoderResolution(double ticksPerUnit, DistanceUnit distanceUnit) {
        double resolution = distanceUnit.toMm(ticksPerUnit);
        this.writeByteArray(Register.TICKS_PER_MM, this.floatToByteArray((float)resolution, ByteOrder.LITTLE_ENDIAN));
    }

    public void setYawScalar(double yawScalar) {
        this.writeByteArray(Register.YAW_SCALAR, this.floatToByteArray((float)yawScalar, ByteOrder.LITTLE_ENDIAN));
    }

    public void setPosition(Pose2D pos) {
        this.setPosX(pos.getX(DistanceUnit.MM), DistanceUnit.MM);
        this.setPosY(pos.getY(DistanceUnit.MM), DistanceUnit.MM);
        this.setHeading(pos.getHeading(AngleUnit.RADIANS), AngleUnit.RADIANS);
    }

    public void setPosX(double posX, DistanceUnit distanceUnit) {
        this.writeByteArray(Register.X_POSITION, this.floatToByteArray((float)distanceUnit.toMm(posX), ByteOrder.LITTLE_ENDIAN));
    }

    public void setPosY(double posY, DistanceUnit distanceUnit) {
        this.writeByteArray(Register.Y_POSITION, this.floatToByteArray((float)distanceUnit.toMm(posY), ByteOrder.LITTLE_ENDIAN));
    }

    public void setHeading(double heading, AngleUnit angleUnit) {
        this.writeByteArray(Register.H_ORIENTATION, this.floatToByteArray((float)angleUnit.toRadians(heading), ByteOrder.LITTLE_ENDIAN));
    }

    public int getDeviceID() {
        return this.readInt(Register.DEVICE_ID);
    }

    public int getDeviceVersion() {
        return this.readInt(Register.DEVICE_VERSION);
    }

    public float getYawScalar() {
        return this.readFloat(Register.YAW_SCALAR);
    }

    public DeviceStatus getDeviceStatus() {
        return this.lookupStatus(this.deviceStatus);
    }

    public int getLoopTime() {
        return this.loopTime;
    }

    public double getFrequency() {
        if (this.loopTime != 0) {
            return 1000000.0 / (double)this.loopTime;
        }
        return 0.0;
    }

    public int getEncoderX() {
        return this.xEncoderValue;
    }

    public int getEncoderY() {
        return this.yEncoderValue;
    }

    public double getPosX(DistanceUnit distanceUnit) {
        return distanceUnit.fromMm((double)this.xPosition);
    }

    public double getPosY(DistanceUnit distanceUnit) {
        return distanceUnit.fromMm((double)this.yPosition);
    }

    public double getHeading(AngleUnit angleUnit) {
        return angleUnit.fromRadians(this.hOrientation);
    }

    public double getHeading(UnnormalizedAngleUnit unnormalizedAngleUnit) {
        return unnormalizedAngleUnit.fromRadians(this.hOrientation);
    }

    public double getVelX(DistanceUnit distanceUnit) {
        return distanceUnit.fromMm((double)this.xVelocity);
    }

    public double getVelY(DistanceUnit distanceUnit) {
        return distanceUnit.fromMm((double)this.yVelocity);
    }

    public double getHeadingVelocity(UnnormalizedAngleUnit unnormalizedAngleUnit) {
        return unnormalizedAngleUnit.fromRadians(this.hVelocity);
    }

    public float getXOffset(DistanceUnit distanceUnit) {
        return (float)distanceUnit.fromMm((double)this.readFloat(Register.X_POD_OFFSET));
    }

    public float getYOffset(DistanceUnit distanceUnit) {
        return (float)distanceUnit.fromMm((double)this.readFloat(Register.Y_POD_OFFSET));
    }

    public Pose2D getPosition() {
        return new Pose2D(DistanceUnit.MM, (double)this.xPosition, (double)this.yPosition, AngleUnit.RADIANS, (double)AngleUnit.normalizeRadians((float)this.hOrientation));
    }

    private static enum Register {
        DEVICE_ID(1),
        DEVICE_VERSION(2),
        DEVICE_STATUS(3),
        DEVICE_CONTROL(4),
        LOOP_TIME(5),
        X_ENCODER_VALUE(6),
        Y_ENCODER_VALUE(7),
        X_POSITION(8),
        Y_POSITION(9),
        H_ORIENTATION(10),
        X_VELOCITY(11),
        Y_VELOCITY(12),
        H_VELOCITY(13),
        TICKS_PER_MM(14),
        X_POD_OFFSET(15),
        Y_POD_OFFSET(16),
        YAW_SCALAR(17),
        BULK_READ(18);

        private final int bVal;

        private Register(int bVal) {
            this.bVal = bVal;
        }
    }

    public static enum DeviceStatus {
        NOT_READY(0),
        READY(1),
        CALIBRATING(2),
        FAULT_X_POD_NOT_DETECTED(4),
        FAULT_Y_POD_NOT_DETECTED(8),
        FAULT_NO_PODS_DETECTED(12),
        FAULT_IMU_RUNAWAY(16),
        FAULT_BAD_READ(32);

        private final int status;

        private DeviceStatus(int status) {
            this.status = status;
        }
    }

    public static enum ReadData {
        ONLY_UPDATE_HEADING;

    }

    private static enum DeviceControl {
        RECALIBRATE_IMU(1),
        RESET_POS_AND_IMU(2),
        SET_X_ENCODER_REVERSED(16),
        SET_X_ENCODER_FORWARD(32),
        SET_Y_ENCODER_REVERSED(4),
        SET_Y_ENCODER_FORWARD(8);

        public final int value;

        private DeviceControl(int value) {
            this.value = value;
        }
    }

    public static enum EncoderDirection {
        FORWARD,
        REVERSED;

    }

    public static enum GoBildaOdometryPods {
        goBILDA_SWINGARM_POD,
        goBILDA_4_BAR_POD;

    }
}

