/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.limelightvision;

import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.json.JSONObject;

public class LLStatus {
    private Quaternion cameraQuat = new Quaternion(1.0f, 0.0f, 0.0f, 0.0f, 0L);
    private int cid = 0;
    private double cpu = 0.0;
    private double finalYaw = 0.0;
    private double fps = 0.0;
    private int hwType = 0;
    private int ignoreNT = 0;
    private int interfaceNeedsRefresh = 0;
    private String name = "";
    private int pipeImgCount = 0;
    private int pipelineIndex = 0;
    private String pipelineType = "";
    private double ram = 0.0;
    private int snapshotMode = 0;
    private double temp = 0.0;

    public LLStatus() {
    }

    protected LLStatus(JSONObject json) {
        this();
        if (json != null) {
            try {
                JSONObject quatObj = json.optJSONObject("cameraQuat");
                if (quatObj != null) {
                    this.cameraQuat.w = (float)quatObj.optDouble("w", 1.0);
                    this.cameraQuat.x = (float)quatObj.optDouble("x", 0.0);
                    this.cameraQuat.y = (float)quatObj.optDouble("y", 0.0);
                    this.cameraQuat.z = (float)quatObj.optDouble("z", 0.0);
                }
                this.cid = json.optInt("cid", 0);
                this.cpu = json.optDouble("cpu", 0.0);
                this.finalYaw = json.optDouble("finalYaw", 0.0);
                this.fps = json.optDouble("fps", 0.0);
                this.hwType = json.optInt("hwType", 0);
                this.ignoreNT = json.optInt("ignoreNT", 0);
                this.interfaceNeedsRefresh = json.optInt("interfaceNeedsRefresh", 0);
                this.name = json.optString("name", "");
                this.pipeImgCount = json.optInt("pipeImgCount", 0);
                this.pipelineIndex = json.optInt("pipelineIndex", 0);
                this.pipelineType = json.optString("pipelineType", "");
                this.ram = json.optDouble("ram", 0.0);
                this.snapshotMode = json.optInt("snapshotMode", 0);
                this.temp = json.optDouble("temp", 0.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Quaternion getCameraQuat() {
        return this.cameraQuat;
    }

    public int getCid() {
        return this.cid;
    }

    public double getCpu() {
        return this.cpu;
    }

    public double getFinalYaw() {
        return this.finalYaw;
    }

    public double getFps() {
        return this.fps;
    }

    public int getHwType() {
        return this.hwType;
    }

    private int getIgnoreNT() {
        return this.ignoreNT;
    }

    private int getInterfaceNeedsRefresh() {
        return this.interfaceNeedsRefresh;
    }

    public String getName() {
        return this.name;
    }

    public int getPipeImgCount() {
        return this.pipeImgCount;
    }

    public int getPipelineIndex() {
        return this.pipelineIndex;
    }

    public String getPipelineType() {
        return this.pipelineType;
    }

    public double getRam() {
        return this.ram;
    }

    public int getSnapshotMode() {
        return this.snapshotMode;
    }

    public double getTemp() {
        return this.temp;
    }

    public String toString() {
        return "LLStatus{cameraQuat=" + this.cameraQuat.toString() + ", cid=" + this.cid + ", cpu=" + this.cpu + ", finalYaw=" + this.finalYaw + ", fps=" + this.fps + ", hwType=" + this.hwType + ", ignoreNT=" + this.ignoreNT + ", interfaceNeedsRefresh=" + this.interfaceNeedsRefresh + ", name='" + this.name + '\'' + ", pipeImgCount=" + this.pipeImgCount + ", pipelineIndex=" + this.pipelineIndex + ", pipelineType='" + this.pipelineType + '\'' + ", ram=" + this.ram + ", snapshotMode=" + this.snapshotMode + ", temp=" + this.temp + '}';
    }
}

