/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.limelightvision;

import com.qualcomm.hardware.limelightvision.LLFieldMap;
import com.qualcomm.hardware.limelightvision.LLResult;
import com.qualcomm.hardware.limelightvision.LLResultTypes;
import com.qualcomm.hardware.limelightvision.LLStatus;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.util.SerialNumber;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.firstinspires.ftc.robotcore.internal.usb.EthernetOverUsbSerialNumber;
import org.json.JSONArray;
import org.json.JSONObject;

public class Limelight3A
implements HardwareDevice {
    private static final String TAG = "Limelight3A";
    private InetAddress inetAddress;
    private EthernetOverUsbSerialNumber serialNumber;
    private String name;
    private final String baseUrl;
    private volatile LLResult latestResult;
    private volatile ScheduledExecutorService executor;
    private final Object executorLock = new Object();
    private final AtomicInteger state = new AtomicInteger(0);
    private static final int STOPPED = 0;
    private static final int STARTING = 1;
    private static final int RUNNING = 2;
    private volatile boolean isExecutorInitialized = false;
    private volatile long lastUpdateTime = 0L;
    private static final long ISCONNECTED_THRESHOLD = 250L;
    private static final int CONNECTION_TIMEOUT = 100;
    private static final int GETREQUEST_TIMEOUT = 100;
    private static final int POSTREQUEST_TIMEOUT = 15000;
    private static final int DELETEREQUEST_TIMEOUT = 15000;
    private static final int PYTHON_INPUT_MAX_SIZE = 32;
    private long pollIntervalMs = 10L;
    private static final int MIN_POLL_RATE_HZ = 1;
    private static final int MAX_POLL_RATE_HZ = 250;

    public Limelight3A(SerialNumber serialNumber, String name, InetAddress ipAddress) {
        this.name = name;
        this.serialNumber = (EthernetOverUsbSerialNumber)serialNumber;
        this.inetAddress = ipAddress;
        this.baseUrl = "http://" + ipAddress.getHostAddress() + ":5807";
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureExecutorRunning() {
        Object object = this.executorLock;
        synchronized (object) {
            if (this.executor == null || this.executor.isShutdown()) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.isExecutorInitialized = false;
            }
        }
    }

    public synchronized void start() {
        if (!this.state.compareAndSet(0, 1)) {
            return;
        }
        try {
            this.ensureExecutorRunning();
            if (!this.isExecutorInitialized) {
                this.executor.scheduleAtFixedRate(this::updateLatestResult, 0L, this.pollIntervalMs, TimeUnit.MILLISECONDS);
                this.isExecutorInitialized = true;
            }
            this.state.set(2);
        }
        catch (Exception e) {
            this.state.set(0);
        }
    }

    public synchronized void pause() {
        if (this.state.get() == 2) {
            this.state.set(0);
        }
    }

    public synchronized void stop() {
        this.state.set(0);
        this.isExecutorInitialized = false;
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    public boolean isRunning() {
        return this.state.get() == 2;
    }

    public synchronized void setPollRateHz(int rateHz) {
        if (this.state.get() == 2) {
            return;
        }
        int clampedRate = Math.max(1, Math.min(rateHz, 250));
        this.pollIntervalMs = 1000 / clampedRate;
    }

    public long getTimeSinceLastUpdate() {
        return System.currentTimeMillis() - this.lastUpdateTime;
    }

    public boolean isConnected() {
        return this.getTimeSinceLastUpdate() <= 250L;
    }

    private void updateLatestResult() {
        if (this.state.get() != 2) {
            return;
        }
        try {
            JSONObject result = this.sendGetRequest("/results");
            if (result != null) {
                this.latestResult = LLResult.parse(result);
                this.lastUpdateTime = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LLResult getLatestResult() {
        if (this.latestResult == null) {
            JSONObject fakeJSON = new JSONObject();
            this.latestResult = LLResult.parse(fakeJSON);
        }
        return this.latestResult;
    }

    public LLStatus getStatus() {
        JSONObject statusJson = this.sendGetRequest("/status");
        if (statusJson == null) {
            return new LLStatus();
        }
        return new LLStatus(statusJson);
    }

    private JSONObject getHWReport() {
        return this.sendGetRequest("/hwreport");
    }

    public boolean reloadPipeline() {
        return this.sendPostRequest("/reload-pipeline", null);
    }

    private JSONObject getPipelineDefault() {
        return this.sendGetRequest("/pipeline-default");
    }

    private JSONObject getPipelineAtIndex(int index) {
        return this.sendGetRequest("/pipeline-atindex?index=" + index);
    }

    public boolean pipelineSwitch(int index) {
        return this.sendPostRequest("/pipeline-switch?index=" + index, null);
    }

    private JSONObject getSnapscriptNames() {
        return this.sendGetRequest("/getsnapscriptnames");
    }

    public boolean captureSnapshot(String snapname) {
        return this.sendPostRequest("/capture-snapshot?snapname=" + snapname, null);
    }

    private JSONObject snapshotManifest() {
        return this.sendGetRequest("/snapshotmanifest");
    }

    public boolean deleteSnapshots() {
        return this.sendDeleteRequest("/delete-snapshots");
    }

    public boolean deleteSnapshot(String snapname) {
        return this.sendDeleteRequest("/delete-snapshot?snapname=" + snapname);
    }

    private boolean updatePipeline(JSONObject profileJson, boolean flush) {
        String url = "/update-pipeline" + (flush ? "?flush=1" : "");
        return this.sendPostRequest(url, profileJson.toString());
    }

    public boolean updatePythonInputs(double input1, double input2, double input3, double input4, double input5, double input6, double input7, double input8) {
        double[] inputs = new double[]{input1, input2, input3, input4, input5, input6, input7, input8};
        return this.updatePythonInputs(inputs);
    }

    public boolean updatePythonInputs(double[] inputs) {
        if (inputs == null || inputs.length == 0 || inputs.length > 32) {
            return false;
        }
        try {
            JSONArray jsonArray = new JSONArray((Object)inputs);
            return this.sendPostRequest("/update-pythoninputs", jsonArray.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean updateRobotOrientation(double yaw) {
        double[] orientationData = new double[]{yaw, 0.0, 0.0, 0.0, 0.0, 0.0};
        try {
            JSONArray jsonArray = new JSONArray((Object)orientationData);
            return this.sendPostRequest("/update-robotorientation", jsonArray.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean uploadPipeline(JSONObject profileJson, Integer index) {
        String url = "/upload-pipeline" + (index != null ? "?index=" + index : "");
        return this.sendPostRequest(url, profileJson.toString());
    }

    public boolean uploadPipeline(String jsonString, Integer index) {
        String url = "/upload-pipeline" + (index != null ? "?index=" + index : "");
        return this.sendPostRequest(url, jsonString);
    }

    public boolean uploadFieldmap(LLFieldMap fieldmap, Integer index) {
        if (!fieldmap.isValid()) {
            return false;
        }
        String url = "/upload-fieldmap" + (index != null ? "?index=" + index : "");
        return this.sendPostRequest(url, fieldmap.toJson().toString());
    }

    public boolean uploadPython(String pythonString, Integer index) {
        String url = "/upload-python" + (index != null ? "?index=" + index : "");
        return this.sendPostRequest(url, pythonString);
    }

    public LLResultTypes.CalibrationResult getCalDefault() {
        JSONObject calData = this.sendGetRequest("/cal-default");
        return new LLResultTypes.CalibrationResult(calData);
    }

    public LLResultTypes.CalibrationResult getCalFile() {
        JSONObject calData = this.sendGetRequest("/cal-file");
        return new LLResultTypes.CalibrationResult(calData);
    }

    public LLResultTypes.CalibrationResult getCalEEPROM() {
        JSONObject calData = this.sendGetRequest("/cal-eeprom");
        return new LLResultTypes.CalibrationResult(calData);
    }

    public LLResultTypes.CalibrationResult getCalLatest() {
        JSONObject calData = this.sendGetRequest("/cal-latest");
        return new LLResultTypes.CalibrationResult(calData);
    }

    private boolean updateCalEEPROM(LLResultTypes.CalibrationResult calResult) {
        return this.sendPostRequest("/cal-eeprom", calResult.toJson().toString());
    }

    private boolean updateCalFile(LLResultTypes.CalibrationResult calResult) {
        return this.sendPostRequest("/cal-file", calResult.toJson().toString());
    }

    private boolean deleteCalLatest() {
        return this.sendDeleteRequest("/cal-latest");
    }

    private boolean deleteCalEEPROM() {
        return this.sendDeleteRequest("/cal-eeprom");
    }

    private boolean deleteCalFile() {
        return this.sendDeleteRequest("/cal-file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject sendGetRequest(String endpoint) {
        HttpURLConnection connection = null;
        try {
            String urlString = this.baseUrl + endpoint;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(100);
            connection.setConnectTimeout(100);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String response = this.readResponse(connection);
                JSONObject jSONObject = new JSONObject(response);
                return jSONObject;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPostRequest(String endpoint, String data) {
        HttpURLConnection connection = null;
        try {
            int responseCode;
            String urlString = this.baseUrl + endpoint;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setReadTimeout(15000);
            connection.setConnectTimeout(100);
            if (data != null) {
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = data.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDeleteRequest(String endpoint) {
        HttpURLConnection connection = null;
        try {
            String urlString = this.baseUrl + endpoint;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setReadTimeout(15000);
            connection.setConnectTimeout(100);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    public void shutdown() {
        this.stop();
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.LimelightVision;
    }

    public String getDeviceName() {
        return this.name;
    }

    public String getConnectionInfo() {
        return this.serialNumber.toString();
    }

    public int getVersion() {
        return 0;
    }

    public void resetDeviceConfigurationForOpMode() {
    }

    public void close() {
        this.stop();
    }
}

