/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.exception.TargetPositionNotSetException;
import com.qualcomm.robotcore.util.RobotLog;

public class LynxCommExceptionHandler {
    protected String tag = "RobotCore";

    protected String getTag() {
        return this.tag;
    }

    public LynxCommExceptionHandler() {
    }

    public LynxCommExceptionHandler(String tag) {
        this.tag = tag;
    }

    protected boolean handleException(Exception e) {
        boolean commandIsSupported = true;
        if (e instanceof InterruptedException) {
            this.handleSpecificException((InterruptedException)e);
        } else {
            if (e instanceof OpModeManagerImpl.ForceStopException) {
                throw (OpModeManagerImpl.ForceStopException)e;
            }
            if (e instanceof LynxNackException) {
                LynxNackException nackException = (LynxNackException)e;
                this.handleSpecificException(nackException);
                if (nackException.getNack().getNackReasonCode().isUnsupportedReason()) {
                    commandIsSupported = false;
                }
            } else if (e instanceof TargetPositionNotSetException) {
                this.handleSpecificException((TargetPositionNotSetException)e);
            } else if (e instanceof RuntimeException) {
                this.handleSpecificException((RuntimeException)e);
            } else {
                RobotLog.ee((String)this.getTag(), (Throwable)e, (String)"unexpected exception thrown during lynx communication");
            }
        }
        return commandIsSupported;
    }

    protected void handleSpecificException(InterruptedException e) {
        Thread.currentThread().interrupt();
    }

    protected void handleSpecificException(TargetPositionNotSetException e) {
        throw e;
    }

    protected void handleSpecificException(RuntimeException e) {
        RobotLog.ee((String)this.getTag(), (Throwable)e, (String)"exception thrown during lynx communication");
    }

    protected void handleSpecificException(LynxNackException nackException) {
        switch (nackException.getNack().getNackReasonCodeAsEnum()) {
            case ABANDONED_WAITING_FOR_ACK: 
            case ABANDONED_WAITING_FOR_RESPONSE: {
                break;
            }
            case CANCELLED_FOR_SAFETY: {
                break;
            }
            case COMMAND_IMPL_PENDING: {
                RobotLog.ww((String)this.getTag(), (String)"%s not implemented by lynx hw; ignoring", (Object[])new Object[]{nackException.getCommand().getClass().getSimpleName()});
                break;
            }
            case COMMAND_ROUTING_ERROR: {
                RobotLog.ee((String)this.getTag(), (String)"%s not delivered in module mod#=%d cmd#=%d", (Object[])new Object[]{nackException.getCommand().getClass().getSimpleName(), nackException.getNack().getModuleAddress(), nackException.getNack().getCommandNumber()});
                break;
            }
            case PACKET_TYPE_ID_UNKNOWN: {
                RobotLog.ee((String)this.getTag(), (String)"%s not supported by module mod#=%d cmd#=%d", (Object[])new Object[]{nackException.getCommand().getClass().getSimpleName(), nackException.getNack().getModuleAddress(), nackException.getNack().getCommandNumber()});
                break;
            }
            case BATTERY_TOO_LOW_TO_RUN_MOTOR: 
            case BATTERY_TOO_LOW_TO_RUN_SERVO: {
                break;
            }
            default: {
                RobotLog.ee((String)this.getTag(), (Throwable)nackException, (String)"exception thrown during lynx communication");
            }
        }
    }
}

